/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.usermodel;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.poi.POIXMLDocument;
import org.apache.poi.POIXMLDocumentPart;
import org.apache.poi.POIXMLException;
import org.apache.poi.POIXMLProperties;
import org.apache.poi.POIXMLRelation;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackagePartName;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.openxml4j.opc.PackagingURIHelper;
import org.apache.poi.openxml4j.opc.TargetMode;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.IdentifierManager;
import org.apache.poi.util.PackageHelper;
import org.apache.poi.xwpf.model.XWPFHeaderFooterPolicy;
import org.apache.poi.xwpf.usermodel.BodyElementType;
import org.apache.poi.xwpf.usermodel.BodyType;
import org.apache.poi.xwpf.usermodel.Document;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.IBodyElement;
import org.apache.poi.xwpf.usermodel.TOC;
import org.apache.poi.xwpf.usermodel.XWPFComment;
import org.apache.poi.xwpf.usermodel.XWPFFactory;
import org.apache.poi.xwpf.usermodel.XWPFFooter;
import org.apache.poi.xwpf.usermodel.XWPFFootnote;
import org.apache.poi.xwpf.usermodel.XWPFFootnotes;
import org.apache.poi.xwpf.usermodel.XWPFHeader;
import org.apache.poi.xwpf.usermodel.XWPFHyperlink;
import org.apache.poi.xwpf.usermodel.XWPFNumbering;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFPictureData;
import org.apache.poi.xwpf.usermodel.XWPFRelation;
import org.apache.poi.xwpf.usermodel.XWPFSettings;
import org.apache.poi.xwpf.usermodel.XWPFStyles;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTComment;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDocument1;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTFtnEdn;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSdtBlock;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTStyles;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTbl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CommentsDocument;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.DocumentDocument;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.EndnotesDocument;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.FootnotesDocument;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.NumberingDocument;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STDocProtect;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.StylesDocument;

public class XWPFDocument
extends POIXMLDocument
implements Document,
IBody {
    private CTDocument1 ctDocument;
    private XWPFSettings settings;
    private IdentifierManager drawingIdManager = new IdentifierManager(1L, 0xFFFFFFFFL);
    protected List footers = new ArrayList();
    protected List headers = new ArrayList();
    protected List comments = new ArrayList();
    protected List hyperlinks = new ArrayList();
    protected List paragraphs = new ArrayList();
    protected List tables = new ArrayList();
    protected List bodyElements = new ArrayList();
    protected List pictures = new ArrayList();
    protected Map packagePictures = new HashMap();
    protected Map endnotes = new HashMap();
    protected XWPFNumbering numbering;
    protected XWPFStyles styles;
    protected XWPFFootnotes footnotes;
    private XWPFHeaderFooterPolicy headerFooterPolicy;

    public XWPFDocument(OPCPackage pkg) throws IOException {
        super(pkg);
        this.load(XWPFFactory.getInstance());
    }

    public XWPFDocument(InputStream is) throws IOException {
        super(PackageHelper.open(is));
        this.load(XWPFFactory.getInstance());
    }

    public XWPFDocument() {
        super(XWPFDocument.newPackage());
        this.onDocumentCreate();
    }

    protected void onDocumentRead() throws IOException {
        try {
            Object p;
            DocumentDocument doc = DocumentDocument.Factory.parse((InputStream)this.getPackagePart().getInputStream());
            this.ctDocument = doc.getDocument();
            this.initFootnotes();
            XmlCursor cursor = this.ctDocument.getBody().newCursor();
            cursor.selectPath("./*");
            while (cursor.toNextSelection()) {
                XmlObject o = cursor.getObject();
                if (o instanceof CTP) {
                    p = new XWPFParagraph((CTP)o, this);
                    this.bodyElements.add(p);
                    this.paragraphs.add(p);
                    continue;
                }
                if (!(o instanceof CTTbl)) continue;
                XWPFTable t = new XWPFTable((CTTbl)o, this);
                this.bodyElements.add(t);
                this.tables.add(t);
            }
            cursor.dispose();
            if (doc.getDocument().getBody().getSectPr() != null) {
                this.headerFooterPolicy = new XWPFHeaderFooterPolicy(this);
            }
            Iterator iterator = this.getRelations().iterator();
            while (iterator.hasNext()) {
                p = (POIXMLDocumentPart)iterator.next();
                String relation = ((POIXMLDocumentPart)p).getPackageRelationship().getRelationshipType();
                if (relation.equals(XWPFRelation.STYLES.getRelation())) {
                    this.styles = (XWPFStyles)p;
                    this.styles.onDocumentRead();
                    continue;
                }
                if (relation.equals(XWPFRelation.NUMBERING.getRelation())) {
                    this.numbering = (XWPFNumbering)p;
                    this.numbering.onDocumentRead();
                    continue;
                }
                if (relation.equals(XWPFRelation.FOOTER.getRelation())) {
                    XWPFFooter footer = (XWPFFooter)p;
                    this.footers.add(footer);
                    footer.onDocumentRead();
                    continue;
                }
                if (relation.equals(XWPFRelation.HEADER.getRelation())) {
                    XWPFHeader header = (XWPFHeader)p;
                    this.headers.add(header);
                    header.onDocumentRead();
                    continue;
                }
                if (relation.equals(XWPFRelation.COMMENT.getRelation())) {
                    CommentsDocument cmntdoc = CommentsDocument.Factory.parse((InputStream)((POIXMLDocumentPart)p).getPackagePart().getInputStream());
                    Iterator<CTComment> iterator2 = Arrays.asList(cmntdoc.getComments().getCommentArray()).iterator();
                    while (iterator2.hasNext()) {
                        CTComment ctcomment = iterator2.next();
                        this.comments.add(new XWPFComment(ctcomment, this));
                    }
                    continue;
                }
                if (relation.equals(XWPFRelation.SETTINGS.getRelation())) {
                    this.settings = (XWPFSettings)p;
                    this.settings.onDocumentRead();
                    continue;
                }
                if (relation.equals(XWPFRelation.IMAGES.getRelation())) {
                    XWPFPictureData picData = (XWPFPictureData)p;
                    picData.onDocumentRead();
                    this.registerPackagePictureData(picData);
                    this.pictures.add(picData);
                    continue;
                }
                if (!relation.equals(XWPFRelation.GLOSSARY_DOCUMENT.getRelation())) continue;
                Iterator iterator2 = ((POIXMLDocumentPart)p).getRelations().iterator();
                while (iterator2.hasNext()) {
                    POIXMLDocumentPart gp = (POIXMLDocumentPart)iterator2.next();
                    try {
                        Method onDocumentRead = gp.getClass().getDeclaredMethod("onDocumentRead", null);
                        onDocumentRead.setAccessible(true);
                        onDocumentRead.invoke((Object)gp, null);
                    }
                    catch (Exception e) {
                        throw new POIXMLException(e);
                    }
                }
            }
            this.initHyperlinks();
        }
        catch (XmlException e) {
            throw new POIXMLException(e);
        }
    }

    private void initHyperlinks() {
        try {
            Iterator relIter = this.getPackagePart().getRelationshipsByType(XWPFRelation.HYPERLINK.getRelation()).iterator();
            while (relIter.hasNext()) {
                PackageRelationship rel = (PackageRelationship)relIter.next();
                this.hyperlinks.add(new XWPFHyperlink(rel.getId(), rel.getTargetURI().toString()));
            }
        }
        catch (InvalidFormatException e) {
            throw new POIXMLException(e);
        }
    }

    private void initFootnotes() throws XmlException, IOException {
        Iterator iterator = this.getRelations().iterator();
        while (iterator.hasNext()) {
            CTFtnEdn ctFtnEdn;
            Iterator<CTFtnEdn> iterator2;
            POIXMLDocumentPart p = (POIXMLDocumentPart)iterator.next();
            String relation = p.getPackageRelationship().getRelationshipType();
            if (relation.equals(XWPFRelation.FOOTNOTE.getRelation())) {
                FootnotesDocument footnotesDocument = FootnotesDocument.Factory.parse((InputStream)p.getPackagePart().getInputStream());
                this.footnotes = (XWPFFootnotes)p;
                this.footnotes.onDocumentRead();
                iterator2 = Arrays.asList(footnotesDocument.getFootnotes().getFootnoteArray()).iterator();
                while (iterator2.hasNext()) {
                    ctFtnEdn = iterator2.next();
                    this.footnotes.addFootnote(ctFtnEdn);
                }
                continue;
            }
            if (!relation.equals(XWPFRelation.ENDNOTE.getRelation())) continue;
            EndnotesDocument endnotesDocument = EndnotesDocument.Factory.parse((InputStream)p.getPackagePart().getInputStream());
            iterator2 = Arrays.asList(endnotesDocument.getEndnotes().getEndnoteArray()).iterator();
            while (iterator2.hasNext()) {
                ctFtnEdn = iterator2.next();
                this.endnotes.put(new Integer(ctFtnEdn.getId().intValue()), new XWPFFootnote(this, ctFtnEdn));
            }
        }
    }

    protected static OPCPackage newPackage() {
        try {
            OPCPackage pkg = OPCPackage.create(new ByteArrayOutputStream());
            PackagePartName corePartName = PackagingURIHelper.createPartName(XWPFRelation.DOCUMENT.getDefaultFileName());
            pkg.addRelationship(corePartName, TargetMode.INTERNAL, "http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument");
            pkg.createPart(corePartName, XWPFRelation.DOCUMENT.getContentType());
            pkg.getPackageProperties().setCreatorProperty("Apache POI");
            return pkg;
        }
        catch (Exception e) {
            throw new POIXMLException(e);
        }
    }

    protected void onDocumentCreate() {
        this.ctDocument = CTDocument1.Factory.newInstance();
        this.ctDocument.addNewBody();
        this.settings = (XWPFSettings)this.createRelationship(XWPFRelation.SETTINGS, XWPFFactory.getInstance());
        POIXMLProperties.ExtendedProperties expProps = this.getProperties().getExtendedProperties();
        expProps.getUnderlyingProperties().setApplication("Apache POI");
    }

    public CTDocument1 getDocument() {
        return this.ctDocument;
    }

    IdentifierManager getDrawingIdManager() {
        return this.drawingIdManager;
    }

    public List getBodyElements() {
        return Collections.unmodifiableList(this.bodyElements);
    }

    public Iterator getBodyElementsIterator() {
        return this.bodyElements.iterator();
    }

    public List getParagraphs() {
        return Collections.unmodifiableList(this.paragraphs);
    }

    public List getTables() {
        return Collections.unmodifiableList(this.tables);
    }

    public XWPFTable getTableArray(int pos) {
        if (pos > 0 && pos < this.tables.size()) {
            return (XWPFTable)this.tables.get(pos);
        }
        return null;
    }

    public List getFooterList() {
        return Collections.unmodifiableList(this.footers);
    }

    public XWPFFooter getFooterArray(int pos) {
        return (XWPFFooter)this.footers.get(pos);
    }

    public List getHeaderList() {
        return Collections.unmodifiableList(this.headers);
    }

    public XWPFHeader getHeaderArray(int pos) {
        return (XWPFHeader)this.headers.get(pos);
    }

    public String getTblStyle(XWPFTable table) {
        return table.getStyleID();
    }

    public XWPFHyperlink getHyperlinkByID(String id) {
        Iterator iter = this.hyperlinks.iterator();
        while (iter.hasNext()) {
            XWPFHyperlink link = (XWPFHyperlink)iter.next();
            if (!link.getId().equals(id)) continue;
            return link;
        }
        return null;
    }

    public XWPFFootnote getFootnoteByID(int id) {
        if (this.footnotes == null) {
            return null;
        }
        return this.footnotes.getFootnoteById(id);
    }

    public XWPFFootnote getEndnoteByID(int id) {
        if (this.endnotes == null) {
            return null;
        }
        return (XWPFFootnote)this.endnotes.get(new Integer(id));
    }

    public List getFootnotes() {
        if (this.footnotes == null) {
            return Collections.EMPTY_LIST;
        }
        return this.footnotes.getFootnotesList();
    }

    public XWPFHyperlink[] getHyperlinks() {
        return this.hyperlinks.toArray(new XWPFHyperlink[this.hyperlinks.size()]);
    }

    public XWPFComment getCommentByID(String id) {
        Iterator iter = this.comments.iterator();
        while (iter.hasNext()) {
            XWPFComment comment = (XWPFComment)iter.next();
            if (!comment.getId().equals(id)) continue;
            return comment;
        }
        return null;
    }

    public XWPFComment[] getComments() {
        return this.comments.toArray(new XWPFComment[this.comments.size()]);
    }

    public PackagePart getPartById(String id) {
        try {
            PackagePart corePart = this.getCorePart();
            return corePart.getRelatedPart(corePart.getRelationship(id));
        }
        catch (InvalidFormatException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public XWPFHeaderFooterPolicy getHeaderFooterPolicy() {
        return this.headerFooterPolicy;
    }

    public CTStyles getStyle() throws XmlException, IOException {
        PackagePart[] parts;
        try {
            parts = this.getRelatedByType(XWPFRelation.STYLES.getRelation());
        }
        catch (InvalidFormatException e) {
            throw new IllegalStateException(e.getMessage());
        }
        if (parts.length != 1) {
            throw new IllegalStateException("Expecting one Styles document part, but found " + parts.length);
        }
        StylesDocument sd = StylesDocument.Factory.parse((InputStream)parts[0].getInputStream());
        return sd.getStyles();
    }

    public List getAllEmbedds() throws OpenXML4JException {
        PackageRelationship rel;
        LinkedList<PackagePart> embedds = new LinkedList<PackagePart>();
        PackagePart part = this.getPackagePart();
        Iterator iterator = this.getPackagePart().getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/oleObject").iterator();
        while (iterator.hasNext()) {
            rel = (PackageRelationship)iterator.next();
            embedds.add(part.getRelatedPart(rel));
        }
        iterator = this.getPackagePart().getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/package").iterator();
        while (iterator.hasNext()) {
            rel = (PackageRelationship)iterator.next();
            embedds.add(part.getRelatedPart(rel));
        }
        return embedds;
    }

    private int getBodyElementSpecificPos(int pos, List list) {
        if (list.size() == 0) {
            return -1;
        }
        if (pos >= 0 && pos < this.bodyElements.size()) {
            int startPos;
            IBodyElement needle = (IBodyElement)this.bodyElements.get(pos);
            if (needle.getElementType() != ((IBodyElement)list.get(0)).getElementType()) {
                return -1;
            }
            int i = startPos = Math.min(pos, list.size() - 1);
            while (i >= 0) {
                if (list.get(i) == needle) {
                    return i;
                }
                --i;
            }
        }
        return -1;
    }

    public int getParagraphPos(int pos) {
        return this.getBodyElementSpecificPos(pos, this.paragraphs);
    }

    public int getTablePos(int pos) {
        return this.getBodyElementSpecificPos(pos, this.tables);
    }

    public XWPFParagraph insertNewParagraph(XmlCursor cursor) {
        if (this.isCursorInBody(cursor)) {
            String uri = CTP.type.getName().getNamespaceURI();
            String localPart = "p";
            cursor.beginElement(localPart, uri);
            cursor.toParent();
            CTP p = (CTP)cursor.getObject();
            XWPFParagraph newP = new XWPFParagraph(p, this);
            XmlObject o = null;
            while (!(o instanceof CTP) && cursor.toPrevSibling()) {
                o = cursor.getObject();
            }
            if (!(o instanceof CTP) || (CTP)o == p) {
                this.paragraphs.add(0, newP);
            } else {
                int pos = this.paragraphs.indexOf(this.getParagraph((CTP)o)) + 1;
                this.paragraphs.add(pos, newP);
            }
            XmlCursor newParaPos = p.newCursor();
            try {
                int i = 0;
                cursor.toCursor(newParaPos);
                while (cursor.toPrevSibling()) {
                    o = cursor.getObject();
                    if (!(o instanceof CTP) && !(o instanceof CTTbl)) continue;
                    ++i;
                }
                this.bodyElements.add(i, newP);
                cursor.toCursor(newParaPos);
                cursor.toEndToken();
                XWPFParagraph xWPFParagraph = newP;
                return xWPFParagraph;
            }
            finally {
                newParaPos.dispose();
            }
        }
        return null;
    }

    public XWPFTable insertNewTbl(XmlCursor cursor) {
        if (this.isCursorInBody(cursor)) {
            String uri = CTTbl.type.getName().getNamespaceURI();
            String localPart = "tbl";
            cursor.beginElement(localPart, uri);
            cursor.toParent();
            CTTbl t = (CTTbl)cursor.getObject();
            XWPFTable newT = new XWPFTable(t, this);
            XmlObject o = null;
            while (!(o instanceof CTTbl) && cursor.toPrevSibling()) {
                o = cursor.getObject();
            }
            if (!(o instanceof CTTbl)) {
                this.tables.add(0, newT);
            } else {
                int pos = this.tables.indexOf(this.getTable((CTTbl)o)) + 1;
                this.tables.add(pos, newT);
            }
            int i = 0;
            XmlCursor tableCursor = t.newCursor();
            try {
                cursor.toCursor(tableCursor);
                while (cursor.toPrevSibling()) {
                    o = cursor.getObject();
                    if (!(o instanceof CTP) && !(o instanceof CTTbl)) continue;
                    ++i;
                }
                this.bodyElements.add(i, newT);
                cursor.toCursor(tableCursor);
                cursor.toEndToken();
                XWPFTable xWPFTable = newT;
                return xWPFTable;
            }
            finally {
                tableCursor.dispose();
            }
        }
        return null;
    }

    private boolean isCursorInBody(XmlCursor cursor) {
        XmlCursor verify = cursor.newCursor();
        verify.toParent();
        try {
            boolean bl = verify.getObject() == this.ctDocument.getBody();
            return bl;
        }
        finally {
            verify.dispose();
        }
    }

    private int getPosOfBodyElement(IBodyElement needle) {
        BodyElementType type = needle.getElementType();
        int i = 0;
        while (i < this.bodyElements.size()) {
            IBodyElement current = (IBodyElement)this.bodyElements.get(i);
            if (current.getElementType() == type && current.equals(needle)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getPosOfParagraph(XWPFParagraph p) {
        return this.getPosOfBodyElement(p);
    }

    public int getPosOfTable(XWPFTable t) {
        return this.getPosOfBodyElement(t);
    }

    protected void commit() throws IOException {
        XmlOptions xmlOptions = new XmlOptions(DEFAULT_XML_OPTIONS);
        xmlOptions.setSaveSyntheticDocumentElement(new QName(CTDocument1.type.getName().getNamespaceURI(), "document"));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("http://schemas.openxmlformats.org/officeDocument/2006/math", "m");
        map.put("urn:schemas-microsoft-com:office:office", "o");
        map.put("http://schemas.openxmlformats.org/officeDocument/2006/relationships", "r");
        map.put("urn:schemas-microsoft-com:vml", "v");
        map.put("http://schemas.openxmlformats.org/markup-compatibility/2006", "ve");
        map.put("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "w");
        map.put("urn:schemas-microsoft-com:office:word", "w10");
        map.put("http://schemas.microsoft.com/office/word/2006/wordml", "wne");
        map.put("http://schemas.openxmlformats.org/drawingml/2006/wordprocessingDrawing", "wp");
        xmlOptions.setSaveSuggestedPrefixes(map);
        PackagePart part = this.getPackagePart();
        OutputStream out = part.getOutputStream();
        this.ctDocument.save(out, xmlOptions);
        out.close();
    }

    private int getRelationIndex(XWPFRelation relation) {
        List relations = this.getRelations();
        int i = 1;
        Iterator it = relations.iterator();
        while (it.hasNext()) {
            POIXMLDocumentPart item = (POIXMLDocumentPart)it.next();
            if (!item.getPackageRelationship().getRelationshipType().equals(relation.getRelation())) continue;
            ++i;
        }
        return i;
    }

    public XWPFParagraph createParagraph() {
        XWPFParagraph p = new XWPFParagraph(this.ctDocument.getBody().addNewP(), this);
        this.bodyElements.add(p);
        this.paragraphs.add(p);
        return p;
    }

    public XWPFNumbering createNumbering() {
        if (this.numbering == null) {
            NumberingDocument numberingDoc = NumberingDocument.Factory.newInstance();
            XWPFRelation relation = XWPFRelation.NUMBERING;
            int i = this.getRelationIndex(relation);
            XWPFNumbering wrapper = (XWPFNumbering)this.createRelationship(relation, XWPFFactory.getInstance(), i);
            wrapper.setNumbering(numberingDoc.addNewNumbering());
            this.numbering = wrapper;
        }
        return this.numbering;
    }

    public XWPFStyles createStyles() {
        if (this.styles == null) {
            StylesDocument stylesDoc = StylesDocument.Factory.newInstance();
            XWPFRelation relation = XWPFRelation.STYLES;
            int i = this.getRelationIndex(relation);
            XWPFStyles wrapper = (XWPFStyles)this.createRelationship(relation, XWPFFactory.getInstance(), i);
            wrapper.setStyles(stylesDoc.addNewStyles());
            this.styles = wrapper;
        }
        return this.styles;
    }

    public XWPFFootnotes createFootnotes() {
        if (this.footnotes == null) {
            FootnotesDocument footnotesDoc = FootnotesDocument.Factory.newInstance();
            XWPFRelation relation = XWPFRelation.FOOTNOTE;
            int i = this.getRelationIndex(relation);
            XWPFFootnotes wrapper = (XWPFFootnotes)this.createRelationship(relation, XWPFFactory.getInstance(), i);
            wrapper.setFootnotes(footnotesDoc.addNewFootnotes());
            this.footnotes = wrapper;
        }
        return this.footnotes;
    }

    public XWPFFootnote addFootnote(CTFtnEdn note) {
        return this.footnotes.addFootnote(note);
    }

    public XWPFFootnote addEndnote(CTFtnEdn note) {
        XWPFFootnote endnote = new XWPFFootnote(this, note);
        this.endnotes.put(new Integer(note.getId().intValue()), endnote);
        return endnote;
    }

    public boolean removeBodyElement(int pos) {
        if (pos >= 0 && pos < this.bodyElements.size()) {
            BodyElementType type = ((IBodyElement)this.bodyElements.get(pos)).getElementType();
            if (type == BodyElementType.TABLE) {
                int tablePos = this.getTablePos(pos);
                this.tables.remove(tablePos);
                this.ctDocument.getBody().removeTbl(tablePos);
            }
            if (type == BodyElementType.PARAGRAPH) {
                int paraPos = this.getParagraphPos(pos);
                this.paragraphs.remove(paraPos);
                this.ctDocument.getBody().removeP(paraPos);
            }
            this.bodyElements.remove(pos);
            return true;
        }
        return false;
    }

    public void setParagraph(XWPFParagraph paragraph, int pos) {
        this.paragraphs.set(pos, paragraph);
        this.ctDocument.getBody().setPArray(pos, paragraph.getCTP());
    }

    public XWPFParagraph getLastParagraph() {
        int lastPos = this.paragraphs.toArray().length - 1;
        return (XWPFParagraph)this.paragraphs.get(lastPos);
    }

    public XWPFTable createTable() {
        XWPFTable table = new XWPFTable(this.ctDocument.getBody().addNewTbl(), this);
        this.bodyElements.add(table);
        this.tables.add(table);
        return table;
    }

    public XWPFTable createTable(int rows, int cols) {
        XWPFTable table = new XWPFTable(this.ctDocument.getBody().addNewTbl(), this, rows, cols);
        this.bodyElements.add(table);
        this.tables.add(table);
        return table;
    }

    public void createTOC() {
        CTSdtBlock block = this.getDocument().getBody().addNewSdt();
        TOC toc = new TOC(block);
        Iterator iterator = this.paragraphs.iterator();
        while (iterator.hasNext()) {
            XWPFParagraph par = (XWPFParagraph)iterator.next();
            String parStyle = par.getStyle();
            if (parStyle == null || !parStyle.substring(0, 7).equals("Heading")) continue;
            try {
                int level = new Integer(parStyle.substring("Heading".length()));
                toc.addRow(level, par.getText(), 1, "112723803");
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
    }

    public void setTable(int pos, XWPFTable table) {
        this.tables.set(pos, table);
        this.ctDocument.getBody().setTblArray(pos, table.getCTTbl());
    }

    public boolean isEnforcedReadonlyProtection() {
        return this.settings.isEnforcedWith(STDocProtect.READ_ONLY);
    }

    public boolean isEnforcedFillingFormsProtection() {
        return this.settings.isEnforcedWith(STDocProtect.FORMS);
    }

    public boolean isEnforcedCommentsProtection() {
        return this.settings.isEnforcedWith(STDocProtect.COMMENTS);
    }

    public boolean isEnforcedTrackedChangesProtection() {
        return this.settings.isEnforcedWith(STDocProtect.TRACKED_CHANGES);
    }

    public boolean isEnforcedUpdateFields() {
        return this.settings.isUpdateFields();
    }

    public void enforceReadonlyProtection() {
        this.settings.setEnforcementEditValue(STDocProtect.READ_ONLY);
    }

    public void enforceFillingFormsProtection() {
        this.settings.setEnforcementEditValue(STDocProtect.FORMS);
    }

    public void enforceCommentsProtection() {
        this.settings.setEnforcementEditValue(STDocProtect.COMMENTS);
    }

    public void enforceTrackedChangesProtection() {
        this.settings.setEnforcementEditValue(STDocProtect.TRACKED_CHANGES);
    }

    public void removeProtectionEnforcement() {
        this.settings.removeEnforcement();
    }

    public void enforceUpdateFields() {
        this.settings.setUpdateFields();
    }

    public void insertTable(int pos, XWPFTable table) {
        this.bodyElements.add(pos, table);
        int i = 0;
        while (i < Arrays.asList(this.ctDocument.getBody().getTblArray()).size()) {
            CTTbl tbl = this.ctDocument.getBody().getTblArray(i);
            if (tbl == table.getCTTbl()) break;
            ++i;
        }
        this.tables.add(i, table);
    }

    public List getAllPictures() {
        return Collections.unmodifiableList(this.pictures);
    }

    public List getAllPackagePictures() {
        ArrayList result = new ArrayList();
        Collection values = this.packagePictures.values();
        Iterator iterator = values.iterator();
        while (iterator.hasNext()) {
            List list = (List)iterator.next();
            result.addAll(list);
        }
        return Collections.unmodifiableList(result);
    }

    void registerPackagePictureData(XWPFPictureData picData) {
        ArrayList<XWPFPictureData> list = (ArrayList<XWPFPictureData>)this.packagePictures.get(picData.getChecksum());
        if (list == null) {
            list = new ArrayList<XWPFPictureData>(1);
            this.packagePictures.put(picData.getChecksum(), list);
        }
        if (!list.contains(picData)) {
            list.add(picData);
        }
    }

    XWPFPictureData findPackagePictureData(byte[] pictureData, int format) {
        long checksum = IOUtils.calculateChecksum((byte[])pictureData);
        XWPFPictureData xwpfPicData = null;
        List xwpfPicDataList = (List)this.packagePictures.get(new Long(checksum));
        if (xwpfPicDataList != null) {
            Iterator iter = xwpfPicDataList.iterator();
            while (iter.hasNext() && xwpfPicData == null) {
                XWPFPictureData curElem = (XWPFPictureData)iter.next();
                if (!Arrays.equals(pictureData, curElem.getData())) continue;
                xwpfPicData = curElem;
            }
        }
        return xwpfPicData;
    }

    public String addPictureData(byte[] pictureData, int format) throws InvalidFormatException {
        XWPFPictureData xwpfPicData = this.findPackagePictureData(pictureData, format);
        POIXMLRelation relDesc = XWPFPictureData.RELATIONS[format];
        if (xwpfPicData == null) {
            int idx = this.getNextPicNameNumber(format);
            xwpfPicData = (XWPFPictureData)this.createRelationship(relDesc, XWPFFactory.getInstance(), idx);
            PackagePart picDataPart = xwpfPicData.getPackagePart();
            OutputStream out = null;
            try {
                try {
                    out = picDataPart.getOutputStream();
                    out.write(pictureData);
                }
                catch (IOException e) {
                    throw new POIXMLException(e);
                }
            }
            finally {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
            this.registerPackagePictureData(xwpfPicData);
            this.pictures.add(xwpfPicData);
            return this.getRelationId(xwpfPicData);
        }
        if (!this.getRelations().contains(xwpfPicData)) {
            PackagePart picDataPart = xwpfPicData.getPackagePart();
            TargetMode targetMode = TargetMode.INTERNAL;
            PackagePartName partName = picDataPart.getPartName();
            String relation = relDesc.getRelation();
            PackageRelationship relShip = this.getPackagePart().addRelationship(partName, targetMode, relation);
            String id = relShip.getId();
            this.addRelation(id, xwpfPicData);
            this.pictures.add(xwpfPicData);
            return id;
        }
        return this.getRelationId(xwpfPicData);
    }

    public String addPictureData(InputStream is, int format) throws InvalidFormatException {
        try {
            byte[] data = IOUtils.toByteArray((InputStream)is);
            return this.addPictureData(data, format);
        }
        catch (IOException e) {
            throw new POIXMLException(e);
        }
    }

    public int getNextPicNameNumber(int format) throws InvalidFormatException {
        int img = this.getAllPackagePictures().size() + 1;
        String proposal = XWPFPictureData.RELATIONS[format].getFileName(img);
        PackagePartName createPartName = PackagingURIHelper.createPartName(proposal);
        while (this.getPackage().getPart(createPartName) != null) {
            proposal = XWPFPictureData.RELATIONS[format].getFileName(++img);
            createPartName = PackagingURIHelper.createPartName(proposal);
        }
        return img;
    }

    public XWPFPictureData getPictureDataByID(String blipID) {
        POIXMLDocumentPart relatedPart = this.getRelationById(blipID);
        if (relatedPart instanceof XWPFPictureData) {
            XWPFPictureData xwpfPicData = (XWPFPictureData)relatedPart;
            return xwpfPicData;
        }
        return null;
    }

    public XWPFNumbering getNumbering() {
        return this.numbering;
    }

    public XWPFStyles getStyles() {
        return this.styles;
    }

    public XWPFParagraph getParagraph(CTP p) {
        int i = 0;
        while (i < this.getParagraphs().size()) {
            if (((XWPFParagraph)this.getParagraphs().get(i)).getCTP() == p) {
                return (XWPFParagraph)this.getParagraphs().get(i);
            }
            ++i;
        }
        return null;
    }

    public XWPFTable getTable(CTTbl ctTbl) {
        int i = 0;
        while (i < this.tables.size()) {
            if (((XWPFTable)this.getTables().get(i)).getCTTbl() == ctTbl) {
                return (XWPFTable)this.getTables().get(i);
            }
            ++i;
        }
        return null;
    }

    public Iterator getTablesIterator() {
        return this.tables.iterator();
    }

    public Iterator getParagraphsIterator() {
        return this.paragraphs.iterator();
    }

    public XWPFParagraph getParagraphArray(int pos) {
        if (pos >= 0 && pos < this.paragraphs.size()) {
            return (XWPFParagraph)this.paragraphs.get(pos);
        }
        return null;
    }

    public POIXMLDocumentPart getPart() {
        return this;
    }

    public BodyType getPartType() {
        return BodyType.DOCUMENT;
    }

    public XWPFTableCell getTableCell(CTTc cell) {
        XmlCursor cursor = cell.newCursor();
        cursor.toParent();
        XmlObject o = cursor.getObject();
        if (!(o instanceof CTRow)) {
            return null;
        }
        CTRow row = (CTRow)o;
        cursor.toParent();
        o = cursor.getObject();
        cursor.dispose();
        if (!(o instanceof CTTbl)) {
            return null;
        }
        CTTbl tbl = (CTTbl)o;
        XWPFTable table = this.getTable(tbl);
        if (table == null) {
            return null;
        }
        XWPFTableRow tableRow = table.getRow(row);
        if (tableRow == null) {
            return null;
        }
        return tableRow.getTableCell(cell);
    }

    public XWPFDocument getXWPFDocument() {
        return this;
    }
}

