/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.dev;

import org.apache.poi.hslf.HSLFSlideShow;
import org.apache.poi.hslf.record.Notes;
import org.apache.poi.hslf.record.NotesAtom;
import org.apache.poi.hslf.record.Record;
import org.apache.poi.hslf.record.Slide;
import org.apache.poi.hslf.record.SlideAtom;

public final class SlideAndNotesAtomListing {
    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("Need to give a filename");
            System.exit(1);
        }
        HSLFSlideShow ss = new HSLFSlideShow(args[0]);
        System.out.println("");
        Record[] records = ss.getRecords();
        int i = 0;
        while (i < records.length) {
            Record r = records[i];
            if (r instanceof Slide) {
                Slide s = (Slide)r;
                SlideAtom sa = s.getSlideAtom();
                System.out.println("Found Slide at " + i);
                System.out.println("  Slide's master ID is " + sa.getMasterID());
                System.out.println("  Slide's notes ID is  " + sa.getNotesID());
                System.out.println("");
            }
            if (r instanceof Notes) {
                Notes n = (Notes)r;
                NotesAtom na = n.getNotesAtom();
                System.out.println("Found Notes at " + i);
                System.out.println("  Notes ID is " + na.getSlideID());
                System.out.println("");
            }
            ++i;
        }
    }
}

