/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.dev;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.hwpf.HWPFDocumentCore;
import org.apache.poi.hwpf.HWPFOldDocument;
import org.apache.poi.hwpf.OldWordFileFormatException;
import org.apache.poi.hwpf.model.CHPX;
import org.apache.poi.hwpf.model.FieldsDocumentPart;
import org.apache.poi.hwpf.model.FileInformationBlock;
import org.apache.poi.hwpf.model.GenericPropertyNode;
import org.apache.poi.hwpf.model.ListFormatOverride;
import org.apache.poi.hwpf.model.ListLevel;
import org.apache.poi.hwpf.model.ListTables;
import org.apache.poi.hwpf.model.PAPFormattedDiskPage;
import org.apache.poi.hwpf.model.PAPX;
import org.apache.poi.hwpf.model.PlexOfCps;
import org.apache.poi.hwpf.model.StyleDescription;
import org.apache.poi.hwpf.model.TextPiece;
import org.apache.poi.hwpf.sprm.SprmIterator;
import org.apache.poi.hwpf.sprm.SprmOperation;
import org.apache.poi.hwpf.usermodel.Bookmark;
import org.apache.poi.hwpf.usermodel.Bookmarks;
import org.apache.poi.hwpf.usermodel.OfficeDrawing;
import org.apache.poi.hwpf.usermodel.Paragraph;
import org.apache.poi.hwpf.usermodel.ParagraphProperties;
import org.apache.poi.hwpf.usermodel.Picture;
import org.apache.poi.hwpf.usermodel.Range;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.LittleEndian;
import poi.support.Closeable;

public final class HWPFLister {
    private final HWPFDocumentCore _doc;
    private LinkedHashMap paragraphs;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    private static HWPFDocumentCore loadDoc(File docFile) throws IOException {
        FileInputStream istream = new FileInputStream(docFile);
        try {
            HWPFDocumentCore hWPFDocumentCore = HWPFLister.loadDoc(istream);
            return hWPFDocumentCore;
        }
        finally {
            IOUtils.closeQuietly((Closeable)((Closeable)istream));
        }
    }

    private static HWPFDocumentCore loadDoc(InputStream inputStream) throws IOException {
        POIFSFileSystem poifsFileSystem = HWPFDocumentCore.verifyAndBuildPOIFS(inputStream);
        try {
            return new HWPFDocument(poifsFileSystem);
        }
        catch (OldWordFileFormatException exc) {
            return new HWPFOldDocument(poifsFileSystem);
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.err.println("Use:");
            System.err.println("\tHWPFLister <filename>\n\t\t[--dop]\n\t\t[--textPieces] [--textPiecesText]\n\t\t[--chpx] [--chpxProperties] [--chpxSprms]\n\t\t[--papx] [--papxProperties] [--papxSprms]\n\t\t[--paragraphs] [--paragraphsText]\n\t\t[--bookmarks]\n\t\t[--escher]\n\t\t[--fields]\n\t\t[--pictures]\n\t\t[--officeDrawings]\n\t\t[--styles]\n\t\t[--writereadback]\n");
            System.exit(1);
        }
        boolean outputDop = false;
        boolean outputTextPieces = false;
        boolean outputTextPiecesText = false;
        boolean outputChpx = false;
        boolean outputChpxProperties = false;
        boolean outputChpxSprms = false;
        boolean outputParagraphs = false;
        boolean outputParagraphsText = false;
        boolean outputPapx = false;
        boolean outputPapxSprms = false;
        boolean outputPapxProperties = false;
        boolean outputBookmarks = false;
        boolean outputEscher = false;
        boolean outputFields = false;
        boolean outputPictures = false;
        boolean outputOfficeDrawings = false;
        boolean outputStyles = false;
        boolean writereadback = false;
        Iterator<String> iterator = Arrays.asList(args).subList(1, args.length).iterator();
        while (iterator.hasNext()) {
            String arg = iterator.next();
            if ("--dop".equals(arg)) {
                outputDop = true;
            }
            if ("--textPieces".equals(arg)) {
                outputTextPieces = true;
            }
            if ("--textPiecesText".equals(arg)) {
                outputTextPiecesText = true;
            }
            if ("--chpx".equals(arg)) {
                outputChpx = true;
            }
            if ("--chpxProperties".equals(arg)) {
                outputChpxProperties = true;
            }
            if ("--chpxSprms".equals(arg)) {
                outputChpxSprms = true;
            }
            if ("--paragraphs".equals(arg)) {
                outputParagraphs = true;
            }
            if ("--paragraphsText".equals(arg)) {
                outputParagraphsText = true;
            }
            if ("--papx".equals(arg)) {
                outputPapx = true;
            }
            if ("--papxProperties".equals(arg)) {
                outputPapxProperties = true;
            }
            if ("--papxSprms".equals(arg)) {
                outputPapxSprms = true;
            }
            if ("--bookmarks".equals(arg)) {
                outputBookmarks = true;
            }
            if ("--escher".equals(arg)) {
                outputEscher = true;
            }
            if ("--fields".equals(arg)) {
                outputFields = true;
            }
            if ("--pictures".equals(arg)) {
                outputPictures = true;
            }
            if ("--officeDrawings".equals(arg)) {
                outputOfficeDrawings = true;
            }
            if ("--styles".equals(arg)) {
                outputStyles = true;
            }
            if (!"--writereadback".equals(arg)) continue;
            writereadback = true;
        }
        HWPFDocumentCore doc = HWPFLister.loadDoc(new File(args[0]));
        if (writereadback) {
            doc = HWPFLister.writeOutAndReadBack(doc);
        }
        System.setProperty("org.apache.poi.hwpf.preserveBinTables", Boolean.TRUE.toString());
        System.setProperty("org.apache.poi.hwpf.preserveTextTable", Boolean.TRUE.toString());
        HWPFDocumentCore original = HWPFLister.loadDoc(new File(args[0]));
        if (writereadback) {
            original = HWPFLister.writeOutAndReadBack(original);
        }
        HWPFLister listerOriginal = new HWPFLister(original);
        HWPFLister listerRebuilded = new HWPFLister(doc);
        System.out.println("== OLE streams ==");
        listerOriginal.dumpFileSystem();
        System.out.println("== FIB (original) ==");
        listerOriginal.dumpFIB();
        if (outputDop) {
            System.out.println("== Document properties ==");
            listerOriginal.dumpDop();
        }
        if (outputTextPieces) {
            System.out.println("== Text pieces (original) ==");
            listerOriginal.dumpTextPieces(outputTextPiecesText);
        }
        if (outputChpx) {
            System.out.println("== CHPX (original) ==");
            listerOriginal.dumpChpx(outputChpxProperties, outputChpxSprms);
            System.out.println("== CHPX (rebuilded) ==");
            listerRebuilded.dumpChpx(outputChpxProperties, outputChpxSprms);
        }
        if (outputPapx) {
            System.out.println("== PAPX (original) ==");
            listerOriginal.dumpPapx(outputPapxProperties, outputPapxSprms);
            System.out.println("== PAPX (rebuilded) ==");
            listerRebuilded.dumpPapx(outputPapxProperties, outputPapxSprms);
        }
        if (outputParagraphs) {
            System.out.println("== Text paragraphs (original) ==");
            listerRebuilded.dumpParagraphs(true);
            System.out.println("== DOM paragraphs (rebuilded) ==");
            listerRebuilded.dumpParagraphsDom(outputParagraphsText);
        }
        if (outputBookmarks) {
            System.out.println("== BOOKMARKS (rebuilded) ==");
            listerRebuilded.dumpBookmarks();
        }
        if (outputEscher) {
            System.out.println("== ESCHER PROPERTIES (rebuilded) ==");
            listerRebuilded.dumpEscher();
        }
        if (outputFields) {
            System.out.println("== FIELDS (rebuilded) ==");
            listerRebuilded.dumpFields();
        }
        if (outputOfficeDrawings) {
            System.out.println("== OFFICE DRAWINGS (rebuilded) ==");
            listerRebuilded.dumpOfficeDrawings();
        }
        if (outputPictures) {
            System.out.println("== PICTURES (rebuilded) ==");
            listerRebuilded.dumpPictures();
        }
        if (outputStyles) {
            System.out.println("== STYLES (rebuilded) ==");
            listerRebuilded.dumpStyles();
        }
    }

    private static HWPFDocumentCore writeOutAndReadBack(HWPFDocumentCore original) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
            original.write(baos);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            return HWPFLister.loadDoc(bais);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public HWPFLister(HWPFDocumentCore doc) {
        this._doc = doc;
        this.buildParagraphs();
    }

    private void buildParagraphs() {
        this.paragraphs = new LinkedHashMap();
        StringBuffer part = new StringBuffer();
        String text = this._doc.getDocumentText();
        int charIndex = 0;
        while (charIndex < text.length()) {
            char c = text.charAt(charIndex);
            part.append(c);
            if (c == '\r' || c == '\u0007' || c == '\f') {
                this.paragraphs.put(new Integer(charIndex), part.toString());
                part.setLength(0);
            }
            ++charIndex;
        }
    }

    private void dumpBookmarks() {
        if (!(this._doc instanceof HWPFDocument)) {
            System.out.println("Word 95 not supported so far");
            return;
        }
        HWPFDocument document = (HWPFDocument)this._doc;
        Bookmarks bookmarks = document.getBookmarks();
        int b = 0;
        while (b < bookmarks.getBookmarksCount()) {
            Bookmark bookmark = bookmarks.getBookmark(b);
            System.out.println("[" + bookmark.getStart() + "; " + bookmark.getEnd() + "): " + bookmark.getName());
            ++b;
        }
    }

    public void dumpChpx(boolean withProperties, boolean withSprms) {
        Iterator iterator = this._doc.getCharacterTable().getTextRuns().iterator();
        while (iterator.hasNext()) {
            CHPX chpx = (CHPX)iterator.next();
            System.out.println(chpx);
            if (withProperties) {
                System.out.println(chpx.getCharacterProperties(this._doc.getStyleSheet(), (short)4095));
            }
            if (withSprms) {
                SprmIterator sprmIt = new SprmIterator(chpx.getGrpprl(), 0);
                while (sprmIt.hasNext()) {
                    SprmOperation sprm = sprmIt.next();
                    System.out.println("\t" + sprm.toString());
                }
            }
            String text = new Range(chpx.getStart(), chpx.getEnd(), this._doc.getOverallRange()){

                public String toString() {
                    return "CHPX range (" + super.toString() + ")";
                }
            }.text();
            StringBuffer stringBuilder = new StringBuffer();
            int i = 0;
            while (i < text.toCharArray().length) {
                char c = text.toCharArray()[i];
                if (c < '\u001e') {
                    stringBuilder.append("\\0x" + Integer.toHexString(c));
                } else {
                    stringBuilder.append(c);
                }
                ++i;
            }
            System.out.println(stringBuilder);
        }
    }

    private void dumpDop() {
        if (!(this._doc instanceof HWPFDocument)) {
            System.out.println("Word 95 not supported so far");
            return;
        }
        System.out.println(((HWPFDocument)this._doc).getDocProperties());
    }

    private void dumpEscher() {
        if (this._doc instanceof HWPFOldDocument) {
            System.out.println("Word 95 not supported so far");
            return;
        }
        System.out.println(((HWPFDocument)this._doc).getEscherRecordHolder());
    }

    public void dumpFIB() {
        FileInformationBlock fib = this._doc.getFileInformationBlock();
        System.out.println(fib);
    }

    private void dumpFields() {
        if (!(this._doc instanceof HWPFDocument)) {
            System.out.println("Word 95 not supported so far");
            return;
        }
        HWPFDocument document = (HWPFDocument)this._doc;
        int i = 0;
        while (i < FieldsDocumentPart.values().length) {
            FieldsDocumentPart part = FieldsDocumentPart.values()[i];
            System.out.println("=== Document part: " + part + " ===");
            Iterator iterator = document.getFields().getFields(part).iterator();
            while (iterator.hasNext()) {
                org.apache.poi.hwpf.usermodel.Field field = (org.apache.poi.hwpf.usermodel.Field)iterator.next();
                System.out.println(field);
            }
            ++i;
        }
    }

    public void dumpFileSystem() throws Exception {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.poi.POIDocument");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Field field = clazz.getDeclaredField("directory");
        field.setAccessible(true);
        DirectoryNode directoryNode = (DirectoryNode)field.get((Object)this._doc);
        System.out.println(this.dumpFileSystem((DirectoryEntry)directoryNode));
    }

    private String dumpFileSystem(DirectoryEntry directory) {
        StringBuffer result = new StringBuffer();
        result.append("+ ");
        result.append(directory.getName());
        Iterator iterator = directory.getEntries();
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            String entryToString = "\n" + this.dumpFileSystem(entry);
            entryToString = entryToString.replaceAll("\n", "\n+---");
            result.append(entryToString);
        }
        result.append("\n");
        return result.toString();
    }

    private String dumpFileSystem(Entry entry) {
        if (entry instanceof DirectoryEntry) {
            return this.dumpFileSystem((DirectoryEntry)entry);
        }
        return entry.getName();
    }

    private void dumpOfficeDrawings() {
        OfficeDrawing officeDrawing;
        Iterator iterator;
        if (!(this._doc instanceof HWPFDocument)) {
            System.out.println("Word 95 not supported so far");
            return;
        }
        HWPFDocument document = (HWPFDocument)this._doc;
        if (document.getOfficeDrawingsHeaders() != null) {
            System.out.println("=== Document part: HEADER ===");
            iterator = document.getOfficeDrawingsHeaders().getOfficeDrawings().iterator();
            while (iterator.hasNext()) {
                officeDrawing = (OfficeDrawing)iterator.next();
                System.out.println(officeDrawing);
            }
        }
        if (document.getOfficeDrawingsHeaders() != null) {
            System.out.println("=== Document part: MAIN ===");
            iterator = document.getOfficeDrawingsMain().getOfficeDrawings().iterator();
            while (iterator.hasNext()) {
                officeDrawing = (OfficeDrawing)iterator.next();
                System.out.println(officeDrawing);
            }
        }
    }

    public void dumpPapx(boolean withProperties, boolean withSprms) throws Exception {
        Class<?> clazz;
        if (this._doc instanceof HWPFDocument) {
            System.out.println("binary PAP pages ");
            HWPFDocument doc = (HWPFDocument)this._doc;
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.apache.poi.hwpf.HWPFDocumentCore");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Field fMainStream = clazz2.getDeclaredField("_mainStream");
            fMainStream.setAccessible(true);
            byte[] mainStream = (byte[])fMainStream.get((Object)this._doc);
            PlexOfCps binTable = new PlexOfCps(doc.getTableStream(), doc.getFileInformationBlock().getFcPlcfbtePapx(), doc.getFileInformationBlock().getLcbPlcfbtePapx(), 4);
            ArrayList<PAPX> papxs = new ArrayList<PAPX>();
            int length = binTable.length();
            int x = 0;
            while (x < length) {
                GenericPropertyNode node = binTable.getProperty(x);
                int pageNum = LittleEndian.getInt((byte[])node.getBytes());
                int pageOffset = 512 * pageNum;
                PAPFormattedDiskPage pfkp = new PAPFormattedDiskPage(mainStream, doc.getDataStream(), pageOffset, doc.getTextTable());
                System.out.println("* PFKP: " + pfkp);
                Iterator iterator = pfkp.getPAPXs().iterator();
                while (iterator.hasNext()) {
                    PAPX papx = (PAPX)iterator.next();
                    System.out.println("** " + papx);
                    papxs.add(papx);
                    if (papx == null || !withSprms) continue;
                    SprmIterator sprmIt = new SprmIterator(papx.getGrpprl(), 2);
                    this.dumpSprms(sprmIt, "*** ");
                }
                ++x;
            }
            Collections.sort(papxs);
            System.out.println("* Sorted by END");
            Iterator iterator = papxs.iterator();
            while (iterator.hasNext()) {
                PAPX papx = (PAPX)iterator.next();
                System.out.println("** " + papx);
                if (papx == null || !withSprms) continue;
                SprmIterator sprmIt = new SprmIterator(papx.getGrpprl(), 2);
                this.dumpSprms(sprmIt, "*** ");
            }
        }
        if ((clazz = class$2) == null) {
            try {
                clazz = class$2 = Class.forName("org.apache.poi.hwpf.usermodel.Paragraph");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class[] classArray = new Class[2];
        Class<?> clazz3 = class$3;
        if (clazz3 == null) {
            try {
                clazz3 = class$3 = Class.forName("org.apache.poi.hwpf.usermodel.Range");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz3;
        Class<?> clazz4 = class$4;
        if (clazz4 == null) {
            try {
                clazz4 = class$4 = Class.forName("org.apache.poi.hwpf.model.PAPX");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz4;
        Method newParagraph = clazz.getDeclaredMethod("newParagraph", classArray);
        newParagraph.setAccessible(true);
        Class<?> clazz5 = class$2;
        if (clazz5 == null) {
            try {
                clazz5 = class$2 = Class.forName("org.apache.poi.hwpf.usermodel.Paragraph");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Field _props = clazz5.getDeclaredField("_props");
        _props.setAccessible(true);
        Iterator iterator = this._doc.getParagraphTable().getParagraphs().iterator();
        while (iterator.hasNext()) {
            PAPX papx = (PAPX)iterator.next();
            System.out.println(papx);
            if (withProperties) {
                Paragraph paragraph = (Paragraph)newParagraph.invoke(null, this._doc.getOverallRange(), papx);
                System.out.println(_props.get(paragraph));
            }
            SprmIterator sprmIt = new SprmIterator(papx.getGrpprl(), 2);
            this.dumpSprms(sprmIt, "\t");
        }
    }

    public void dumpParagraphs(boolean dumpAssotiatedPapx) {
        Iterator iterator = this.paragraphs.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Integer endOfParagraphCharOffset = (Integer)entry.getKey();
            System.out.println("[...; " + (endOfParagraphCharOffset + 1) + "): " + entry.getValue());
            if (!dumpAssotiatedPapx) continue;
            boolean hasAssotiatedPapx = false;
            Iterator iterator2 = this._doc.getParagraphTable().getParagraphs().iterator();
            while (iterator2.hasNext()) {
                PAPX papx = (PAPX)iterator2.next();
                if (papx.getStart() > endOfParagraphCharOffset || endOfParagraphCharOffset >= papx.getEnd()) continue;
                hasAssotiatedPapx = true;
                System.out.println("* " + papx);
                SprmIterator sprmIt = new SprmIterator(papx.getGrpprl(), 2);
                this.dumpSprms(sprmIt, "** ");
            }
            if (hasAssotiatedPapx) continue;
            System.out.println("* NO PAPX ASSOTIATED WITH PARAGRAPH!");
        }
    }

    protected void dumpSprms(SprmIterator sprmIt, String linePrefix) {
        while (sprmIt.hasNext()) {
            SprmOperation sprm = sprmIt.next();
            System.out.println(String.valueOf(linePrefix) + sprm.toString());
        }
    }

    public void dumpParagraphsDom(boolean withText) {
        Range range = this._doc.getOverallRange();
        int p = 0;
        while (p < range.numParagraphs()) {
            Paragraph paragraph = range.getParagraph(p);
            System.out.println(String.valueOf(p) + ":\t" + paragraph.toString());
            if (withText) {
                System.out.println(paragraph.text());
            }
            ++p;
        }
    }

    private void dumpPictures() {
        if (this._doc instanceof HWPFOldDocument) {
            System.out.println("Word 95 not supported so far");
            return;
        }
        List allPictures = ((HWPFDocument)this._doc).getPicturesTable().getAllPictures();
        Iterator iterator = allPictures.iterator();
        while (iterator.hasNext()) {
            Picture picture = (Picture)iterator.next();
            System.out.println(picture.toString());
        }
    }

    private void dumpStyles() {
        if (this._doc instanceof HWPFOldDocument) {
            System.out.println("Word 95 not supported so far");
            return;
        }
        HWPFDocument hwpfDocument = (HWPFDocument)this._doc;
        int s = 0;
        while (s < hwpfDocument.getStyleSheet().numStyles()) {
            StyleDescription styleDescription = hwpfDocument.getStyleSheet().getStyleDescription(s);
            if (styleDescription != null) {
                System.out.println("=== Style #" + s + " '" + styleDescription.getName() + "' ===");
                System.out.println(styleDescription);
                if (styleDescription.getPAPX() != null) {
                    this.dumpSprms(new SprmIterator(styleDescription.getPAPX(), 2), "Style's PAP SPRM: ");
                }
                if (styleDescription.getCHPX() != null) {
                    this.dumpSprms(new SprmIterator(styleDescription.getCHPX(), 0), "Style's CHP SPRM: ");
                }
            }
            ++s;
        }
    }

    protected void dumpParagraphLevels(ListTables listTables, ParagraphProperties paragraph) {
        if (paragraph.getIlfo() != 0) {
            ListFormatOverride listFormatOverride = listTables.getOverride(paragraph.getIlfo());
            System.out.println("PAP's LFO: " + listFormatOverride);
            ListLevel listLevel = listTables.getLevel(listFormatOverride.getLsid(), paragraph.getIlvl());
            System.out.println("PAP's ListLevel: " + listLevel);
            if (listLevel.getGrpprlPapx() != null) {
                System.out.println("PAP's ListLevel PAPX:");
                this.dumpSprms(new SprmIterator(listLevel.getGrpprlPapx(), 0), "* ");
            }
            if (listLevel.getGrpprlPapx() != null) {
                System.out.println("PAP's ListLevel CHPX:");
                this.dumpSprms(new SprmIterator(listLevel.getGrpprlChpx(), 0), "* ");
            }
        }
    }

    public void dumpTextPieces(boolean withText) {
        Iterator iterator = this._doc.getTextTable().getTextPieces().iterator();
        while (iterator.hasNext()) {
            TextPiece textPiece = (TextPiece)iterator.next();
            System.out.println(textPiece);
            if (!withText) continue;
            System.out.println("\t" + textPiece.getStringBuffer());
        }
    }
}

