/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import java.util.Arrays;
import org.apache.poi.hwpf.model.LVLF;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;
import poi.support.ArraysUtil;

public final class ListLevel {
    private static final POILogger logger;
    private byte[] _grpprlChpx;
    private byte[] _grpprlPapx;
    private LVLF _lvlf;
    private char[] _xst = new char[0];
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.poi.hwpf.model.ListLevel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = POILogFactory.getLogger((Class)clazz);
    }

    ListLevel() {
    }

    public ListLevel(byte[] buf, int startOffset) {
        this.read(buf, startOffset);
    }

    public ListLevel(int level, boolean numbered) {
        this._lvlf = new LVLF();
        this.setStartAt(1);
        this._grpprlPapx = new byte[0];
        this._grpprlChpx = new byte[0];
        if (numbered) {
            this._lvlf.getRgbxchNums()[0] = 1;
            this._xst = new char[]{(char)level, '.'};
        } else {
            this._xst = new char[]{'\u2022'};
        }
    }

    public ListLevel(int startAt, int numberFormatCode, int alignment, byte[] numberProperties, byte[] entryProperties, String numberText) {
        this._lvlf = new LVLF();
        this.setStartAt(startAt);
        this._lvlf.setNfc((byte)numberFormatCode);
        this._lvlf.setJc((byte)alignment);
        this._grpprlChpx = numberProperties;
        this._grpprlPapx = entryProperties;
        this._xst = numberText.toCharArray();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        ListLevel lvl = (ListLevel)obj;
        return lvl._lvlf.equals(this._lvlf) && Arrays.equals(lvl._grpprlChpx, this._grpprlChpx) && Arrays.equals(lvl._grpprlPapx, this._grpprlPapx) && Arrays.equals(lvl._xst, this._xst);
    }

    public int getAlignment() {
        return this._lvlf.getJc();
    }

    public byte[] getGrpprlChpx() {
        return this._grpprlChpx;
    }

    public byte[] getGrpprlPapx() {
        return this._grpprlPapx;
    }

    public byte[] getLevelProperties() {
        return this._grpprlPapx;
    }

    public int getNumberFormat() {
        return this._lvlf.getNfc();
    }

    public String getNumberText() {
        if (this._xst.length < 2) {
            return null;
        }
        return new String(this._xst, 0, this._xst.length - 1);
    }

    public int getSizeInBytes() {
        return LVLF.getSize() + this._lvlf.getCbGrpprlChpx() + this._lvlf.getCbGrpprlPapx() + 2 + this._xst.length * 2;
    }

    public int getStartAt() {
        return this._lvlf.getIStartAt();
    }

    public byte getTypeOfCharFollowingTheNumber() {
        return this._lvlf.getIxchFollow();
    }

    int read(byte[] data, int startOffset) {
        int offset = startOffset;
        this._lvlf = new LVLF(data, offset);
        this._grpprlPapx = new byte[this._lvlf.getCbGrpprlPapx()];
        System.arraycopy(data, offset += LVLF.getSize(), this._grpprlPapx, 0, this._lvlf.getCbGrpprlPapx());
        this._grpprlChpx = new byte[this._lvlf.getCbGrpprlChpx()];
        System.arraycopy(data, offset += this._lvlf.getCbGrpprlPapx(), this._grpprlChpx, 0, this._lvlf.getCbGrpprlChpx());
        offset += this._lvlf.getCbGrpprlChpx();
        if (this._lvlf.getNfc() == 23) {
            int cch = LittleEndian.getUShort((byte[])data, (int)offset);
            offset += 2;
            if (cch != 1) {
                logger.log(POILogger.WARN, (Object)"LVL at offset ", (Object)new Integer(startOffset), (Object)" has nfc == 0x17 (bullets), but cch != 1 (", (Object)new Integer(cch), (Object)")");
            }
            this._xst = new char[cch];
            int x = 0;
            while (x < cch) {
                this._xst[x] = (char)LittleEndian.getShort((byte[])data, (int)offset);
                offset += 2;
                ++x;
            }
        } else {
            int cch = LittleEndian.getUShort((byte[])data, (int)offset);
            offset += 2;
            if (cch > 0) {
                this._xst = new char[cch];
                int x = 0;
                while (x < cch) {
                    this._xst[x] = (char)LittleEndian.getShort((byte[])data, (int)offset);
                    offset += 2;
                    ++x;
                }
            } else {
                logger.log(POILogger.WARN, (Object)"LVL.xst.cch <= 0: ", (Object)new Integer(cch));
                this._xst = new char[0];
            }
        }
        return offset - startOffset;
    }

    public void setAlignment(int alignment) {
        this._lvlf.setJc((byte)alignment);
    }

    public void setLevelProperties(byte[] grpprl) {
        this._grpprlPapx = grpprl;
    }

    public void setNumberFormat(int numberFormatCode) {
        this._lvlf.setNfc((byte)numberFormatCode);
    }

    public void setNumberProperties(byte[] grpprl) {
        this._grpprlChpx = grpprl;
    }

    public void setStartAt(int startAt) {
        this._lvlf.setIStartAt(startAt);
    }

    public void setTypeOfCharFollowingTheNumber(byte value) {
        this._lvlf.setIxchFollow(value);
    }

    public byte[] toByteArray() {
        byte[] buf = new byte[this.getSizeInBytes()];
        int offset = 0;
        this._lvlf.setCbGrpprlChpx((short)this._grpprlChpx.length);
        this._lvlf.setCbGrpprlPapx((short)this._grpprlPapx.length);
        this._lvlf.serialize(buf, offset);
        System.arraycopy(this._grpprlPapx, 0, buf, offset += LVLF.getSize(), this._grpprlPapx.length);
        System.arraycopy(this._grpprlChpx, 0, buf, offset += this._grpprlPapx.length, this._grpprlChpx.length);
        offset += this._grpprlChpx.length;
        if (this._lvlf.getNfc() == 23) {
            LittleEndian.putUShort((byte[])buf, (int)offset, (int)1);
            LittleEndian.putUShort((byte[])buf, (int)(offset += 2), (int)this._xst[0]);
            offset += 2;
        } else {
            LittleEndian.putUShort((byte[])buf, (int)offset, (int)this._xst.length);
            offset += 2;
            int i = 0;
            while (i < this._xst.length) {
                char c = this._xst[i];
                LittleEndian.putUShort((byte[])buf, (int)offset, (int)c);
                offset += 2;
                ++i;
            }
        }
        return buf;
    }

    public String toString() {
        return "LVL: " + ("\n" + this._lvlf).replaceAll("\n", "\n    ") + "\n" + "PAPX's grpprl: " + ArraysUtil.getToString(this._grpprlPapx) + "\n" + "CHPX's grpprl: " + ArraysUtil.getToString(this._grpprlChpx) + "\n" + "xst: " + ArraysUtil.getToString(this._xst) + "\n";
    }
}

