/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import java.util.LinkedList;
import java.util.List;
import org.apache.poi.ddf.DefaultEscherRecordFactory;
import org.apache.poi.ddf.EscherContainerRecord;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.ddf.EscherRecordFactory;
import org.apache.poi.hwpf.model.PICF;
import org.apache.poi.util.LittleEndian;

public class PICFAndOfficeArtData {
    private List _blipRecords;
    private short _cchPicName;
    private PICF _picf;
    private EscherContainerRecord _shape;
    private byte[] _stPicName;

    public PICFAndOfficeArtData(byte[] dataStream, int startOffset) {
        int offset = startOffset;
        this._picf = new PICF(dataStream, offset);
        offset += PICF.getSize();
        if (this._picf.getMm() == 102) {
            this._cchPicName = LittleEndian.getUByte((byte[])dataStream, (int)offset);
            this._stPicName = LittleEndian.getByteArray((byte[])dataStream, (int)(++offset), (int)this._cchPicName);
            offset += this._cchPicName;
        }
        DefaultEscherRecordFactory escherRecordFactory = new DefaultEscherRecordFactory();
        this._shape = new EscherContainerRecord();
        int recordSize = this._shape.fillFields(dataStream, offset, (EscherRecordFactory)escherRecordFactory);
        offset += recordSize;
        this._blipRecords = new LinkedList();
        while (offset - startOffset < this._picf.getLcb()) {
            EscherRecord nextRecord = escherRecordFactory.createRecord(dataStream, offset);
            if (nextRecord.getRecordId() != -4089 && (nextRecord.getRecordId() < -4072 || nextRecord.getRecordId() > -3817)) break;
            int blipRecordSize = nextRecord.fillFields(dataStream, offset, (EscherRecordFactory)escherRecordFactory);
            offset += blipRecordSize;
            this._blipRecords.add(nextRecord);
        }
    }

    public List getBlipRecords() {
        return this._blipRecords;
    }

    public PICF getPicf() {
        return this._picf;
    }

    public EscherContainerRecord getShape() {
        return this._shape;
    }

    public byte[] getStPicName() {
        return this._stPicName;
    }
}

