/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.sprm;

import java.util.List;
import org.apache.poi.util.LittleEndian;

public final class SprmUtils {
    public static byte[] shortArrayToByteArray(short[] convert) {
        byte[] buf = new byte[convert.length * 2];
        int x = 0;
        while (x < convert.length) {
            LittleEndian.putShort((byte[])buf, (int)(x * 2), (short)convert[x]);
            ++x;
        }
        return buf;
    }

    public static int addSpecialSprm(short instruction, byte[] varParam, List list) {
        byte[] sprm = new byte[varParam.length + 4];
        System.arraycopy(varParam, 0, sprm, 4, varParam.length);
        LittleEndian.putShort((byte[])sprm, (short)instruction);
        LittleEndian.putShort((byte[])sprm, (int)2, (short)((short)(varParam.length + 1)));
        list.add(sprm);
        return sprm.length;
    }

    public static int addSprm(short instruction, boolean param, List list) {
        return SprmUtils.addSprm(instruction, param ? 1 : 0, null, list);
    }

    public static int addSprm(short instruction, int param, byte[] varParam, List list) {
        int type = (instruction & 0xE000) >> 13;
        byte[] sprm = null;
        switch (type) {
            case 0: 
            case 1: {
                sprm = new byte[3];
                sprm[2] = (byte)param;
                break;
            }
            case 2: {
                sprm = new byte[4];
                LittleEndian.putShort((byte[])sprm, (int)2, (short)((short)param));
                break;
            }
            case 3: {
                sprm = new byte[6];
                LittleEndian.putInt((byte[])sprm, (int)2, (int)param);
                break;
            }
            case 4: 
            case 5: {
                sprm = new byte[4];
                LittleEndian.putShort((byte[])sprm, (int)2, (short)((short)param));
                break;
            }
            case 6: {
                sprm = new byte[3 + varParam.length];
                sprm[2] = (byte)varParam.length;
                System.arraycopy(varParam, 0, sprm, 3, varParam.length);
                break;
            }
            case 7: {
                sprm = new byte[5];
                byte[] temp = new byte[4];
                LittleEndian.putInt((byte[])temp, (int)0, (int)param);
                System.arraycopy(temp, 0, sprm, 2, 3);
                break;
            }
        }
        LittleEndian.putShort((byte[])sprm, (int)0, (short)instruction);
        list.add(sprm);
        return sprm.length;
    }

    public static byte[] getGrpprl(List sprmList, int size) {
        byte[] grpprl = new byte[size];
        int listSize = sprmList.size() - 1;
        int index = 0;
        while (listSize >= 0) {
            byte[] sprm = (byte[])sprmList.remove(0);
            System.arraycopy(sprm, 0, grpprl, index, sprm.length);
            index += sprm.length;
            --listSize;
        }
        return grpprl;
    }

    public static int convertBrcToInt(short[] brc) {
        byte[] buf = new byte[4];
        LittleEndian.putShort((byte[])buf, (short)brc[0]);
        LittleEndian.putShort((byte[])buf, (int)2, (short)brc[1]);
        return LittleEndian.getInt((byte[])buf);
    }
}

