package poi.support;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * Support Node Class.<br>
 * for Java 1.4.<br>
 */
public class NodeUtil {

	private NodeUtil() {
	}

	public static String getTextContent(Node node) {
		StringBuffer content = new StringBuffer();
		if (null != node.getNodeValue()) {
			content.append(node.getNodeValue());
		}
		NodeList nodes = node.getChildNodes();
		for (int i = 0; i < nodes.getLength(); i++) {
			Node child = nodes.item(i);
			if (null != child.getNodeValue()) {
				content.append(child.getNodeValue());
			}
			if (0 < child.getChildNodes().getLength()) {
				content.append(getTextContent(child));
			}
		}
		return new String(content);
	}

	public static void setTextContent(Node node, String content) {
		for (int i = 0, len = node.getChildNodes().getLength(); i < len; i++) {
			node.removeChild(node.getChildNodes().item(0));
		}
		node.appendChild(node.getOwnerDocument().createTextNode(content));
	}
}
