package test;

import java.util.Arrays;

import poi.support.ArraysUtil;
import poi.support.SynchronizedInteger;

public class ArraysUtilTest {

	/**
	 * @param args
	 */
	public static void main(String[] args) {

		short[] s = new short[3];
		s[0] = 7;
		s[1] = 1;
		s[2] = 13;

		byte[] b = new byte[3];
		b[0] = 7;
		b[1] = -1;
		b[2] = 126;

		char[] c = new char[3];
		c[0] = 37;
		c[1] = 33;
		c[2] = 124;

		Object[] o = new Object[3];
		o[0] = new SynchronizedInteger(7);
		o[1] = new SynchronizedInteger(1);
		o[2] = new SynchronizedInteger(13);

		System.out.println("-- short[] hashCode()");

		System.out.println(Arrays.hashCode(s));
		System.out.println(ArraysUtil.getHashCode(s));

		System.out.println("-- byte[] hashCode()");
		System.out.println(Arrays.hashCode(b));
		System.out.println(ArraysUtil.getHashCode(b));

		System.out.println("-- Object[] hashCode()");

		System.out.println(Arrays.hashCode(o));
		System.out.println(ArraysUtil.getHashCode(o));

		System.out.println("-- byte[] toString()");

		System.out.println(Arrays.toString(b));
		System.out.println(ArraysUtil.getToString(b));

		System.out.println("-- char[] toString()");

		System.out.println(Arrays.toString(c));
		System.out.println(ArraysUtil.getToString(c));

	}
}
