;Japanese Support Patch for POPFile
;Written by Naoki iimura(amatubu@users.sourceforge.jp)

Name "POPFile 0.22.2 {ꉻpb`" ;Define your own software name here
;!define MUI_VERSION "0.22.2.1" ;Define your own software version here

!include "MUI.nsh"

;--------------------------------
;Configuration

  ;General
  OutFile "popfile_jpn.exe"

  ;Folder selection page
  ;InstallDir "$PROGRAMFILES\${MUI_PRODUCT}"
  InstallDir $PROGRAMFILES\POPFile

  ;Remember install folder
  ;InstallDirRegKey HKCU "Software\${MUI_PRODUCT}" ""
  InstallDirRegKey HKLM SOFTWARE\POPFile "InstallLocation"

;--------------------------------
;Modern UI Configuration

  !insertmacro MUI_PAGE_WELCOME
  !insertmacro MUI_PAGE_LICENSE "license"
  !insertmacro MUI_PAGE_COMPONENTS
  !insertmacro MUI_PAGE_DIRECTORY
  !insertmacro MUI_PAGE_INSTFILES
  !insertmacro MUI_PAGE_FINISH
  
  !insertmacro MUI_UNPAGE_WELCOME
  !insertmacro MUI_UNPAGE_CONFIRM
  !insertmacro MUI_UNPAGE_INSTFILES
  !insertmacro MUI_UNPAGE_FINISH
  
;--------------------------------
;Languages
 
  !insertmacro MUI_LANGUAGE "Japanese"
  
;--------------------------------
;Version Information

  VIProductVersion "0.22.2.1"
  VIAddVersionKey /LANG=${LANG_JAPANESE} "ProductName" "POPFile Japanese Support Patch"
  ;VIAddVersionKey /LANG=${LANG_JAPANESE} "Comments" "A test comment"
  ;VIAddVersionKey /LANG=${LANG_JAPANESE} "CompanyName" "Fake company"
  ;VIAddVersionKey /LANG=${LANG_JAPANESE} "LegalTrademarks" "Test Application is a trademark of Fake company"
  VIAddVersionKey /LANG=${LANG_JAPANESE} "LegalCopyright" "(c) POPFile Japanese Project"
  VIAddVersionKey /LANG=${LANG_JAPANESE} "FileDescription" "POPFile Japanese Support Patch"
  VIAddVersionKey /LANG=${LANG_JAPANESE} "FileVersion" "0.22.2.1"

;--------------------------------
;Language Strings

  ;Description
  LangString DESC_SecCopyUI ${LANG_JAPANESE} "POPFile {ꉻpb` CXg[܂B"

;--------------------------------
;Installer Sections

Section "popfile_jpn.exe" SecCopyUI

  SectionIn RO

  ; Check if POPFile has already installed or not
  IfFileExists "$INSTDIR" NoErrorMsg 0
    MessageBox MB_OK "$INSTDIR ɂ POPFile CXg[Ă܂BfāA܂ POPFile CXg[ĉB"
    Quit
  NoErrorMsg:

  SetOutPath "$INSTDIR"
  WriteUninstaller "popfile_jpn-uninst.exe"

  ; Backup files that are to be updated
  Rename $INSTDIR\Classifier\Bayes.pm $INSTDIR\Classifier\Bayes.pm_original
  Rename $INSTDIR\Classifier\MailParse.pm $INSTDIR\Classifier\MailParse.pm_original
  Rename $INSTDIR\UI\HTML.pm $INSTDIR\UI\HTML.pm_original

  ; Copy(Overwrite) directories
  File /r POPFile\Classifier
  File /r POPFile\UI

  ; Write the installation path into the registry
  WriteRegStr HKLM SOFTWARE\popfile_jpn "Install_Dir" "$INSTDIR"

  ; Write the registry information related to uninstall
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\popfile_jpn" "DisplayName" '"POPFile {ꉻpb`"'
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\popfile_jpn" "UninstallString" '"$INSTDIR\popfile_jpn-uninst.exe"'

SectionEnd

;--------------------------------
;Descriptions

!insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN
  !insertmacro MUI_DESCRIPTION_TEXT ${SecCopyUI} $(DESC_SecCopyUI)
!insertmacro MUI_FUNCTION_DESCRIPTION_END
 
;--------------------------------
;Uninstaller Section

Section "Uninstall"

  ; remove registry keys
  DeleteRegKey HKLM SOFTWARE\popfile_jpn
  DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\popfile_jpn"

  ; Delete files
  Delete "$INSTDIR\Classifier\Bayes.pm"
  Delete "$INSTDIR\Classifier\MailParse.pm"
  Delete "$INSTDIR\UI\HTML.pm"

  ; Resume backup files
  Rename $INSTDIR\Classifier\Bayes.pm_original $INSTDIR\Classifier\Bayes.pm
  Rename $INSTDIR\Classifier\MailParse.pm_original $INSTDIR\Classifier\MailParse.pm
  Rename $INSTDIR\UI\HTML.pm_original $INSTDIR\UI\HTML.pm
  
SectionEnd