/*
 * Decompiled with CFR 0.152.
 */
package portablesimulator.csv;

import java.util.HashSet;
import java.util.Set;
import portablesimulator.PSItem;
import portablesimulator.decoration.DecorationCount;

public class PSSearchItems {
    Set<String>[] candidateUnchecked = new Set[8];
    Set<String>[] viewUnchecked = new Set[8];
    public DecorationCount searchUsableCount = null;

    public PSSearchItems() {
        for (int i = 0; i < 8; ++i) {
            this.candidateUnchecked[i] = new HashSet<String>();
            this.viewUnchecked[i] = new HashSet<String>();
        }
    }

    public boolean isCandidateChecked(PSItem item) {
        String name = item.name;
        if (item.itemType == 5) {
            name = item.name + "[" + item.slotCount + "]" + item.skills.skillToString(null, true);
        }
        return !this.candidateUnchecked[item.itemType].contains(name);
    }

    public void setCandidateChecked(PSItem item, boolean value) {
        String name = item.name;
        if (item.itemType == 5) {
            name = item.name + "[" + item.slotCount + "]" + item.skills.skillToString(null, true);
        }
        if (value) {
            this.candidateUnchecked[item.itemType].remove(name);
        } else {
            this.candidateUnchecked[item.itemType].add(name);
        }
    }

    public boolean isViewChecked(PSItem item) {
        String name = item.name;
        if (item.itemType == 5) {
            name = item.name + "[" + item.slotCount + "]" + item.skills.skillToString(null, true);
        }
        return !this.viewUnchecked[item.itemType].contains(name);
    }

    public void setViewChecked(PSItem item, boolean value) {
        String name = item.name;
        if (item.itemType == 5) {
            name = item.name + "[" + item.slotCount + "]" + item.skills.skillToString(null, true);
        }
        if (value) {
            this.viewUnchecked[item.itemType].remove(name);
        } else {
            this.viewUnchecked[item.itemType].add(name);
        }
    }
}

