/*
 * Decompiled with CFR 0.152.
 */
package portablesimulator.skillset;

import portablesimulator.skillset.SkillKind;

public final class SkillPoint
implements Comparable {
    public final SkillKind skillKind;
    public int skillPoint;
    public final String pointName;
    public final boolean positiveRange;

    public SkillPoint(SkillKind kind, int point, boolean positiveRange) {
        this.skillKind = kind;
        this.skillPoint = point;
        this.pointName = "";
        this.positiveRange = positiveRange;
        if (kind == null) {
            throw new NullPointerException("null");
        }
    }

    public SkillPoint(SkillKind kind, int point, boolean positiveRange, String name) {
        this.skillKind = kind;
        this.skillPoint = point;
        this.positiveRange = positiveRange;
        this.pointName = name;
        if (kind == null) {
            throw new NullPointerException("null(" + name + ")");
        }
    }

    public String toString() {
        if (this.pointName != null && this.pointName.length() > 0) {
            return this.pointName;
        }
        return this.toPointString();
    }

    public String toPointString() {
        return this.skillKind.name + "=" + this.skillPoint + (this.positiveRange ? "" : "-");
    }

    public int hashCode() {
        return this.skillKind.name.hashCode() + this.skillPoint + (this.positiveRange ? 10 : -10);
    }

    public boolean equals(Object o) {
        SkillPoint p = (SkillPoint)o;
        return this.skillKind == p.skillKind && this.skillPoint == p.skillPoint && this.positiveRange == p.positiveRange;
    }

    public int compareTo(Object o) {
        SkillPoint that = (SkillPoint)o;
        if (this == that) {
            return 0;
        }
        int x = this.skillKind.compareTo(that.skillKind);
        if (x == 0) {
            x = this.skillPoint - that.skillPoint;
        }
        if (x == 0) {
            x = (this.positiveRange ? 1 : 0) - (that.positiveRange ? 1 : 0);
        }
        if (x < 0) {
            return -1;
        }
        if (x > 0) {
            return 1;
        }
        return 0;
    }
}

