package portablesimulator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import portablesimulator.csv.Repository;
import portablesimulator.skillset.SkillKind;
import portablesimulator.skillset.SkillSet;

public class MatrixBuilderSkilled implements IMatrixBuilder {
    SkillSet targetSkill;
    int weaponSlotCount;
    
    ArrayList<PSItem> fetch;
    ArrayList<PSItem> targetDeco;
    int[] decosScore;
    int[] maxScoreOfSlot;

    int needTotal;
    int[] needAboutParts;
    int[] needAboutCopie;
    int[] topOfTheParts;
    
    ArrayList<ArrayList> arrayColumnList;
    int[] columnIndex;
    int[] columnWeight;
    
    boolean endOfMatrix;

    long skipCount;
    long returnCount;
    
    public MatrixBuilderSkilled(SkillSet targetSkills0, int slotCount) {
        arrayColumnList = new ArrayList<ArrayList>();
        targetSkill = targetSkills0;
        weaponSlotCount = slotCount;
        targetDeco = Repository.getBaseItems().listDecoration;
        decosScore = new int[targetDeco.size()];

        for (int x = 0; x < targetDeco.size(); ++ x) {
            PSItem deco = targetDeco.get(x);
            int score = 0;
            for (int i = 0; i < deco.skills.size(); ++ i) {
                SkillKind kind = deco.skills.kind(i);
                int point = deco.skills.point(i);
                boolean positive = deco.skills.positive(i);
                
                for (int j = 0; j < targetSkill.size(); ++ j) {
                    SkillKind targetKind = targetSkill.kind(j);
                    int targetPoint = targetSkill.point(j);
                    boolean targetPositive = targetSkill.positive(j);
                    
                    if (targetKind == kind) {
                        if (targetPositive) {
                            if (point >= 0 && targetPoint > 0) {
                                score += point;
                            }
                        }else {
                            if (point <= 0 && targetPoint < 0) {
                                score -= point;
                            }
                        }
                    }
                }
            }
            if (score > 0) {
                decosScore[x] = score;
                //System.out.println("deco " + deco.name + " = " + score);
            }
        }
        
        maxScoreOfSlot = new int[4];        
        maxScoreOfSlot[0] = calcScoreForSlot(0, targetDeco);
        maxScoreOfSlot[1] = calcScoreForSlot(1, targetDeco);
        maxScoreOfSlot[2] = calcScoreForSlot(2, targetDeco);
        maxScoreOfSlot[3] = calcScoreForSlot(3, targetDeco);
        
        /*
        System.out.println("score[0]"+ maxScoreOfSlot[0]);
        System.out.println("score[1]"+ maxScoreOfSlot[1]);
        System.out.println("score[2]"+ maxScoreOfSlot[2]);
        System.out.println("score[3]"+ maxScoreOfSlot[3]);
        */
    }
    
    public int calcScoreForSlot(int maxSlot, ArrayList<PSItem> listDeco) {
        int max = 0;
        for (int x = 0; x < targetDeco.size(); ++ x) {
            PSItem deco = targetDeco.get(x);
            int score = decosScore[x];
            int slot = deco.slotCount;
            
            if (score > 0 && slot > 0) {
                if (maxSlot >= slot) {
                    if (maxSlot >= slot + 1) {
                        score += calcScoreForSlot(maxSlot - slot, listDeco);
                    }

                    if (max < score) {
                        max = score;
                    }
                }
            }
        }
        return max;
    }
    
    public void addColumn(ArrayList column) {
        arrayColumnList.add(column);
    }

    public long iteratorCount() {
        long x = 1;
        for (int i = 0; i < arrayColumnList.size(); ++i) {
            ArrayList<ArrayList> column = arrayColumnList.get(i);
            x *= column.size();
        }
        return x;
    }

    public void start() {
        ArrayList array0 = arrayColumnList.get(0);
        PSWrap w00 = (PSWrap)array0.get(0);
    
        if (w00.item.itemType != PSItemType.TYPE_BODY) {
            ArrayList array1 = arrayColumnList.get(1);
            
            arrayColumnList.set(0, array1);
            arrayColumnList.set(1, array0);
        }
        
        columnIndex = new int[arrayColumnList.size()];
        columnWeight = new int[arrayColumnList.size()];

        needAboutParts = new int[arrayColumnList.size()];
        needAboutCopie = new int[arrayColumnList.size()];
        topOfTheParts = new int[arrayColumnList.size()];

        for (int i = 0; i < arrayColumnList.size(); ++ i) {
            int weight = 1;
            for (int x = i + 1; x < arrayColumnList.size(); ++ x) {
                int width = arrayColumnList.get(x).size();
                weight *= width;
            }
            columnWeight[i] = weight;
        }
    
        for (ArrayList column : arrayColumnList) {
            for(Object obj : column) {
                PSWrap wrap = (PSWrap)obj;
                SkillSet skillW = wrap.maskedSkills;
                if (skillW == null || skillW.isFixedBy(targetSkill) == false) {
                    wrap.maskedSkills = wrap.item.skills.fixColumnBy(targetSkill);
                }
            }
        }
        
        for (int i = 0; i < arrayColumnList.size(); ++ i) {
            ArrayList column = arrayColumnList.get(i);
            PSWrap top = null;

            for(Object obj : column) {
                PSWrap wrap = (PSWrap)obj;
                int tmp = maxScoreOfSlot[wrap.item.slotCount];

                SkillSet skills = wrap.maskedSkills;
                
                for (int x = 0; x < skills.size(); ++ x) {
                    SkillKind kind = skills.kind(x);
                    int point = skills.point(x);
                    boolean positive = skills.positive(x);
                    if (positive) {
                        if (point > 0) {
                            if (point > targetSkill.point(x)) {
                                tmp += targetSkill.point(x);
                            }else {
                                tmp += point;
                            }
                        }
                    }else {
                        if (point < 0) {
                            if (point < targetSkill.point(x)) {
                                tmp -= targetSkill.point(x);
                            }else {
                                tmp -= point;
                            }
                        }
                    }
                }
                if (tmp < 0) {
                    tmp = 0;
                }
                wrap.maskedSkillsSummary = tmp;
                if (top == null) {
                    top = wrap;
                }else if (tmp > top.maskedSkillsSummary) {
                    top = wrap;
                }
            }
            if (top == null) {
                topOfTheParts[i] = 0;
            }else {
                //System.out.println(top.item.name +" = " + top.maskedSkills + top.item.slotCount + " (" + top.maskedSkillsSummary + ")");
                topOfTheParts[i] = top.maskedSkillsSummary;
            }
            
            Collections.sort(column, new Comparator<Object>() {
                public int compare(Object o1, Object o2) {
                    PSWrap w1 = (PSWrap)o1;
                    PSWrap w2 = (PSWrap)o2;
                    
                    if (w1.item.isCopieSkill) {
                        if (w2.item.isCopieSkill) {
                            return 0; 
                        }
                        return -1;
                    }else if (w2.item.isCopieSkill) {
                        return 1;
                    }
                    if (w1.maskedSkillsSummary > w2.maskedSkillsSummary) {
                        return -1;
                    }else if (w1.maskedSkillsSummary == w2.maskedSkillsSummary) {
                        return 0;
                    }else {
                        return 1;
                    }
                }
            });
        }

        needTotal = 0;

        for (int i = 0; i < targetSkill.size(); ++ i) {
            if (targetSkill.positive(i)) {
                if (targetSkill.point(i) > 0) {
                    needTotal += targetSkill.point(i);
                }
            }else {
                if (targetSkill.point(i) < 0) {
                    needTotal -= targetSkill.point(i);
                }
            }
        }
        
        //System.out.println("needTotal = " + needTotal);
        
        if (weaponSlotCount >= 1) {
            if (needTotal >= maxScoreOfSlot[weaponSlotCount]) {
                needTotal -= maxScoreOfSlot[weaponSlotCount];
            }else {
                needTotal = 0;
            }
        }

        //System.out.println("needTotal2 = " + needTotal);
        
        for (int i = 0; i < arrayColumnList.size(); ++ i) {
            int need = needTotal/* + topOfTheParts[0]*/;
            int needBody = needTotal; 
            
            for (int j = i + 1; j < arrayColumnList.size(); ++ j) {
                need -= topOfTheParts[j];
                if (topOfTheParts[0] > topOfTheParts[j]) {
                    needBody -= topOfTheParts[0];
                }else {
                    needBody -= topOfTheParts[j];
                }
            }

            //System.out.println("need for " + targetSkill + "=[" + i + "] part = " + need + " / body = " + needBody);
            needAboutParts[i] = need;
            needAboutCopie[i] = needBody;
        }
        
        skipCount = 0; 
    }
    
    int getFailedColumn(ArrayList listWrap) {
        boolean hasBodyCopie = false;
        for (int x = 0; x < listWrap.size(); ++ x) {
            PSWrap wrap = (PSWrap)listWrap.get(x);
            if (wrap.item.isCopieSkill) {
                hasBodyCopie = true;
                break;
            }
        }
        
        int summary = 0;
        int failed = -1;

        if (hasBodyCopie) {
            PSWrap body = (PSWrap)listWrap.get(0);
            summary = body.maskedSkillsSummary;
            for (int x = 1; x < listWrap.size(); ++ x) {
                PSWrap wrap = (PSWrap)listWrap.get(x);
                if (wrap.item.isCopieSkill) {
                    summary += body.maskedSkillsSummary;
                }else {
                    summary += wrap.maskedSkillsSummary;
                }
                if (needAboutCopie[x] > summary) {
                    return x;
                }
            }
        }else {
            for (int x = 0; x < listWrap.size(); ++ x) {
                PSWrap wrap = (PSWrap)listWrap.get(x);
                summary += wrap.maskedSkillsSummary;
                if (needAboutParts[x] > summary) {
                    return x;
                }
            }
        }
        return -1;
    }

    boolean fetchInternal(ArrayList result) {
        if (endOfMatrix) {
            return false;
        }
        result.clear();
        for (int i = 0; i < arrayColumnList.size(); ++ i) {
            ArrayList e = arrayColumnList.get(i);
            result.add(e.get(columnIndex[i]));
        }
        return true;
    }
    
    public long skipCount() {
        return skipCount - returnCount;
    }
    
    public boolean next(ArrayList result) {
        while (true) {
            boolean ret = fetchInternal(result);
            if (ret == false) {
                return false;
            }
            if (true) {
                int failed = getFailedColumn(result);
                if (failed >= 0) {
                    boolean hasBodyCopie = false;
                    for (int x = 0; x < result.size(); ++ x) {
                        PSWrap wrap = (PSWrap)result.get(x);
                        if (wrap.item.isCopieSkill) {
                            hasBodyCopie = true;
                            break;
                        }
                    }
                    if (hasBodyCopie || failed == 0) {
                        skipToNext(failed);
                    }else {
                        skipToNext(failed - 1);
                    }
                    continue;
                }
            }
            skipToNext(arrayColumnList.size() - 1);
            PSWrap head = (PSWrap)result.get(1);
            PSWrap body = (PSWrap)result.get(0);
            result.set(0, head);
            result.set(1, body);
            returnCount ++;
            return true;
        }
    }
        
    boolean skipToNext(int column) {
        if (endOfMatrix) {
            return false;
        }
        
        if (column < 0) {
            endOfMatrix = true;
            return false;
        }
        
        boolean firstEnter = true;
        
        while (true) {
            long orgSkip = skipCount;

            columnIndex[column] ++;
            if (firstEnter) {
                skipCount += columnWeight[column];
                firstEnter = false;
                
                boolean deced = false;
                if (column + 1 <= arrayColumnList.size()) {
                    for (int j = column + 1; j < arrayColumnList.size(); ++ j) {
                        int x1 = columnWeight[j] * columnIndex[j];
                        skipCount -= x1;
                        if (x1 != 0) {
                            deced = true;
                        }
                    }
                }
            }
            for (int j = column + 1; j < arrayColumnList.size(); ++ j) {
                columnIndex[j] = 0;
            }

            ArrayList e = arrayColumnList.get(column);

            if (columnIndex[column] >= e.size()) {
                column --;
                if (column < 0) {
                    endOfMatrix = true;
                    return false;
                }
                 continue;   
            }else {
                break;
            }
        }
        return true;
    }
}
