package portablesimulator.csv;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import portablesimulator.PSItem;
import portablesimulator.PSItemType;

class MH3GResource implements GameResource {
    private MH3GDataIO reader = new MH3GDataIO();
    private boolean monoArmor = true;

    public String nameOfGame() {
        return "MH3G";
    }

    public boolean existCharm() {
        return true;
    }

    public boolean existCharmG() {
        return true;
    }

    public void readCSV() throws IOException {
        reader.readAll();
    }

    public Color getArmorColor(PSItem item) {
        if (monoArmor) {
            return Color.white;
        }
        if (item.itemType == PSItemType.TYPE_DECORATION) {
            return Color.white;
        }
        if (item.itemType == PSItemType.TYPE_CHARM) {
            if (item.name.startsWith("")) {
                return Color.red;
            }
            if (item.name.startsWith("")) {
                return Color.green;
            }
            if (item.name.startsWith("")) {
                return Color.cyan;
            }
            if (item.name.startsWith("")) {
                return Color.pink;
            }
            if (item.name.startsWith("Rm")) {
                return Color.yellow;
            }
            if (item.name.startsWith("m")) {
                return Color.magenta;
            }
            return Color.white;
        }
        switch (item.rareRank) {
            case 1:
                return Color.white;
            case 2:
                return Color.magenta;
            case 3:
                return Color.yellow;
            case 4:
                return Color.pink;
            case 5:
                return Color.green;
            case 6:
                return Color.cyan;
            case 7:
                return Color.red;
        }
        return Color.white;
    }

    public String getConfigFile() {
        return "PSConfig3G.ini";
    }

    public String getMysetFile() {
        return "PSMySet3G.ini";
    }

    public List<PSItem> readCharmCSV(String fileName) throws IOException {
        ArrayList<PSItem> listCharm = new ArrayList<PSItem>();
        reader.readCharmCSVFile(PSItemType.TYPE_CHARM, fileName, listCharm);
        return listCharm;
    }

    public boolean existFukugo() {
        return true;
    }
}
