package data.data_mhp3;

import java.io.FileNotFoundException;
import portablesimulator.skillset.SkillPoint;
import portablesimulator.skillset.SkillKind;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import portablesimulator.PSItem;
import portablesimulator.PSItemMaterial;
import portablesimulator.PSItemType;
import portablesimulator.csv.CSVReader;
import portablesimulator.csv.PSBaseItems;
import portablesimulator.csv.Repository;
import portablesimulator.skillset.SkillCategories;
import portablesimulator.skillset.SkillSet;

class MHP3DataIO {

    public MHP3DataIO() {
    }

    public void readAll() throws IOException {
        readSkillsCSV("data_mhp3/MH3SKILL.csv");
        readSkillCategories("data_mhp3/CATEGORY.txt");

        ArrayList<PSItem> listEquipHead = new ArrayList<PSItem>();
        ArrayList<PSItem> listEquipBody = new ArrayList<PSItem>();
        ArrayList<PSItem> listEquipArm = new ArrayList<PSItem>();
        ArrayList<PSItem> listEquipWeist = new ArrayList<PSItem>();
        ArrayList<PSItem> listEquipLeg = new ArrayList<PSItem>();

        ArrayList<PSItem> listUserEquipHead = new ArrayList<PSItem>();
        ArrayList<PSItem> listUserEquipBody = new ArrayList<PSItem>();
        ArrayList<PSItem> listUserEquipArm = new ArrayList<PSItem>();
        ArrayList<PSItem> listUserEquipWeist = new ArrayList<PSItem>();
        ArrayList<PSItem> listUserEquipLeg = new ArrayList<PSItem>();

        ArrayList<PSItem> listTrashEquipHead = new ArrayList<PSItem>();
        ArrayList<PSItem> listTrashEquipBody = new ArrayList<PSItem>();
        ArrayList<PSItem> listTrashEquipArm = new ArrayList<PSItem>();
        ArrayList<PSItem> listTrashEquipWeist = new ArrayList<PSItem>();
        ArrayList<PSItem> listTrashEquipLeg = new ArrayList<PSItem>();

        readEquipmentCSV(PSItemType.TYPE_HEAD, "data_mhp3/MH3EQUIP_HEAD.csv", listEquipHead);
        readEquipmentCSV(PSItemType.TYPE_BODY, "data_mhp3/MH3EQUIP_BODY.csv", listEquipBody);
        readEquipmentCSV(PSItemType.TYPE_ARM, "data_mhp3/MH3EQUIP_ARM.csv", listEquipArm);
        readEquipmentCSV(PSItemType.TYPE_WEIST, "data_mhp3/MH3EQUIP_WST.csv", listEquipWeist);
        readEquipmentCSV(PSItemType.TYPE_LEG, "data_mhp3/MH3EQUIP_LEG.csv", listEquipLeg);

        readEquipmentCSV(PSItemType.TYPE_HEAD, "data_mhp3/MH3EQUIP_USER_HEAD.csv", listUserEquipHead);
        readEquipmentCSV(PSItemType.TYPE_BODY, "data_mhp3/MH3EQUIP_USER_BODY.csv", listUserEquipBody);
        readEquipmentCSV(PSItemType.TYPE_ARM, "data_mhp3/MH3EQUIP_USER_ARM.csv", listUserEquipArm);
        readEquipmentCSV(PSItemType.TYPE_WEIST, "data_mhp3/MH3EQUIP_USER_WST.csv", listUserEquipWeist);
        readEquipmentCSV(PSItemType.TYPE_LEG, "data_mhp3/MH3EQUIP_USER_LEG.csv", listUserEquipLeg);

        readEquipmentCSV(PSItemType.TYPE_HEAD, "data_mhp3/MH3EQUIP_TRASH_HEAD.csv", listTrashEquipHead);
        readEquipmentCSV(PSItemType.TYPE_BODY, "data_mhp3/MH3EQUIP_TRASH_BODY.csv", listTrashEquipBody);
        readEquipmentCSV(PSItemType.TYPE_ARM, "data_mhp3/MH3EQUIP_TRASH_ARM.csv", listTrashEquipArm);
        readEquipmentCSV(PSItemType.TYPE_WEIST, "data_mhp3/MH3EQUIP_TRASH_WST.csv", listTrashEquipWeist);
        readEquipmentCSV(PSItemType.TYPE_LEG, "data_mhp3/MH3EQUIP_TRASH_LEG.csv", listTrashEquipLeg);

        ArrayList<PSItem> listDecoration = new ArrayList<PSItem>();
        ArrayList<PSItem> listUserDecoration = new ArrayList<PSItem>();
        ArrayList<PSItem> listTrashDecoration = new ArrayList<PSItem>();

        readDecorationCSV(PSItemType.TYPE_DECORATION, "data_mhp3/MH3DECO.csv", listDecoration);
        readDecorationCSV(PSItemType.TYPE_DECORATION, "data_mhp3/MH3DECO_USER.csv", listUserDecoration);
        readDecorationCSV(PSItemType.TYPE_DECORATION, "data_mhp3/MH3DECO_TRASH.csv", listUserDecoration);

        PSBaseItems cont = Repository.getBaseItems();

        cont.listBaseEquipHead = listEquipHead;
        cont.listBaseEquipBody = listEquipBody;
        cont.listBaseEquipArm = listEquipArm;
        cont.listBaseEquipWeist = listEquipWeist;
        cont.listBaseEquipLeg = listEquipLeg;
        cont.listBaseCharm = new ArrayList<PSItem>();
        cont.listBaseDecoration = listDecoration;

        cont.listUserEquipHead = listUserEquipHead;
        cont.listUserEquipBody = listUserEquipBody;
        cont.listUserEquipArm = listUserEquipArm;
        cont.listUserEquipWeist = listUserEquipWeist;
        cont.listUserEquipLeg = listUserEquipLeg;
        cont.listUserCharm = new ArrayList<PSItem>();;
        cont.listUserDecoration = listUserDecoration;

        cont.listTrashEquipHead = listTrashEquipHead;
        cont.listTrashEquipBody = listTrashEquipBody;
        cont.listTrashEquipArm = listTrashEquipArm;
        cont.listTrashEquipWeist = listTrashEquipWeist;
        cont.listTrashEquipLeg = listTrashEquipLeg;
        cont.listTrashCharm = new ArrayList<PSItem>();;
        cont.listTrashDecoration = listTrashDecoration;

        cont.invalidate();
    }

    public void readSkillsCSV(String fileName) throws IOException {
        CSVReader in = new CSVReader(fileName);
        SkillCategories categories = Repository.getSkillCategories();
        List<String> str = new ArrayList<String>();

        try {
            while (true) {
                if (in.readLine(str) == false) {
                    break;
                }

                String skillName = str.get(0);
                String skillKind = str.get(1);
                int skillPoint = Integer.parseInt(str.get(2));
                int hunterType = Integer.parseInt(str.get(3));

                SkillKind kindObj = null;
                kindObj = categories.findKindByName(skillKind);
                if (kindObj == null) {
                    kindObj = new SkillKind(skillKind);
                    categories.addSkillKind(kindObj);
                }

                SkillPoint rank;
                rank = new SkillPoint(kindObj, skillPoint, skillPoint > 0, skillName);
                categories.addPoint(rank);
            }
        } finally {
            in.close();
        }
    }

    public void readEquipmentCSV(int itemType, String fileName, List<PSItem> list) throws IOException {
        CSVReader in = null;
        List<String> str = new ArrayList<String>();
        SkillCategories categories = Repository.getSkillCategories();

        try {
            try {
                in = new CSVReader(fileName);
            }catch(IOException e) {
                return;
            }

            while (true) {
                if (in.readLine(str) == false) {
                    break;
                }

                PSItem item = new PSItem(itemType);

                Iterator<String> it = str.iterator();

                item.name = it.next();
                item.genderType = Integer.parseInt(it.next());
                item.hunterType = Integer.parseInt(it.next());
                item.rareRank = Integer.parseInt(it.next());
                item.slotCount = Integer.parseInt(it.next());
                item.existHunterRank = Integer.parseInt(it.next());
                item.existTownRank = Integer.parseInt(it.next());
                item.defInitial = Integer.parseInt(it.next());
                item.defMax = Integer.parseInt(it.next());
                item.shellFire = Integer.parseInt(it.next());
                item.shellWater = Integer.parseInt(it.next());
                item.shellIce = Integer.parseInt(it.next());
                item.shellThunder = Integer.parseInt(it.next());
                item.shellDragon = Integer.parseInt(it.next());

                for (int i = 0; it.hasNext() && i < 5; ++i) {
                    String name = it.next();
                    if (name.length() == 0) {
                        it.next();
                        continue;
                    }
                    int point = Integer.parseInt(it.next());

                    if (name.equals("n")) {
                        item.isCopieSkill = true;
                        continue;
                    }
                    if (name.startsWith("---")) {
                        continue;
                    }

                    SkillKind kind = categories.findKindByName(name);
                    item.skills.set(kind, point, true);
                }

                for (int i = 0; it.hasNext() && i < 4; ++i) {
                    PSItemMaterial material = new PSItemMaterial();
                    material.name = it.next().intern();
                    if (material.name.length() != 0) {
                        material.count = Integer.parseInt(it.next());
                        item.materialAList.add(material);
                    } else {
                        if (it.hasNext()) {
                            it.next();
                        }
                    }
                }
                list.add(item);
            }
        } finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public void readDecorationCSV(int itemType, String fileName, List<PSItem> list) throws IOException {
        CSVReader in = null;
        List<String> str = new ArrayList<String>();
        SkillCategories categories = Repository.getSkillCategories();

        try {
            try {
                in = new CSVReader(fileName);
            }catch(IOException e) {
                return;
            }
            while (true) {
                if (in.readLine(str) == false) {
                    break;
                }

                PSItem item = new PSItem(itemType);

                Iterator<String> it = str.iterator();

                item.name = it.next();
                item.rareRank = Integer.parseInt(it.next());
                item.slotCount = Integer.parseInt(it.next());
                item.existHunterRank = Integer.parseInt(it.next());
                item.existTownRank = Integer.parseInt(it.next());

                for (int i = 0; it.hasNext() && i < 2; ++i) {
                    String name = it.next();
                    if (name.length() == 0) {
                        it.next();
                        continue;
                    }
                    int point = Integer.parseInt(it.next());

                    if (name.startsWith("---")) {
                        continue;
                    }
                    SkillKind kind = categories.findKindByName(name);
                    item.skills.set(kind, point, true);
                }

                for (int i = 0; it.hasNext() && i < 4; ++i) {
                    PSItemMaterial material = new PSItemMaterial();
                    material.name = it.next().intern();
                    if (material.name.length() != 0) {
                        material.count = Integer.parseInt(it.next());
                        item.materialAList.add(material);
                    } else {
                        if (it.hasNext()) {
                            it.next();
                        }
                    }
                }
                for (int i = 0; it.hasNext() && i < 4; ++i) {
                    PSItemMaterial material = new PSItemMaterial();
                    material.name = it.next();
                    if (material.name.length() != 0) {
                        material.count = Integer.parseInt(it.next());
                        item.materialBList.add(material);
                    } else {
                        if (it.hasNext()) {
                            it.next();
                        }
                    }
                }
                list.add(item);
            }
        } finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public void readCharmCSVFile(int itemType, String fileName, List<PSItem> list) throws IOException {
        CSVReader in = new CSVReader(fileName);
        ArrayList<PSItem> infoList = new ArrayList<PSItem>();
        List<String> str = new ArrayList<String>();
        SkillCategories categories = Repository.getSkillCategories();

        try {
            while (true) {
                if (in.readLine(str) == false) {
                    break;
                }

                PSItem item = new PSItem(itemType);
                Iterator<String> it = str.iterator();

                item.name = it.next();
                item.slotCount = Integer.parseInt(it.next());

                for (int i = 0; it.hasNext() && i < 2; ++i) {
                    String name = it.next();
                    if (name.length() == 0) {
                        it.next();
                        continue;
                    }
                    int point = Integer.parseInt(it.next());

                    try {
                        SkillKind kind = categories.findKindByName(name);
                        item.skills.set(kind, point, true);
                    } catch (Exception e) {
                        e.printStackTrace();
                        ;
                    }
                }
                list.add(item);
            }
        } finally {
            in.close();
        }
    }

    public void readSkillCategories(String fileName) throws IOException {
        CSVReader in = new CSVReader(fileName);
        SkillCategories categories = Repository.getSkillCategories();
        List<String> str = new ArrayList<String>();

        try {
            while (true) {
                if (in.readLine(str) == false) {
                    break;
                }

                String categoryName = str.get(0);
                categories.addCategory(categoryName);
                for (int i = 1; i < str.size(); ++i) {
                    String skillName = str.get(i);
                    categories.setCategory(categoryName, skillName);
                }
            }
        } finally {
            in.close();
        }
    }
}
