package portablesimulator.gui;

import java.awt.Color;
import java.awt.ComponentOrientation;
import javax.swing.JLabel;
import portablesimulator.PSArmorSet;
import portablesimulator.PSItemType;
import portablesimulator.PSWrap;
import portablesimulator.csv.Repository;

public class MyPanelForArmorSet extends javax.swing.JPanel {
    PSArmorSet set;

    /** Creates new form JPanelArmorSet */
    public MyPanelForArmorSet() {
        initComponents();
    }

    public void updateUI() {
        super.updateUI();
        if (set != null) {
            setItem(set);
        }
    }

    public void setItem(PSArmorSet set) {
        this.set = set;

        JLabel[] armorLabels = new JLabel[] {
            jTextHead,
            jTextBody,
            jTextArm,
            jTextWeist,
            jTextLeg,
            jTextCharm,
        };
        if (set != null) {
            jTextSummary.setText("h [" + set.defInitial + "" + set.defMax + "]^X[" + set.totalSlotCount + "][" + (set.weaponSlotCount < 0 ? 0 : set.weaponSlotCount) + "]");
            int max;
            if (Repository.getResource().existCharm()) {
                max = PSItemType.TYPE_CHARM;
            }else {
                max = PSItemType.TYPE_LEG;
            }
            for(int i = PSItemType.TYPE_HEAD; i <= max; ++ i) {
                PSWrap wrap = set.listItems.get(i);
                armorLabels[i].setText(wrap.item.getArmorNameAndSlot());
                Color c = Repository.getResource().getArmorColor(wrap.item);
                if (!Repository.getConfig().themeLabelColorful) {
                    while (c.getBlue() + c.getGreen() + c.getRed() > 240) {
                        c = c.darker();
                    }
                }
                armorLabels[i].setForeground(c);
            }
            String shell1 = set.getShellValuesAsText();
            String shell2 = "";
            int x = shell1.indexOf("");
            if (x >= 0) {
                shell2 = shell1.substring(x);
                shell1 = shell1.substring(0, x);
            }
            jTextShell.setText(shell1);
            jTextShell2.setText(shell2);
            jLabelNumber.setText("" + set.mysetNumber);
            jTextName.setText(set.mysetName == null ? "" : set.mysetName);
        }
        jLabelCharm.setVisible(Repository.getResource().existCharm());
        jTextCharm.setVisible(Repository.getResource().existCharm());
        if (set.mysetPicturePath != null && set.mysetPicturePath.length() > 0) {
            jLabelPict.setText("");
            jLabelPict.setForeground(Color.MAGENTA);
            jLabelPict.setVisible(true);
        }else {
            jLabelPict.setVisible(false);
        }
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jLabelNumber = new javax.swing.JLabel();
        jTextName = new javax.swing.JLabel();
        jTextSummary = new javax.swing.JLabel();
        jLabelHead = new javax.swing.JLabel();
        jTextHead = new javax.swing.JLabel();
        jLabelBody = new javax.swing.JLabel();
        jTextBody = new javax.swing.JLabel();
        jLabelArm = new javax.swing.JLabel();
        jTextArm = new javax.swing.JLabel();
        jLabelWeist = new javax.swing.JLabel();
        jTextWeist = new javax.swing.JLabel();
        jLabelLeg = new javax.swing.JLabel();
        jTextLeg = new javax.swing.JLabel();
        jLabelShell = new javax.swing.JLabel();
        jTextShell = new javax.swing.JLabel();
        jTextShell2 = new javax.swing.JLabel();
        jLabelCharm = new javax.swing.JLabel();
        jTextCharm = new javax.swing.JLabel();
        jLabelPict = new javax.swing.JLabel();

        setBorder(javax.swing.BorderFactory.createCompoundBorder(new javax.swing.border.SoftBevelBorder(javax.swing.border.BevelBorder.RAISED), javax.swing.BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        setLayout(new java.awt.GridBagLayout());

        jLabelNumber.setText("num");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        add(jLabelNumber, gridBagConstraints);

        jTextName.setText("name");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        add(jTextName, gridBagConstraints);

        jTextSummary.setText("summary");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        add(jTextSummary, gridBagConstraints);

        jLabelHead.setText(":");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        add(jLabelHead, gridBagConstraints);

        jTextHead.setText("atama");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        add(jTextHead, gridBagConstraints);

        jLabelBody.setText(":");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        add(jLabelBody, gridBagConstraints);

        jTextBody.setText("dou");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        add(jTextBody, gridBagConstraints);

        jLabelArm.setText("r:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        add(jLabelArm, gridBagConstraints);

        jTextArm.setText("arm");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        add(jTextArm, gridBagConstraints);

        jLabelWeist.setText(":");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        add(jLabelWeist, gridBagConstraints);

        jTextWeist.setText("weist");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        add(jTextWeist, gridBagConstraints);

        jLabelLeg.setText(":");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        add(jLabelLeg, gridBagConstraints);

        jTextLeg.setText("leg");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        add(jTextLeg, gridBagConstraints);

        jLabelShell.setText("ϐl:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        add(jLabelShell, gridBagConstraints);

        jTextShell.setText("shell");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        add(jTextShell, gridBagConstraints);

        jTextShell2.setText("shell2");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weighty = 1.0;
        add(jTextShell2, gridBagConstraints);

        jLabelCharm.setText(":");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        add(jLabelCharm, gridBagConstraints);

        jTextCharm.setText("charm");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        add(jTextCharm, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        add(jLabelPict, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabelArm;
    private javax.swing.JLabel jLabelBody;
    private javax.swing.JLabel jLabelCharm;
    private javax.swing.JLabel jLabelHead;
    private javax.swing.JLabel jLabelLeg;
    private javax.swing.JLabel jLabelNumber;
    private javax.swing.JLabel jLabelPict;
    private javax.swing.JLabel jLabelShell;
    private javax.swing.JLabel jLabelWeist;
    private javax.swing.JLabel jTextArm;
    private javax.swing.JLabel jTextBody;
    private javax.swing.JLabel jTextCharm;
    private javax.swing.JLabel jTextHead;
    private javax.swing.JLabel jTextLeg;
    private javax.swing.JLabel jTextName;
    private javax.swing.JLabel jTextShell;
    private javax.swing.JLabel jTextShell2;
    private javax.swing.JLabel jTextSummary;
    private javax.swing.JLabel jTextWeist;
    // End of variables declaration//GEN-END:variables
}
