/*
 * Decompiled with CFR 0.152.
 */
package portablesimulator.charm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import portablesimulator.PSItem;
import portablesimulator.charm.Charm;
import portablesimulator.csv.CSVReader;
import portablesimulator.csv.Repository;
import portablesimulator.skillset.SkillCategories;
import portablesimulator.skillset.SkillKind;
import portablesimulator.skillset.SkillSet;

public class CharmDB {
    public static final ArrayList<String> acceptTypes = new ArrayList();
    SkillCategories categories;
    List<Charm> listCharm = new ArrayList<Charm>();

    static void init() {
        acceptTypes.add("\u5175\u58eb");
        acceptTypes.add("\u9a0e\u58eb");
        acceptTypes.add("\u95d8\u58eb");
        acceptTypes.add("\u57ce\u585e");
        acceptTypes.add("\u738b");
        acceptTypes.add("\u5973\u738b");
        acceptTypes.add("\u9f8d");
        if (Repository.getResource().existCharmG()) {
            acceptTypes.add("\u82f1\u96c4");
            acceptTypes.add("\u4f1d\u8aac");
            acceptTypes.add("\u5929");
        }
    }

    public CharmDB(SkillCategories categories) {
        this.categories = categories;
    }

    public void readProperties() throws IOException {
        this.listCharm.clear();
        this.readPropertiesSub(0, "data_mhp3/CHARM_NAZO.csv");
        this.readPropertiesSub(1, "data_mhp3/CHARM_HIKARU.csv");
        this.readPropertiesSub(2, "data_mhp3/CHARM_FURUI.csv");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readPropertiesSub(int stone, String fileName) throws IOException {
        CSVReader in = new CSVReader(fileName);
        ArrayList infoList = new ArrayList();
        ArrayList<String> str = new ArrayList<String>();
        try {
            while (true) {
                SkillKind kind2;
                SkillKind kind1;
                int nSlot;
                int nTable;
                int nPoint2;
                int nPoint1;
                String strName;
                block18: {
                    if (!in.readLine(str)) {
                        break;
                    }
                    if (str.size() < 8) {
                        System.out.println("SKIP: " + str);
                        continue;
                    }
                    String strSeed = (String)str.get(0);
                    String strSkill1 = (String)str.get(1);
                    String strPoint1 = (String)str.get(2);
                    String strSkill2 = (String)str.get(3);
                    String strPoint2 = (String)str.get(4);
                    String strSlot = (String)str.get(5);
                    strName = (String)str.get(6);
                    String strTable = (String)str.get(7);
                    try {
                        int nSeed = Integer.parseInt(strSeed);
                        nPoint1 = Integer.parseInt(strPoint1);
                        nPoint2 = Integer.parseInt(strPoint2);
                        nTable = Integer.parseInt(strTable);
                        nSlot = Integer.parseInt(strSlot);
                        kind1 = null;
                        kind2 = null;
                        if (strSkill1.length() > 0) {
                            if (strSkill1.startsWith("--")) continue;
                            if (strSkill1.equals("\u5265\u304e\u3068\u308a")) {
                                strSkill1 = "\u5265\u304e\u53d6\u308a";
                            }
                            if (strSkill1.endsWith("\u30d3\u30f3\u8ffd\u52a0")) {
                                strSkill1 = strSkill1.substring(0, strSkill1.length() - 4) + "\u74f6\u8ffd\u52a0";
                            }
                            if (strSkill1.equals("\u63a5\u6fc0\u74f6\u8ffd\u52a0")) {
                                strSkill1 = "\u63a5\u6483\u74f6\u8ffd\u52a0";
                            }
                            if ((kind1 = this.categories.findKindByName(strSkill1)) == null) {
                                throw new IllegalArgumentException(strSkill1);
                            }
                        }
                        if (strSkill2.length() <= 0) break block18;
                        if (strSkill2.startsWith("--")) continue;
                        if (strSkill2.equals("\u5265\u304e\u3068\u308a")) {
                            strSkill2 = "\u5265\u304e\u53d6\u308a";
                        }
                        if (strSkill2.endsWith("\u30d3\u30f3\u8ffd\u52a0")) {
                            strSkill2 = strSkill2.substring(0, strSkill2.length() - 4) + "\u74f6\u8ffd\u52a0";
                        }
                        if (strSkill2.equals("\u63a5\u6fc0\u74f6\u8ffd\u52a0")) {
                            strSkill2 = "\u63a5\u6483\u74f6\u8ffd\u52a0";
                        }
                        if ((kind2 = this.categories.findKindByName(strSkill2)) == null) {
                            throw new IllegalArgumentException(strSkill2);
                        }
                    }
                    catch (Exception e) {
                        continue;
                    }
                }
                Charm charm = new Charm(stone, nTable, strName, nSlot, kind1, nPoint1, kind2, nPoint2);
                this.listCharm.add(charm);
            }
        }
        finally {
            in.close();
        }
    }

    public List<PSItem> readExtraCharm(SkillSet searchSkills) {
        ArrayList<PSItem> listCharm2 = new ArrayList<PSItem>();
        for (Charm charm : this.listCharm) {
            boolean hit = false;
            for (int i = 0; i < charm.skills.size(); ++i) {
                int x = searchSkills.indexOfKind(charm.skills.kind(i));
                if (x < 0) continue;
                if (searchSkills.positive(x)) {
                    if (charm.skills.point(i) <= 0) break;
                    hit = true;
                    break;
                }
                if (charm.skills.point(i) >= 0) break;
                hit = true;
                break;
            }
            if (!hit) continue;
            PSItem item = new PSItem(5);
            item.name = charm.name + " T" + charm.tableNumber;
            item.slotCount = charm.slotCount;
            item.skills.set_all(charm.skills);
            listCharm2.add(item);
        }
        return listCharm2;
    }
}

