/*
 * Decompiled with CFR 0.152.
 */
package portablesimulator.csv;

import data.data_mhp3.MHP3Resource;
import javax.swing.JOptionPane;
import portablesimulator.charm.CharmDB;
import portablesimulator.csv.GameResource;
import portablesimulator.csv.PSBaseItems;
import portablesimulator.csv.PSConfig;
import portablesimulator.csv.PSMySet;
import portablesimulator.skillset.SkillCategories;
import portablesimulator.skillset.SkillFukugo;

public class Repository {
    private static GameResource resource;
    private static SkillCategories categories;
    private static CharmDB charm;
    private static PSConfig config;
    private static PSMySet myset;
    private static PSBaseItems baseItems;
    private static SkillFukugo fukugo;
    static boolean inited;

    public static GameResource getResource() {
        return resource;
    }

    public static SkillCategories getSkillCategories() {
        return categories;
    }

    public static CharmDB getCharmDB() {
        return charm;
    }

    public static PSConfig getConfig() {
        return config;
    }

    public static PSMySet getMySet() {
        return myset;
    }

    public static PSBaseItems getBaseItems() {
        return baseItems;
    }

    public static SkillFukugo getFukugo() {
        return fukugo;
    }

    public static void init() {
        if (inited) {
            return;
        }
        inited = true;
        try {
            baseItems = new PSBaseItems();
            resource = new MHP3Resource();
            config = new PSConfig(resource.getConfigFile());
            myset = new PSMySet(resource.getMysetFile());
            categories = new SkillCategories();
            charm = new CharmDB(categories);
            fukugo = new SkillFukugo();
            resource.readCSV();
            config.readProperties();
            myset.readProperties();
            baseItems.invalidate();
            if (resource.existCharm()) {
                charm.readProperties();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "\u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3\u3092\u521d\u671f\u5316\u3067\u304d\u307e\u305b\u3093\u3002" + e);
            System.exit(-1);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    Repository.getConfig().writeProperties();
                    Repository.getMySet().writeProperties();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(null, e.toString());
                }
            }
        });
    }

    static {
        inited = false;
    }
}

