//
//  ArmorP3V1AppDelegate.m
//  ArmorP3V1
//

#import "ArmorP3V1AppDelegate.h"
#import "CreditViewController.h"
#import "TableControllerForMenu.h"
#import "TableControllerForSetting.h"
#import "TableControllerForMySet.h"
#import "TableControllerForCharmList.h"
#import "PSMutex.h"
#import "LineReader.h"

@implementation ArmorP3V1AppDelegate

@synthesize window=_window;
@synthesize tabBarController = _tabBarController;
@synthesize naviForTop = _naviForTop;
@synthesize naviForSetting = _naviForSetting;

void uncaughtExceptionHandler(NSException *exception) {
    NSLog(@"exception %@ %@", exception, [exception callStackSymbols]);
    // Internal error reporting
}

/*
 - (BOOL)application:(UIApplication *)application didFinishLaunchingWithOptions:(NSDictionary *)launchOptions
 {
 // Override point for customization after application launch.
 // Add the navigation controller's view to the window and display.
 self.window.rootViewController = self.navigationController;
 [self.window makeKeyAndVisible];
 return YES;
 }*/

static ArmorP3V1AppDelegate* delegate = nil;

+(ArmorP3V1AppDelegate*)appInstance {
    return delegate;
}

- (void)applicationDidFinishLaunching:(UIApplication *)application {
    [PSMutex createMainMutex];
    NSLog(@"app start");
    
    NSSetUncaughtExceptionHandler(&uncaughtExceptionHandler);
    delegate = self;
    
    TableControllerForMenu* view1 = [[TableControllerForMenu alloc]init];
    TableControllerForSetting* view2 = [[TableControllerForSetting alloc]initWithStyle:
                                        UITableViewStyleGrouped];
    TableControllerForCharmList* view3 = [[TableControllerForCharmList alloc]init];
    TableControllerForMySet* view4 = [[TableControllerForMySet alloc]init];
    CreditViewController* view5 = [[CreditViewController alloc]init];
    
    _tabBarController = [[UITabBarController alloc] init];
    _tabBarController.delegate = self;
    
    UINavigationController *navi1 = [[UINavigationController
                                      alloc] initWithRootViewController:view1];
    
    UINavigationController *navi2 = [[UINavigationController
                                      alloc] initWithRootViewController:view2];
    
    UINavigationController *navi3 = [[UINavigationController
                                      alloc] initWithRootViewController:view3];
    
    UINavigationController *navi4 = [[UINavigationController
                                      alloc] initWithRootViewController:view4];
    //self.navigationController = navi1;
    
    _naviForTop = navi1;
    [_naviForTop retain];
    _naviForSetting = navi2;
    [_naviForSetting retain];
    
    [_tabBarController setViewControllers:[NSArray arrayWithObjects:navi1, navi2, navi3, navi4, view5, nil]];
    [_tabBarController setSelectedIndex:0];
    
    UITabBarItem *tbi1 = [_tabBarController.tabBar.items objectAtIndex:0];
    tbi1.title = @"検索";
    UITabBarItem *tbi2 = [_tabBarController.tabBar.items objectAtIndex:1];
    tbi2.title = @"キャラ";
    UITabBarItem *tbi3 = [_tabBarController.tabBar.items objectAtIndex:2];
    tbi3.title = @"お守り";
    UITabBarItem *tbi4 = [_tabBarController.tabBar.items objectAtIndex:3];
    tbi4.title = @"マイセット";
    UITabBarItem *tbi5 = [_tabBarController.tabBar.items objectAtIndex:4];
    tbi5.title = @"アプリ";

    [PSMutex mainMutex];
    
    UIWindow *w = [[UIWindow alloc] initWithFrame:[[UIScreen mainScreen] bounds]];
    self.window = w;
    //[self.window addSubview:[_tabBarController view]];
    self.window.rootViewController = _tabBarController;
    [self.window makeKeyAndVisible];

    //[tabBarController release];    
    [view1 release]; 
    [view2 release];    
    [view3 release]; 
    [view4 release];    
    [view5 release];
    [navi1 release];
    [navi2 release];
    [navi4 release];
}

- (void)applicationWillResignActive:(UIApplication *)application
{
    /*
     Sent when the application is about to move from active to inactive state. This can occur for certain types of temporary interruptions (such as an incoming phone call or SMS message) or when the user quits the application and it begins the transition to the background state.
     Use this method to pause ongoing tasks, disable timers, and throttle down OpenGL ES frame rates. Games should use this method to pause the game.
     */
}

- (void)applicationDidEnterBackground:(UIApplication *)application
{
    /*
     Use this method to release shared resources, save user data, invalidate timers, and store enough application state information to restore your application to its current state in case it is terminated later. 
     If your application supports background execution, this method is called instead of applicationWillTerminate: when the user quits.
     */
}

- (void)applicationWillEnterForeground:(UIApplication *)application
{
    /*
     Called as part of the transition from the background to the inactive state; here you can undo many of the changes made on entering the background.
     */
}

- (void)applicationDidBecomeActive:(UIApplication *)application
{
    /*
     Restart any tasks that were paused (or not yet started) while the application was inactive. If the application was previously in the background, optionally refresh the user interface.
     */
}

- (void)applicationWillTerminate:(UIApplication *)application
{
    /*
     Called when the application is about to terminate.
     Save data if appropriate.
     See also applicationDidEnterBackground:.
     */
}

- (void)dealloc
{
    [_window release];
    [super dealloc];
}

-(void)tabBarController:(UITabBarController*)tabBarController didSelectViewController:(UIViewController*)viewController
{
}

@end
