//
//  CreditViewController.m
//  ArmorP3V1
//
//  Copyright (c) 2012年 __MyCompanyName__. All rights reserved.
//

#import "CreditViewController.h"
#import "TitleTableViewCell.h"
#import "TableControllerForMenu.h"
#import "PSMutex.h"

@implementation CreditViewController

@synthesize rootImage = _rootImage;

-(void)dealloc
{
    [_rootImage release];
    [super dealloc];
}

- (id)init
{
    self = [super initWithStyle:UITableViewStyleGrouped];
    if (self) {
        // Initialization code here.
        UIImage* image1 = [UIImage imageNamed: @"Dragon2.png"];
        UIImage* image2 = [self createAlphaImage: image1];
        if (image1 == nil || image2 == nil) {
            [[PSMutex mainMutex] raiseMemoryError];
        }else {
            _rootImage = image2;
            [_rootImage retain];
            
            [image1 release];
            [image2 release];
        }
    }else {
        [[PSMutex mainMutex] raiseMemoryError];
    }
    [[PSMutex mainMutex] showMemoryAlertIfError];
    
    return self;
}


- (UIImage *)createAlphaImage:(UIImage *)targetImage {
	
    // CGImageを取得する
    CGImageRef imageRef = targetImage.CGImage;
	
    // 画像情報を取得する
    size_t width = CGImageGetWidth(imageRef);
    size_t height = CGImageGetHeight(imageRef);
    size_t bitsPerComponent = CGImageGetBitsPerComponent(imageRef);
    size_t bitsPerPixel = CGImageGetBitsPerPixel(imageRef);
    size_t bytesPerRow = CGImageGetBytesPerRow(imageRef);
    
    // ピクセル単位にアクセスする。
    CGImageRef inputImageRef = [targetImage CGImage];
    CFDataRef inputDataRef = CGDataProviderCopyData(CGImageGetDataProvider(inputImageRef));
    unsigned char *pixelData = (unsigned char*) CFDataGetBytePtr(inputDataRef);
    int length = CFDataGetLength(inputDataRef);    
    
    for(int i = 0; i < length; i += 4) {
        unsigned char r = pixelData[i];
        unsigned char g = pixelData[i + 1];
        unsigned char b = pixelData[i + 2];
        unsigned char a = pixelData[i + 3];
        if (r == 255 && g == 255 && b == 255) {
            a = 0;
            pixelData[i + 3] = a;
        }
    }
    
    // ピクセルデータから画像構築。
    CGDataProviderRef dataProviderRef;
    dataProviderRef = CGDataProviderCreateWithData(NULL, pixelData, width*height*4, NULL);
    CGImageRef newImageRef = CGImageCreate(width, height, bitsPerComponent, bitsPerPixel, bytesPerRow, CGColorSpaceCreateDeviceRGB(), kCGImageAlphaLast, dataProviderRef, NULL, 0, kCGRenderingIntentDefault);
    
    //imageRefからimageを得る
    UIImage *newImage = [[UIImage alloc] initWithCGImage:newImageRef];
    
    return newImage;
}




// Customize the number of sections in the table view.
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    return 2;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return 1;
}

- (UITableViewCell *)cellForRowAtIndexPathImpl:(UITableView *)tableView: (NSIndexPath *)indexPath
{
    if (indexPath.section == 0) {
        UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"Image"];
        if (cell == nil) {
            cell = [[TitleTableViewCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:@"Image"];
        }
        cell.imageView.image = _rootImage;
        return cell;
    }else {
        UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"Menu0"];
        if (cell == nil) {
            cell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:@"Menu0"];
        }
        NSMutableString* message = [[NSMutableString alloc]init];
        
        [message appendString:@"ご意見ご要望をお聞かせ下さい"]; //改行可能
        
        cell.textLabel.lineBreakMode = UILineBreakModeCharacterWrap;
        cell.textLabel.numberOfLines = 0;
        cell.textLabel.text = message;
        
        [cell.textLabel sizeToFit];
        [cell sizeToFit];
        [message release];
        
        return cell;
    }
}

-(CGFloat)tableView:tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath {
    int height;
    if (indexPath.section == 0) {
        height = 300;
    }else {
        height = 50;
    }
    return height;
}

// Customize the appearance of table view cells.
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    return [self cellForRowAtIndexPathImpl:tableView:indexPath];
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    [self clickButton:indexPath];
}

- (IBAction)clickButton:(NSIndexPath*)indexPath {
    if (indexPath.section == 0) {
        NSMutableString* msg = [[NSMutableString alloc]init];
        NSString* title = @"MHP3狩人";
        [msg appendString: @"***はじめに***"];
        [msg appendString: @"\n"];
        [msg appendString: @"\n"];
        [msg appendString: @"シミュとしては携帯なので遅い部類にはいります。"];
        [msg appendString: @"\n"];
        [msg appendString: @"これの主な使い道は、シミュ結果のマイセットを持ち歩いたりする事です。"];
        [msg appendString: @"\n"];
        [msg appendString: @"そう、これは、PC版シミュのマイセット／お守りをクリップボード経由で取り込むことが可能です。"];
        [msg appendString: @"\n"];
        [msg appendString: @"もしかして、このアプリを気にいって頂けた場合、もしかして、"];
        [msg appendString: @"献血やボランティア活動などへ参加して頂けたら、とても嬉しいです。"];
        [msg appendString: @"\n"];
        [msg appendString: @"\n"];
        [msg appendString: @"***iPhone移植にあたって***"];
        [msg appendString: @"\n"];
        [msg appendString: @"\n"];
        [msg appendString: @"メモリの少ないハードなので、対策できないので、このさい、クラッシュする前提で、設定をこまめに保存します。"];
        [msg appendString: @"\n"];
        [msg appendString: @"速度的な負荷などをさけるため、結果は１００件ずつ表示していきます。"];
        [msg appendString: @"\n"];
        [msg appendString: @"追加スキルの探索は、出来ますが、速度と電池残量を考えると、PCで行う方がいいでしょう。"];
        [msg appendString: @"\n"];
        [msg appendString: @"お守り全探索機能も、出来ますが、今の所は、PCが数段高速でしょう。"];
        [msg appendString: @"\n"];
        [msg appendString: @"\n"];
        [msg appendString: @"iTunes共有で設定ファイルが見えますが、理由を以下に示します。"];
        [msg appendString: @"\n"];
        [msg appendString: @"AppStoreより、アプリをバージョンアップする際、通信環境などにより、ごくまれに失敗するようです。"];
        [msg appendString: @"\n"];
        [msg appendString: @"そこで、手動でのバックアップを可能にしました。"];
        [msg appendString: @"\n"];
        [msg appendString: @"また、ネットで流通している防具一覧CSVも有効活用出来そうです。"];
        UIAlertView* alert = [UIAlertView alloc];
        [alert initWithTitle:title message:msg delegate:nil cancelButtonTitle: nil otherButtonTitles: @"OK", nil]; 

        [msg release];
        [alert show];
        
        [alert release];
    }else {
        UIAlertView *alert = [[UIAlertView alloc]initWithTitle:@"サポート情報"
                                                       message:@"ツイッターに接続しますか？"
                                                      delegate:self 
                                             cancelButtonTitle: @"いいえ" 
                                             otherButtonTitles: @"はい", nil];
        [alert show];
    }
}


-(void)alertView:(UIAlertView *)alertView clickedButtonAtIndex:(NSInteger)buttonIndex {
    if (buttonIndex == 1) {
        [[UIApplication sharedApplication] openURL:[NSURL URLWithString:@"https://twitter.com/AtelierPyonta"]];        
    }
}

- (void)viewDidAppear:(BOOL)animated
{
    [super viewDidAppear:animated];
    [self cellValueChanged];
}

@end
