//
//  DecorationCache.h
//  ArmorP3V1
//

#import <Foundation/Foundation.h>
#import "SkillSet.h"
#import "PSArmorSet.h"
#import "MatrixBuilder.h"
#import "DecorationMatcher.h"
#import "IProgress.h"

@interface DecorationCache : NSObject

@property (nonatomic, assign) NSMutableArray** decoForSlot;
@property (nonatomic, assign) NSMutableArray** skillForSlot;
@property (nonatomic, assign) int* borderForSlot;
@property (nonatomic, assign) BOOL* bodyCopyAvail;
@property (nonatomic, assign) int totalNeeds;
@property (nonatomic, assign) int* needAboutParts;
@property (nonatomic, assign) int* needAboutCopie;

@property (nonatomic, retain) NSMutableArray* decoMaster;
@property (nonatomic, retain) SkillSet* targetSkill;
@property (nonatomic, retain) MatrixBuilder* matrixForSearch;
@property (nonatomic, retain) SkillSet* skillForSearch;
@property (nonatomic, retain) SkillSet* skillForSearchCalcA;
@property (nonatomic, retain) NSMutableArray* fetch;
@property (nonatomic, retain) PSArmorSet* matcherSet;

@property (nonatomic, retain) NSMutableArray* arrayColumnList;
@property (nonatomic, assign) int* rowIndex;
@property (nonatomic, assign) BOOL endOfMatrix;
@property (nonatomic, assign) long skipCount;
@property (nonatomic, assign) int weaponSlotCount;
@property (nonatomic, assign) int skippedCount;

-(id)initWithDecorationList:(PSSession*)session;
-(BOOL)decoIsForSkillKind:(PSItem*) item: (SkillSet*) skills;

-(void)cleanup;
-(void)addColumn:(NSArray*)column;
-(long)iteratorCount;
-(void)start;
-(int)getFailedColumn:(NSArray*)armors;
-(BOOL)fetchNext:(NSMutableArray*)result:(id<IProgress>)progress;
-(BOOL)fetchIntenal:(NSMutableArray*)result;
-(BOOL)skipToNext:(int)columnId;

@end
