//
//  DecorationSlot.h
//  ArmorP3V1
//

#import <Foundation/Foundation.h>
#import "DecorationCount.h"
#import "SkillSet.h"
#import "PSArmorSet.h"

@interface DecorationSlot : NSObject <NSCopying>

@property (nonatomic, readonly) int* slotCount;
@property (nonatomic, readonly) int* slotAvail;
@property (nonatomic, readonly) DecorationCount* mapDecoration;
@property (nonatomic, readonly) DecorationCount* mapBodyDecoration;
@property (nonatomic, readonly) SkillSet* diffSkills;
@property (nonatomic, assign) int hashCache;
@property (nonatomic, assign) BOOL hasAnotherSkill;
@property (nonatomic, assign) int countEmptySlot1;
@property (nonatomic, assign) int countEmptySlot2;
@property (nonatomic, assign) int countEmptySlot3;
@property (nonatomic, assign) int countEmptyBodySlot1;
@property (nonatomic, assign) int countEmptyBodySlot2;
@property (nonatomic, assign) int countEmptyBodySlot3;
@property (nonatomic, assign) int bodyCopieCount;
@property (nonatomic, assign) int weaponSlotCount;
@property (nonatomic, retain) SkillSet* anotherSkill;

+(int)compareDecorationSlot:(id)a :(id)b;
//+(int)compareDecorationSlot2:(id)a :(id)b;

-(void)updateAnotherSkill: (PSArmorSet*)armorSet;
-(id)initWith:(DecorationSlot*) source;
-(BOOL)canRemoveFromBody;
-(BOOL)canRemoveFromNotBody;
-(void)beginWithDecoration: (NSMutableArray*) decorations;
-(void)beginWithDecorationAndArmorSet:(NSMutableArray*)decorations:(PSArmorSet*)set;
-(void)construct: (SkillSet*) diffSkills : (PSArmorSet*) set : (int) weaponSlotCount;
-(NSInteger)totalAvailCount;
-(NSInteger)getBodyAvailable;
-(BOOL)haveCopie;
-(DecorationSlot*)applyToBody:(PSWrap*)deco;
-(DecorationSlot*)applyAuto:(PSWrap*)deco;
-(int)getSlotMaxCount;
-(int)getWeaponSlotAvailable;
-(int)getCharmSlotAvailable;
-(void)getFullDecorationsSkills:(SkillSet*)skills;
-(void)simpleToString:(NSMutableString*)str:(DecorationCount*)map;
-(void)toDecorationString:(NSMutableString*)str;
-(void)toString:(NSMutableString*)str;
-(void)toTextList:(NSMutableArray*)listTexts;

-(int)realLength;
-(int)realCountAt:(int)x;
-(BOOL)realBodyCopyAt:(int)x;
-(PSWrap*)realDecorationAt:(int)x;

@end
