//
//  DecorationSlot.m
//  ArmorP3V1
//
//  Copyright (c) 2012年 __MyCompanyName__. All rights reserved.
//

#import "Repository.h"
#import "DecorationSlot.h"
#import "PSItem.h"
#import "PSWrap.h"
#import "PSItemType.h"
#import "PSMutex.h"

@implementation DecorationSlot

@synthesize slotCount = _slotCount;
@synthesize slotAvail = _slotAvail;
@synthesize mapDecoration = _mapDecoration;
@synthesize mapBodyDecoration = _mapBodyDecoration;
@synthesize diffSkills = _diffSkills;
@synthesize hashCache = _hashCache;
@synthesize hasAnotherSkill = _hasAnotherSkill;
@synthesize countEmptySlot1 = _countEmptySlot1;
@synthesize countEmptySlot2 = _countEmptySlot2;
@synthesize countEmptySlot3 = _countEmptySlot3;
@synthesize countEmptyBodySlot1 = _countEmptyBodySlot1;
@synthesize countEmptyBodySlot2 = _countEmptyBodySlot2;
@synthesize countEmptyBodySlot3 = _countEmptyBodySlot3;
@synthesize anotherSkill = _anotherSkill;
@synthesize bodyCopieCount = _bodyCopieCount;
@synthesize weaponSlotCount = _weaponSlotCount;

-(id)init
{
    self = [super init];
    if (self) {
        _slotCount = calloc(sizeof(int), 7);
        _slotAvail = calloc(sizeof(int), 7);
        _mapDecoration = [[DecorationCount alloc]init];
        _mapBodyDecoration = [[DecorationCount alloc]init];
        _diffSkills = [[SkillSet alloc]init];
        _hashCache = -1;
        _hasAnotherSkill = FALSE;
        _anotherSkill = nil;
        _bodyCopieCount = 0;
        _weaponSlotCount = 0;
        if (_slotCount == nil || _slotAvail == nil || _mapDecoration == nil || _mapBodyDecoration == nil || _diffSkills == nil) {                    
            [[PSMutex mainMutex] raiseMemoryError];
            [self dealloc];
            return nil;
        }
    }else {
        [[PSMutex mainMutex] raiseMemoryError];
    }
    [[PSMutex mainMutex] showMemoryAlertIfError];
    return self;
}

-(NSUInteger)hash {
    if (_hashCache == -1) {
        _hashCache = _mapDecoration.hash + _mapBodyDecoration.hash;
    }
    return _hashCache;
}

-(id)initWith: (DecorationSlot*) source {
    self = [super init];
    if (self) {       
        _bodyCopieCount = source.bodyCopieCount;
        _slotCount = calloc(sizeof(int), 7);
        _slotAvail = calloc(sizeof(int), 7);
        _mapDecoration = [[DecorationCount alloc]initWith:source.mapDecoration];
        _mapBodyDecoration = [[DecorationCount alloc]initWith:source.mapBodyDecoration];
        _bodyCopieCount = source.bodyCopieCount;
        _weaponSlotCount = source.weaponSlotCount;
        _hashCache = -1;

        for(int i = 0; i < 7; ++ i) {
            _slotCount[i] = source.slotCount[i];
            _slotAvail[i] = source.slotAvail[i];
        }
        //[_armorSet release];
        //_armorSet = source.armorSet;
        //[_armorSet retain];
        _diffSkills = [[SkillSet alloc]init];
        [_diffSkills set_all:source.diffSkills];
        if (_slotCount == nil || _slotAvail == nil || _mapDecoration == nil || _mapBodyDecoration == nil || _diffSkills == nil) {                    
            [[PSMutex mainMutex] raiseMemoryError];
        }
    }else {
        [[PSMutex mainMutex] raiseMemoryError];
    }
    [[PSMutex mainMutex] showMemoryAlertIfError];
    return self;
}
/*
+(int)compareDecorationSlot2:(id)a :(id)b {
    DecorationSlot* that = a;
    DecorationSlot* target = b;
    
    int x = 0;
    
    if (x == 0) {
        for (int i = 0; i < that.diffSkills.count; ++i) {
            x = that.diffSkills.point[i] - target.diffSkills.point[i];
            if (x != 0) {
                break;
            }
        }
    }
    if (x == 0) {
        for (int i = 0; i < 7; ++i) {
            x = that.slotAvail[i] - target.slotAvail[i];
            if (x != 0) {
                break;
            }
        }
    }
    if (x < 0) {
        return -1;
    }
    if (x > 0) {
        return 1;
    }
    return 0;
}*/

-(BOOL)canRemoveFromNotBody {
    for(int x = 0; x < _mapDecoration.count; ++ x) {
        int count = _mapDecoration.listCount[x];
        if (count == 0) {
            continue;
        }
        PSWrap* wrap = [_mapDecoration.listDeco objectAtIndex:x];
        PSItem* deco = wrap.item;
        
        for(int i = 0; i < _diffSkills.count; ++ i) {
            SkillKind* kind = [_diffSkills.listKind objectAtIndex:i];
            BOOL positive = _diffSkills.positive[i];
            int point = _diffSkills.point[i];
            int over = 0;
            if (positive) {
                if (point > 0) {
                    over = point;
                }
            }else {
                if (point < 0) {
                    over = -point;
                }
            }
            if (over <= 0) {
                continue;
            }

            for (int j = 0; j < deco.skills.count; ++ j) {
                SkillKind *kind2 = [deco.skills.listKind objectAtIndex:j];
                int point2 = deco.skills.point[j];
                if (kind2 == kind) {
                    if (deco.skills.positive[j] == FALSE) {
                        point2 = -point2;
                    }
                    if (point2 <= over) {
                        return TRUE;
                    }
                }
            }
        }
    }
    return FALSE;
}

-(BOOL)canRemoveFromBody {
    if (_bodyCopieCount == 0) {
        return FALSE;
    }
    for(int x = 0; x < _mapBodyDecoration.count; ++ x) {
        int count = _mapBodyDecoration.listCount[x];
        if (count == 0) {
            continue;
        }
        PSWrap* deco = [_mapBodyDecoration.listDeco objectAtIndex:x];
        
        for(int i = 0; i < _diffSkills.count; ++ i) {
            SkillKind* kind = [_diffSkills.listKind objectAtIndex:i];
            BOOL positive = _diffSkills.positive[i];
            int point = _diffSkills.point[i];
            int over = 0;
            if (positive) {
                if (point < 0) {
                    over = -point;
                }
            }else {
                if (point > 0) {
                    over = point;
                }
            }
            if (over <= 0) {
                continue;
            }
            for (int j = 0; j < deco.item.skills.count; ++ j) {
                SkillKind *kind2 = [deco.item.skills.listKind objectAtIndex:j];
                if (kind2 == kind) {
                    int point2 = deco.item.skills.point[j];
                    point2 = point2 * _bodyCopieCount + point2;
                    if (point2 <= over) {
                        return TRUE;
                    }
                }
            }
        }
    }
    return FALSE;
}

-(id)copyWithZone:(NSZone *)zone {
    DecorationSlot* cache = [[DecorationSlot alloc]initWith:self];
    return cache;
}

+(int)compareDecorationSlot:(id)a :(id)b {
    DecorationSlot* that = a;
    DecorationSlot* target = b;

    if (that == target) {
        return 0;
    }
    int x = 0;
    
    if (x == 0) {
        x = [that totalAvailCount] - [target totalAvailCount];
    }
    if (x == 0) {
        x = [DecorationCount compareDecorationCount:that.mapDecoration to: target.mapDecoration];
    }
    if (x == 0) {
        x = [DecorationCount compareDecorationCount:that.mapBodyDecoration to: target.mapBodyDecoration];
    }
    if (x == 0) {
        x = that.bodyCopieCount - target.bodyCopieCount;
    }
    if (x == 0) {
        BOOL test[7];
        for (int i = 0; i < 7; ++ i) {
            test[i] = that.slotAvail[i];
        }
        if (that.bodyCopieCount == 0) {
            for (int i = 0; i < 7; ++ i) {
                BOOL found = FALSE;
                for (int j = 0; j < 7; ++ j) {
                    if (target.slotAvail[j] == test[i]) {
                        found = TRUE;
                        test[i] = 0;
                        break;
                    }
                }
                if (!found) {
                    return 1;
                }
            }
        }else {
            x = that.slotAvail[0] - target.slotAvail[0];
            if (x == 0) {
                for (int i = 1; i < 7; ++ i) {
                    BOOL found = FALSE;
                    for (int j = 1; j < 7; ++ j) {
                        if (target.slotAvail[j] == test[i]) {
                            found = TRUE;
                            test[i] = 0;
                            break;
                        }
                    }
                    if (!found) {
                        return 1;
                    }
                }
            }
        }
        x = 0;
    }
    if (x < 0) {
        return -1;
    }
    if (x > 0) {
        return 1;
    }
    return 0;
}

-(BOOL)isEqual:(id)object {
    if (self == object) {
        return TRUE;
    }
    if ([DecorationSlot compareDecorationSlot:self :object] == 0) {
        return TRUE;
    }
    return FALSE;
}

-(void)dealloc {
    free(_slotCount);
    _slotCount = nil;
    free(_slotAvail);
    _slotAvail= nil;
    [_mapDecoration release];
    [_mapBodyDecoration release];
    [_diffSkills release];
    [_anotherSkill release];
    [super dealloc];
}

-(void)beginWithDecoration: (NSMutableArray*) decorations {
    for (int i = 0; i < 7 ; ++ i) {
        _slotCount[i] = 0;
        _slotAvail[i] = 0;
    }
    [_diffSkills cleanup];
    [_mapDecoration resetWithColumn:decorations];
    [_mapBodyDecoration resetWithColumn:decorations];
}

-(void)beginWithDecorationAndArmorSet:(NSMutableArray *)decorations :(PSArmorSet *)set {
    for (int i = 0; i < 7 ; ++ i) {
        _slotCount[i] = 0;
        _slotAvail[i] = 0;
    }
    [_diffSkills cleanup];
    [_mapDecoration resetWithColumn:decorations];
    [_mapBodyDecoration resetWithColumn:decorations];
    _bodyCopieCount = set.bodyCopieCount;
    _weaponSlotCount = set.weaponSlotCount;
}

-(void)construct: (SkillSet*) diffSkills : (PSArmorSet*) set : (int) weaponSlotCount {
    [_mapDecoration clear];
    [_mapBodyDecoration clear];
    [_diffSkills cleanup];
    [_diffSkills set_all:diffSkills];
    _bodyCopieCount = set.bodyCopieCount;
    _weaponSlotCount = weaponSlotCount;

    int x = 1;
    for(int i = 0; i < set.listArmor.count; ++ i) {
        PSWrap* wrap = [set.listArmor objectAtIndex:i];
        PSItem* item = wrap.item;
        if (item.itemType == ITEM_TYPE_BODY) {
            _slotCount[0] = item.slotCount;
        }else {
            if (item.isCopieSkill) {
                _slotCount[x] = -1;
                x ++;
            }else {
                _slotCount[x] = item.slotCount;
                x ++;
            }
        }
        _slotCount[x] = weaponSlotCount;
        for (int i = 0; i < 7; ++ i) {
            _slotAvail[i] = _slotCount[i] < 0 ? 0 : _slotCount[i];
        }
    }
} 

-(NSInteger)totalAvailCount {
    int total = 0;
    for (int i = 0; i < 7; ++ i) {
        if (_slotCount[i] == -1) {
            total += _slotAvail[0];
        }else {
            total += _slotAvail[i];
        }
    }
    return total;
}

-(NSInteger)getBodyAvailable {
    if (_bodyCopieCount >= 1) {
        return _slotAvail[0];
    }
    return 0;
}

-(BOOL)haveCopie {
    return _bodyCopieCount > 0;
}

-(DecorationSlot*)applyToBody:(PSWrap*)deco {
    if (_bodyCopieCount >= 1 && _slotAvail[0] >= deco.item.slotCount) {
        DecorationSlot* cache = [[DecorationSlot alloc]initWith:self];
        cache.slotAvail[0] -= deco.item.slotCount;
        [cache.mapBodyDecoration increment:deco];
        for (int x = 0; x <= _bodyCopieCount; ++ x) {
            [cache.diffSkills minus_only:deco.maskedSkills];
        }
        return cache;
    }
    return nil;
}

-(DecorationSlot*)applyAuto:(PSWrap*)deco {
    /*
    for (int i = _armorSet.bodyCopieCount > 0 ? 1 : 0; i < 7; ++ i) {
        if (_slotAvail[i] == deco.item.slotCount) {
            DecorationSlot* cache = [[DecorationSlot alloc]initWith:self];
            [cache.diffSkills minus_only:deco.maskedSkills];
            cache.slotAvail[i] -= deco.item.slotCount;
            [cache.mapDecoration increment:deco];
            return cache;
        }
    }
     */
    for (int i = _bodyCopieCount > 0 ? 1 : 0; i < 7; ++ i) {
        if (_slotAvail[i] >= deco.item.slotCount) {
            DecorationSlot* cache = [[DecorationSlot alloc]initWith:self];
            [cache.diffSkills minus_only:deco.maskedSkills];
            cache.slotAvail[i] -= deco.item.slotCount;
            [cache.mapDecoration increment:deco];
            return cache;
        }
    }
    return nil;
}

-(int)getSlotMaxCount {
    int width = 0;
    for (int i = _bodyCopieCount > 0 ? 1 : 0; i < 7; ++ i) {
        if (width < _slotAvail[i]) {
            width = _slotAvail[i];
        }
    }
    if (_bodyCopieCount >= 0 && width < _slotAvail[0]) {
        width = _slotAvail[0]; 
    }
    return width;
}

-(int)getWeaponSlotAvailable {
    int weaponSlotCount = _weaponSlotCount;
    int width = 0;
    for (int i = _bodyCopieCount > 0 ? 1 : 0; i < 7; ++i) {
        if (_slotCount[i] >= weaponSlotCount) {
            if (width < _slotAvail[i]) {
                width = _slotAvail[i];
            }
        }
    }
    return width;
}

-(int)getCharmSlotAvailable {
    int charmSlotCount = _slotCount[5];
    int width = 0;
    for (int i = _bodyCopieCount > 0 ? 1 : 0; i < 7; ++i) {
        if (_slotCount[i] >= charmSlotCount) {
            if (width < _slotAvail[i]) {
                width = _slotAvail[i];
            }
        }
    }
    return width;
}

-(void)getFullDecorationsSkills: (SkillSet*) skills {
    [skills cleanup]; 
    for (int x = 0; x < _mapDecoration.count; ++ x) {
        PSWrap* deco = [_mapDecoration.listDeco objectAtIndex:x];
        int count = _mapDecoration.listCount[x];
        for(int i = 0; i < count; ++ i) {
            [skills sum_all: deco.item.skills];
        }
    }
    for (int x = 0; x < _mapBodyDecoration.count; ++ x) {
        PSWrap* deco = [_mapBodyDecoration.listDeco objectAtIndex:x];
        int count = _mapBodyDecoration.listCount[x];
        for (int i = 0; i < count; ++ i) {
            for (int j = 0; j <= _bodyCopieCount; ++ j) {
                [skills sum_all:deco.item.skills];
            }
        }
    }
}

-(void)simpleToString:(NSMutableString*)str:(DecorationCount*)map {
    BOOL first = TRUE;
    for (int i = 0; i < map.listDeco.count; i ++) {
        PSWrap* deco = [map.listDeco objectAtIndex:i];
        int count = map.listCount[i];
            
        if (count == 0) {
            continue;
        }
        
        if (!first) {
            [str appendString: @"、"];
        }
        [str appendFormat:@"%@x%d", deco.item.name, count];
        first = FALSE;
    }
}

-(void)toDecorationString:(NSMutableString*)str {
    NSMutableString *str2 = [[NSMutableString alloc]init];
    if (_countEmptySlot1) { [str2 appendFormat: @"空き【1】x%d、", _countEmptySlot1]; }
    if (_countEmptySlot2) { [str2 appendFormat: @"空き【2】x%d、", _countEmptySlot2]; }
    if (_countEmptySlot3) { [str2 appendFormat: @"空き【3】x%d、", _countEmptySlot3]; }

    if ([_mapBodyDecoration isEmpty] == FALSE || _countEmptyBodySlot1 || _countEmptyBodySlot2 || _countEmptyBodySlot3) {
        [str2 appendString:@"【胴:"];
        if (_countEmptyBodySlot1) { [str2 appendFormat: @"空き【1】x%d、", _countEmptyBodySlot1]; }
        if (_countEmptyBodySlot2) { [str2 appendFormat: @"空き【2】x%d、", _countEmptyBodySlot2]; }
        if (_countEmptyBodySlot3) { [str2 appendFormat: @"空き【3】x%d、", _countEmptyBodySlot3]; }
        if ([_mapBodyDecoration isEmpty]) {
            [str appendString:[str2 substringToIndex: str2.length - 1]];
            [str2 release];
            str2 = [[NSMutableString alloc]init];
        }
        [self simpleToString:str2:_mapBodyDecoration];
        [str2 appendString:@"】、"];
    }
    if ([_mapDecoration isEmpty] == FALSE) {
        [self simpleToString:str2:_mapDecoration];
        [str2 appendString:@"、"];
    }
    
    if (str2.length >= 1) {
        [str appendString:[str2 substringToIndex: str2.length - 1]];
    }
    
    [str2 release];
}

-(void)toString:(NSMutableString*)str {
    [str appendFormat: @"[%d avail, ", [self totalAvailCount]];
    for (int i = 0; i < 6; i ++ ) {
        [str appendFormat:@"%d-", _slotAvail[i]];
    }
    [_diffSkills skillToString:str :nil :TRUE];
    [str appendFormat: @"-"];
    [self toDecorationString:str];
    [str appendFormat: @"]"];
}

-(void)toTextList:(NSMutableArray*)listTexts {    
    if ([_mapBodyDecoration isEmpty] == FALSE) {
        for (int i = 0; i < _mapBodyDecoration.count; ++ i) {
            PSItem* item = [_mapBodyDecoration.listDeco objectAtIndex:i];
            int count = _mapBodyDecoration.listCount[i];
            if (count != 0) {
                NSMutableString* str = [[NSMutableString alloc]init];
                [str appendFormat:@"胴:%@×%d", item.name, count];
                [listTexts addObject: str];
                [str release];
            }
        }
    }
    if ([_mapDecoration isEmpty] == FALSE) {
        for (int i = 0; i < _mapDecoration.count; ++ i) {
            PSItem* item = [_mapDecoration.listDeco objectAtIndex:i];
            int count = _mapDecoration.listCount[i];
            if (count != 0) {
                NSMutableString* str = [[NSMutableString alloc]init];
                [str appendFormat:@"%@×%d", item.name, count];
                [listTexts addObject: str];
                [str release];
            }
        }
    }    
}

-(int)realLength {
    int total  = 0;
    
    if (_countEmptySlot1) { total ++; }
    
    if (_countEmptySlot2) { total ++; }
    
    if (_countEmptySlot3) { total ++; }
    
    if (_countEmptyBodySlot1) { total ++; }
    
    if (_countEmptyBodySlot2) { total ++; }

    if (_countEmptyBodySlot3) { total ++; }
    
    for (int i = 0; i < _mapBodyDecoration.count; ++ i) {
        int count = _mapBodyDecoration.listCount[i];
        if (count != 0) {
            total ++;
        }
    }
    
    for (int i = 0; i < _mapDecoration.count; ++ i) {
        int count = _mapDecoration.listCount[i];
        if (count != 0) {
            total ++;
        }
    }
    return total;
}

-(int)realCountAt:(int)x {
    int total  = 0;
    
    if (x == total && _countEmptySlot1 > 0) { return _countEmptySlot1; }
    if (_countEmptySlot1 > 0) { total ++; }
    if (x == total && _countEmptySlot2 > 0) { return _countEmptySlot2; }
    if (_countEmptySlot2 > 0) { total ++; }
    if (x == total && _countEmptySlot3 > 0) { return _countEmptySlot3; }
    if (_countEmptySlot3 > 0) { total ++; }
    if (x == total && _countEmptyBodySlot1 > 0) { return _countEmptyBodySlot1; }
    if (_countEmptyBodySlot1 > 0) { total ++; }
    if (x == total && _countEmptyBodySlot2 > 0) { return _countEmptyBodySlot2; }
    if (_countEmptyBodySlot2 > 0) { total ++; }
    if (x == total && _countEmptyBodySlot3 > 0) { return _countEmptyBodySlot3; }
    if (_countEmptyBodySlot3 > 0) { total ++; }
    
    for (int i = 0; i < _mapBodyDecoration.count; ++ i) {
        int count = _mapBodyDecoration.listCount[i];
        if (count != 0) {
            if (total == x) {
                return count;
            }
            total ++;
        }
    }
    
    for (int i = 0; i < _mapDecoration.count; ++ i) {
        int count = _mapDecoration.listCount[i];
        if (count != 0) {
            if (total == x) {
                return count;
            }
            total ++;
        }
    }
    return FALSE;
}

-(BOOL)realBodyCopyAt:(int)x {
    int total  = 0;
    
    if (x == total && _countEmptySlot1 > 0) { return FALSE; }
    if (_countEmptySlot1 > 0) { total ++; }
    if (x == total && _countEmptySlot2 > 0) { return FALSE; }
    if (_countEmptySlot2 > 0) { total ++; }
    if (x == total && _countEmptySlot3 > 0) { return FALSE; }
    if (_countEmptySlot3 > 0) { total ++; }
    if (x == total && _countEmptyBodySlot1 > 0) { return TRUE; }
    if (_countEmptyBodySlot1 > 0) { total ++; }
    if (x == total && _countEmptyBodySlot2 > 0) { return TRUE; }
    if (_countEmptyBodySlot2 > 0) { total ++; }
    if (x == total && _countEmptyBodySlot3 > 0) { return TRUE; }
    if (_countEmptyBodySlot3 > 0) { total ++; }
    
    for (int i = 0; i < _mapBodyDecoration.count; ++ i) {
        int count = _mapBodyDecoration.listCount[i];
        if (count != 0) {
            if (total == x) {
                return TRUE;
            }
            total ++;
        }
    }
    
    for (int i = 0; i < _mapDecoration.count; ++ i) {
        int count = _mapDecoration.listCount[i];
        if (count != 0) {
            if (total == x) {
                return FALSE;
            }
            total ++;
        }
    }
    return FALSE;
}

-(PSWrap*)realDecorationAt:(int)x {
    int total  = 0;
    if (x == total && _countEmptySlot1 > 0) { return [PSWrap getVirtualWrap: ITEM_TYPE_DECORATION :VIRTUAL_EMPTY1]; }
    if (_countEmptySlot1 > 0) { total ++; }
    if (x == total && _countEmptySlot2 > 0) { return [PSWrap getVirtualWrap: ITEM_TYPE_DECORATION :VIRTUAL_EMPTY2]; }
    if (_countEmptySlot2 > 0) { total ++; }
    if (x == total && _countEmptySlot3 > 0) { return [PSWrap getVirtualWrap: ITEM_TYPE_DECORATION :VIRTUAL_EMPTY3]; }
    if (_countEmptySlot3 > 0) { total ++; }
    if (x == total && _countEmptyBodySlot1 > 0) { return [PSWrap getVirtualWrap: ITEM_TYPE_DECORATION :VIRTUAL_EMPTY1]; }
    if (_countEmptyBodySlot1 > 0) { total ++; }
    if (x == total && _countEmptyBodySlot2 > 0) { return [PSWrap getVirtualWrap: ITEM_TYPE_DECORATION :VIRTUAL_EMPTY2]; }
    if (_countEmptyBodySlot2 > 0) { total ++; }
    if (x == total && _countEmptyBodySlot3 > 0) { return [PSWrap getVirtualWrap: ITEM_TYPE_DECORATION :VIRTUAL_EMPTY3]; }
    if (_countEmptyBodySlot3 > 0) { total ++; }

    for (int i = 0; i < _mapBodyDecoration.count; ++ i) {
        PSWrap* wrap = [_mapBodyDecoration.listDeco objectAtIndex:i];
        int count = _mapBodyDecoration.listCount[i];
        if (count != 0) {
            if (total == x) {
                return wrap;
            }
            total ++;
        }
    }
    
    for (int i = 0; i < _mapDecoration.count; ++ i) {
        PSWrap* wrap = [_mapDecoration.listDeco objectAtIndex:i];
        int count = _mapDecoration.listCount[i];
        if (count != 0) {
            if (total == x) {
                return wrap;
            }
            total ++;
        }
    }
    return nil;
}

-(void)updateAnotherSkill: (PSArmorSet*)armorSet {
    SkillSet* copySkill = [[SkillSet alloc]init];
    [armorSet calculateUseList:FALSE];
    [copySkill set_all:armorSet.setSkills];
    
    SkillSet* ordSkill = [[SkillSet alloc]init];
    [self getFullDecorationsSkills: ordSkill];
    [copySkill sum_all: ordSkill];
    [ordSkill release];
    
    [_anotherSkill release];
    _anotherSkill = [[SkillSet alloc]init];

    SkillSet* actNames = [[SkillSet alloc]init];
    [copySkill getNamedSkillSetForDisplay: actNames];
    
    if (actNames.count != armorSet.targetSkills.count) {
        _hasAnotherSkill = TRUE;
        
        for (int x2 = 0; x2 < actNames.count; ++ x2) {
            SkillKind* kind2 = [actNames.listKind objectAtIndex:x2];
            int point2 = actNames.point[x2];
            BOOL positive2 = actNames.positive[x2];
            BOOL found = FALSE;
            for (int i = 0; i < armorSet.targetSkills.count; ++ i) {
                SkillKind* kind = [armorSet.targetSkills.listKind objectAtIndex:i];
                int point1 = armorSet.targetSkills.point[i];
                BOOL positive = armorSet.targetSkills.positive[i];
                if (kind == kind2) {                   
                    if (positive) {
                        if (point1 >= point2) {
                            found = TRUE;
                            break; //ignore
                        }
                        if (point1 < point2) {
                            [_anotherSkill set:kind :point2 :TRUE];
                            found = TRUE;
                            break;
                        }
                    }else {
                        if (point1 <= point2) {
                            found = TRUE;
                            break; //ignore
                        }
                        if (point1 > point2) {
                            [_anotherSkill set:kind :point2 :FALSE];
                            found = TRUE;
                            break;
                        }
                    }
                }
            }
            if (!found) {
                [_anotherSkill set:kind2: point2: positive2];
            }
        }
    }else {
        _hasAnotherSkill = FALSE;
    }
    [actNames release];

    for (int i = 0; i < 7; ++ i) {
        if (_slotAvail[i] == 1) {
            if (i == 0 && _bodyCopieCount != 0) {
                _countEmptyBodySlot1 ++;
            }else {
                _countEmptySlot1 ++;
            }   
        }
        if (_slotAvail[i] == 2) {
            if (i == 0 && _bodyCopieCount != 0) {
                _countEmptyBodySlot2 ++;
            }else {
                _countEmptySlot2 ++;
            }   
        }
        if (_slotAvail[i] == 3) {
            if (i == 0 && _bodyCopieCount != 0) {
                _countEmptyBodySlot3 ++;
            }else {
                _countEmptySlot3 ++;
            }   
        }
    }
}

@end
