//
//  Engine.h
//  ArmorP3V1
//

#import <Foundation/Foundation.h>
#import "Repository.h"
#import "DecorationMatcher.h"
#import "PSBaseItems.h"
#import "PSSession.h"
#import "DecorationSlot.h"
#import "SkillKind.h"
#import "SkillSet.h"
#import "PSItemList.h"
#import "IProgress.h"
#import "PSProgressView.h"
#import "MatrixBuilder.h"
#import "DecorationCache.h"

@interface Engine : NSObject  {
    
}

@property (nonatomic, retain) PSSession* session;
@property (nonatomic, retain) SkillSet* targetSkill;

@property (nonatomic, retain) PSItemList* listForScanAll;
@property (nonatomic, retain) PSItemList* listForScanTop;
@property (nonatomic, retain) PSItemList* listForCheck;

@property (nonatomic, retain) NSMutableArray* listResultSearch;
@property (nonatomic, retain) NSMutableArray* listResultChecked;
@property (nonatomic)         BOOL useAnotherCheck;
@property (nonatomic, retain) Engine* superEngine;
@property (nonatomic, readonly) Repository* repository;

@property (nonatomic, readonly) NSMutableSet* tempFlagAlready;
@property (nonatomic, readonly) NSMutableArray* tempChildQueue;
@property (nonatomic, readonly) NSMutableArray* tempSlotResult;
@property (nonatomic) int countMax;
@property (atomic, assign) BOOL isOptimizedArmor;

-(void)loadResult:(Engine*)another;
-(id)initWithSession:(PSSession*)session;
-(void)prepareScan: (int)itemType:(NSMutableArray*)source:(NSMutableArray*)dest;
-(int)listToChild:(int)depth:(int)itemType:(NSMutableArray*) listTops;
-(void)loadExtraCharms:(NSMutableArray*)dictionary;
-(void)getVirtualCharmList:(NSMutableArray*)listCharms:(PSWrap*)none:(NSMutableArray*)result;
-(BOOL)pageActionScan:(id<IProgress>)progress;
-(void) filterByViewCount: (NSMutableArray*)armors: (NSMutableArray*)result;
-(BOOL)isCharmHaveReplaceMent:(DecorationCache*)matrix: (DecorationMatcher*) matcher: (PSArmorSet*)set;
-(BOOL)canonicariseResultSet:(DecorationCache*)matrix: (PSArmorSet*) armorSet: (DecorationMatcher*)matcher;

-(void)buildTreeForScan:(int)itemType:
(NSMutableArray*)source: (NSMutableArray*)listTops: (NSMutableArray*)listAll;
-(DecorationCache *)prepareDataItems: (id <IProgress>)progress: (PSBaseItems*) source: (PSItemList*)destTop : (PSItemList*)destAll;

+(BOOL)isTargetSameSkillsAndSlot:(PSWrap*) base: (PSWrap*) target;
+(BOOL)isTargetWeakChildren:(SkillSet* )guilde: (PSWrap*) base: (PSWrap*) grp;

@end

