//
//  LineReader.h
//  MHP3SkillSim
//

#import <Foundation/Foundation.h>
#import "SkillSet.h"

@interface LineReader : NSObject {
}

@property (nonatomic, assign) int currentRow;
@property (nonatomic, retain) NSMutableArray* lines;
@property (nonatomic, retain) NSMutableArray* columns;
@property (nonatomic, assign) NSString* currentLine;

- (id)init;
- (BOOL) readFile : (NSString*) fileName;
- (BOOL) readPasteBoard;
- (BOOL) readFromString : (NSString*) strContents;

- (BOOL) parseNextLine;
- (int) columnCount;
- (NSString*) columnAtIndex:(int)index;

+ (BOOL)splitPerLines: (NSString*)text : (NSMutableArray*)lines;
+ (BOOL)splitPerColumns: (NSString*)text : (NSMutableArray*)columns;
+ (BOOL)SkillSetToString:(SkillSet*)skills : (NSMutableString*)text;
+ (BOOL)StringToSkillSet:(NSString*)text : (SkillSet*)skills;
+ (void)renketu: (NSMutableString*) str: (NSArray*) array;

@end
