//
//  PSArmorSet.h
//  ArmorP3V1
//

#import <Foundation/Foundation.h>
#import "SkillSet.h"
#import "PSSession.h"
#import "IProgress.h"

@interface PSArmorSet : NSObject {
    
}

@property (nonatomic, assign) int totalSlotCount;

@property (nonatomic, assign) int shellFire;
@property (nonatomic, assign) int shellWater;
@property (nonatomic, assign) int shellIce;
@property (nonatomic, assign) int shellThunder;
@property (nonatomic, assign) int shellDragon;

@property (nonatomic, assign) int bodyCopieCount;
@property (nonatomic, retain) NSMutableArray* listArmor;
@property (nonatomic, retain) SkillSet* setSkills;

@property (nonatomic, assign) int defMax;
@property (nonatomic, assign) int defInitial;

@property (nonatomic, assign) int hunterRank;
@property (nonatomic, assign) int townRank;
@property (nonatomic, assign) int genderType;
@property (nonatomic, assign) int hunterType;
@property (nonatomic, assign) int weaponSlotCount;

@property (nonatomic, assign) int mysetNumber;
@property (nonatomic, retain) NSString* mysetName;
@property (nonatomic, retain) NSString* mysetPicturePath;
@property (nonatomic, retain) SkillSet* targetSkills;

//@property (nonatomic, retain) PSSession* session;

+(int)compareArmorSet:(id)a to:(id)b;

-(PSArmorSet*)createCopy;
-(void)calculateUseList:(SkillSet*)mask;
-(int)createChildSet:(NSMutableArray*)list checker:(NSMutableSet*) already;
-(void)drawArmorSets: (NSMutableArray*)result :(BOOL)useExtract:(SkillSet*)targetSkill:(id<IProgress>)progress:(int)searchMaxCount;
-(void)printArmorSetDetail: (NSMutableString*) strArmor: (NSMutableString*)strCharm: (NSMutableString*)strMaterials: (BOOL)skillseek;
-(void)compactDecorationSlotList: (NSMutableArray*) array;
-(void)getShellValueAsText: (NSMutableString*) str;

@end
