//
//  PSConfig.m
//  MHP3SkillSim
//

#import "PSConfig.h"
#import "PSMySet.h"
#import "SkillSet.h"
#import "SkillSet.h"
#import "PSItem.h"
#import "PSMutex.h"
#import "PropertyReader.h"

@implementation PSConfig

@synthesize session = _session;
@synthesize fileName = _fileName;
@synthesize themeNumber = _themeNumber;
@synthesize themeLabelColorful = _themeLabelColorful;
@synthesize fontName = _fontName;
@synthesize fontSize = _fontSize;
@synthesize fontStyle = _fontStyle;

-(id)init
{
    self = [super init];
    if (self) {
        _session = [[PSSession alloc]init];
        _fileName = @"PSConfig.ini";
        [_fileName retain];
    }else {
        [[PSMutex mainMutex] raiseMemoryError];
    }
    [[PSMutex mainMutex] showMemoryAlertIfError];
    return self;
}

-(void)dealloc {
    [_session release];
    [_fileName release];
    [super dealloc];
}

-(void)readProperties
{
    PropertyReader* reader = [[PropertyReader alloc]init];

    if ([reader readFile:_fileName]) {
        @try {
            @try {
                NSString* value = [reader.properites objectForKey: @"themeNumber"];
                if (value != nil) {
                    _themeNumber =  value.intValue;
                }else {
                    NSLog(@"no property %@", @"themeNumber");
                }
            }@catch (NSException *exception) {
                NSLog(@"exception %@ %@", exception, [exception callStackSymbols]);
            }
            @try {
                NSString* value = [reader.properites objectForKey: @"fontName"];
                if (value != nil) {
                    _fontName = value;
                    [_fontName retain];
                }else {
                    NSLog(@"no property %@", @"fontName");
                }
            }@catch (NSException *exception) {
                NSLog(@"exception %@ %@", exception, [exception callStackSymbols]);
            }
            @try {
                NSString* value = [reader.properites objectForKey: @"fontStyle"];
                if (value != nil) {
                    _fontStyle = value.intValue;
                }else {
                    NSLog(@"no property %@", @"fontStyle");
                }
            }@catch (NSException *exception) {
                NSLog(@"exception %@ %@", exception, [exception callStackSymbols]);
            }
            @try {
                NSString* value = [reader.properites objectForKey: @"fontSize"];
                if (value != nil) {
                    _fontSize = value.intValue;
                }else {
                    NSLog(@"no property %@", @"fontSize");
                }
            }@catch (NSException *exception) {
                NSLog(@"exception %@ %@", exception, [exception callStackSymbols]);
            }
            @try {
                NSString* value = [reader.properites objectForKey: @"searchHunterRank"];
                if (value != nil) {
                    _session.searchHunterRank = value.intValue;
                }else {
                    NSLog(@"no property %@", @"searchHunterRank");
                }
            }@catch (NSException *exception) {
                NSLog(@"exception %@ %@", exception, [exception callStackSymbols]);
            }
            @try {
                NSString* value = [reader.properites objectForKey: @"searchTownRank"];
                if (value != nil) {
                    _session.searchTownRank = value.intValue;
                }else {
                    NSLog(@"no property %@", @"searchTownRank");
                }
            }@catch (NSException *exception) {
                NSLog(@"exception %@ %@", exception, [exception callStackSymbols]);
            }
            @try {
                NSString* value = [reader.properites objectForKey: @"searchGenderType"];
                if (value != nil) {
                    _session.searchGenderType = value.intValue;
                }else {
                    NSLog(@"no property %@", @"searchGenderType");
                }
            }@catch (NSException *exception) {
                NSLog(@"exception %@ %@", exception, [exception callStackSymbols]);
            }
            @try {
                NSString* value = [reader.properites objectForKey: @"searchHunterType"];
                if (value != nil) {
                    _session.searchHunterType = value.intValue;
                }else {
                    NSLog(@"no property %@", @"searchHunterType");
                }
            }@catch (NSException *exception) {
                NSLog(@"exception %@ %@", exception, [exception callStackSymbols]);
            }
            @try {
                NSString* value = [reader.properites objectForKey: @"searchWeaponSlotCount"];
                if (value != nil) {
                    _session.searchWeaponSlotCount = value.intValue;
                }else {
                    NSLog(@"no property %@", @"searchWeaponSlotCount");
                }
            }@catch (NSException *exception) {
                NSLog(@"exception %@ %@", exception, [exception callStackSymbols]);
            }
            @try {
                NSString* value = [reader.properites objectForKey: @"searchMaxCount"];
                if (value != nil) {
                    _session.searchMaxCount = 9999;//value.intValue;
                }else {
                    NSLog(@"no property %@", @"searchMaxCount");
                }
            }@catch (NSException *exception) {
                NSLog(@"exception %@ %@", exception, [exception callStackSymbols]);
            }

            @try {
                NSString* value = [reader.properites objectForKey: @"searchSkills"];
                if (value != nil) {
                    SkillSet* skills = [[SkillSet alloc]init];
                    [LineReader StringToSkillSet:value :skills];
                    _session.searchSkills = skills;
                    [skills release];
                }else {
                    NSLog(@"no property %@", @"searchSkills");
                }
            }@catch (NSException *exception) {
                NSLog(@"exception %@ %@", exception, [exception callStackSymbols]);
            }
            @try {
                NSString* value = [reader.properites objectForKey: @"searchMatome"];
                if (value != nil) {
                    _session.searchMatome = [value isEqual:@"true"] ? TRUE : FALSE;
                    _session.searchMatome = TRUE;
                }else {
                    NSLog(@"no property %@", @"searchMatome");
                }
            }@catch (NSException *exception) {
                NSLog(@"exception %@ %@", exception, [exception callStackSymbols]);
            }
            @try {
                NSString* value = [reader.properites objectForKey: @"searchPlusAlpha"];
                if (value != nil) {
                    _session.searchPlusAlpha = [value isEqual:@"true"] ? TRUE : FALSE;
                }else {
                    NSLog(@"no property %@", @"searchPlusAlpha");
                }
            }@catch (NSException *exception) {
                NSLog(@"exception %@ %@", exception, [exception callStackSymbols]);
            }
            @try {
                NSString* value = [reader.properites objectForKey: @"searchFukugo"];
                if (value != nil) {
                    _session.searchFukugo = [value isEqual:@"true"] ? TRUE : FALSE;
                }else {
                    NSLog(@"no property %@", @"searchFukugo");
                }
            }@catch (NSException *exception) {
                NSLog(@"exception %@ %@", exception, [exception callStackSymbols]);
            }
            @try {
                //NSString* value = [reader.properites objectForKey: @"searchPlusAlpha"];
                //if (value != nil) {
                //    _session.searchPlusAlpha = value.intValue ? TRUE : FALSE;
                //}
            }@catch (NSException *exception) {
                NSLog(@"exception %@ %@", exception, [exception callStackSymbols]);
            }
            @try {
                NSString* value = [reader.properites objectForKey: @"searchCharmCSVTable"];
                if (value != nil) {
                    _session.searchCharmCSVTable = 0;
                    _session.searchCharmCSVTable = value.intValue;
                }else {
                    NSLog(@"no property %@", @"searchCharmCSVTable");
                }
            }@catch (NSException *exception) {
                NSLog(@"exception %@ %@", exception, [exception callStackSymbols]);
            }
            @try {
                //NSString* value = [reader.properites objectForKey: @"searchCharmMatome"];
                //if (value != nil) {
                //}
            }@catch (NSException *exception) {
                NSLog(@"exception %@ %@", exception, [exception callStackSymbols]);
            }
            @try {
                NSString* value = [reader.properites objectForKey: @"searchOrderByDeffence"];
                if (value != nil) {
                    _session.searchOrderByDeffence = value.intValue;
                }else {
                    NSLog(@"no property %@", @"searchOrderByDeffence");
                }
            }@catch (NSException *exception) {
                NSLog(@"exception %@ %@", exception, [exception callStackSymbols]);
            }
        
            NSMutableArray *str = [[NSMutableArray alloc]init];
            
            for (int i = ITEM_TYPE_HEAD; i <= ITEM_TYPE_LEG; ++i) { //TODO +1
                NSString* key = [[NSString alloc]initWithFormat:@"candidateUnchecked.%d", i];
                NSString* value = [reader.properites objectForKey: key];  
                if (value != nil) {
                    [str removeAllObjects];
                    [LineReader splitPerColumns:value :str];
                    
                    for (int i = 0; i < str.count; ++ i) {
                        NSString* name = [str objectAtIndex:i];
                        PSItem* item = [PSItem getInstanceByName:i :name];//TODO
                        item.isCheckedForSearch = FALSE;
                    }
                }
                key = [[NSString alloc]initWithFormat:@"viewUnchecked.%d", i];
                value = [reader.properites objectForKey: key];  
                if (value != nil) {
                    [str removeAllObjects];
                    [LineReader splitPerColumns:value :str];
                    
                    for (int i = 0; i < str.count; ++ i) {
                        NSString* name = [str objectAtIndex:i];
                        PSItem* item = [PSItem getInstanceByName:i :name];//TODO
                        item.isCheckedForView = FALSE;
                    }
                }
            }
        }
        @catch (NSException *exception) {
            NSLog(@"exception %@ %@", exception, [exception callStackSymbols]);
        }@finally {
            [reader release];
        }
    }
}

+(NSString*)textAsBool:(BOOL)n {
    if (n != 0) {
        return @"true";
    }else {
        return @"false";
    }
}

-(void)writeProperties
{
    NSFileManager *fileMgr = [NSFileManager defaultManager];
    NSError *error = nil;
    
    NSString *filePath = [NSString stringWithFormat:@"%@/Documents/%@" , NSHomeDirectory(), _fileName];
    NSString *filePathTmp = [NSString stringWithFormat:@"%@/Documents/%@_tmp", NSHomeDirectory(), _fileName];
    
    NSMutableString* str = [[NSMutableString alloc]init];
    
    NSMutableString* strSKill = [[NSMutableString alloc]init];
    [LineReader SkillSetToString:_session.searchSkills :strSKill];
    
    [str appendFormat:@"themeNumber=%d\n", _themeNumber];
    [str appendFormat:@"fontName=%@\n", _fontName];
    [str appendFormat:@"fontStyle=%d\n", _fontStyle];
    [str appendFormat:@"fontSize=%d\n", _fontSize];
    [str appendFormat:@"searchHunterRank=%d\n", _session.searchHunterRank];
    [str appendFormat:@"searchTownRank=%d\n", _session.searchTownRank ];
    [str appendFormat:@"searchGenderType=%d\n", _session.searchGenderType];
    [str appendFormat:@"searchHunterType=%d\n", _session.searchHunterType];
    [str appendFormat:@"searchWeaponSlotCount=%d\n", _session.searchWeaponSlotCount];
    [str appendFormat:@"searchSkills=%@\n", strSKill];
    [str appendFormat:@"searchMaxCount=%d\n", _session.searchMaxCount];
    [str appendFormat:@"searchMatome=%@\n", [PSConfig textAsBool:_session.searchMatome]];
    [str appendFormat:@"searchFukugo=%@\n", [PSConfig textAsBool:_session.searchFukugo]];
    [str appendFormat:@"searchPlusFast=%@\n", [PSConfig textAsBool:FALSE]];
    [str appendFormat:@"searchPlusAlpha=%@\n", [PSConfig textAsBool:_session.searchPlusAlpha]];
    [str appendFormat:@"searchCharmCSVTable=%d\n", _session.searchCharmCSVTable];
    [str appendFormat:@"searchCharmMatome=%@\n", [PSConfig textAsBool:TRUE]];
    [str appendFormat:@"searchOrderByDeffence=%@\n", [PSConfig textAsBool:_session.searchOrderByDeffence]];

    [strSKill release];


    /*
     NSMutableString* key = nil;
     NSMutableString* value = nil;

     for (int i = 0; i < 8; ++i) {
        [key release];
        key = [[NSMutableString alloc]initWithFormat:@"candidateUnchecked.%d", i];
        
        [value release];
        value = [[NSMutableString alloc]init];
        //TODO [_session.searchItems getCandidateUncheckedAsStrings: i: value];
        [str appendFormat:@"%@=%@\n", key, value];
    }
    for (int i = 0; i < 8; ++i) {
        [key release];
        key = [[NSMutableString alloc]initWithFormat:@"viewUnchecked.%d", i];
        
        [value release];
        value = [[NSMutableString alloc]init];
        //TODO [_session.searchItems getViewUncheckedAsStrings: i: value];
        [str appendFormat:@"%@=%@\n", key, value];
    }
    */

    [str writeToFile: filePathTmp atomically:YES encoding:NSShiftJISStringEncoding error:&error];
    if (error != nil) {
        NSLog(@"fileError1 = %@", error);
        [str release];
        return;
    }

    if ([fileMgr isReadableFileAtPath:filePath]) {
        [fileMgr removeItemAtPath:filePath error:&error];
        if (error != nil) {
            NSLog(@"fileError2 = %@", error);
        }
    }
    
    NSLog(@"renaming to %@", filePath);
    [fileMgr moveItemAtPath:filePathTmp toPath:filePath error:&error];
    if (error != nil) {
        NSLog(@"fileError3 = %@", error);
    }
}

@end
