//
//  PSItem.h
//  MHP3SkillSim
//

#import <Foundation/Foundation.h>
#import "PSItemType.h"
#import "SkillSet.h"
#import "PSItemMaterial.h"

@interface PSItem : NSObject <NSCopying> {
}

@property (nonatomic, readonly) int seq;
@property (nonatomic, assign) int itemType;
@property (nonatomic, retain) NSString* name;
@property (nonatomic, retain) SkillSet* skills;
@property (nonatomic, assign) int genderType;
@property (nonatomic, assign) int hunterType;
@property (nonatomic, assign) int rareRank;
@property (nonatomic, assign) int slotCount;
@property (nonatomic, assign) int existHunterRank;
@property (nonatomic, assign) int existTownRank;
@property (nonatomic, assign) int defInitial;
@property (nonatomic, assign) int defMax;
@property (nonatomic, assign) int shellFire;
@property (nonatomic, assign) int shellWater;
@property (nonatomic, assign) int shellIce;
@property (nonatomic, assign) int shellThunder;
@property (nonatomic, assign) int shellDragon;
@property (nonatomic, assign) BOOL isCopieSkill;
@property (nonatomic, retain) PSItemMaterial* materialA;
@property (nonatomic, retain) PSItemMaterial* materialB;
@property (nonatomic, assign) int viewCount;
@property (nonatomic, assign) BOOL viewFound;
@property (nonatomic, assign) BOOL isVirtual;
//@property (nonatomic, assign) BOOL isVirtualNone;
@property (nonatomic, readonly) PSItem* item;
@property (nonatomic, assign) BOOL isCheckedForSearch;
@property (nonatomic, assign) BOOL isCheckedForView;
@property (nonatomic, assign) int charmStone;
@property (nonatomic, assign) int charmTable;

+(int)comparePSItem:(id)a to:(id)b;
-(void)printContents:(NSMutableString*)string;
-(void)getArmorNameAndSlot:(NSMutableString*) str;
-(void)getArmorName:(NSMutableString*) str;

+(PSItem*)getVirtualItem:(int) itemType: (int) slotCount;
+(PSItem*)getInstanceByName:(int)itemType: (NSString*) name;
+(void)clearEveryViewCount;
+(void)clearEveryViewFound;

#define VIRTUAL_START  -1
#define VIRTUAL_END     6

#define VIRTUAL_COPIE -1
#define VIRTUAL_SLOT0  0
#define VIRTUAL_SLOT1  1
#define VIRTUAL_SLOT2  2
#define VIRTUAL_SLOT3  3
#define VIRTUAL_EMPTY1 4
#define VIRTUAL_EMPTY2 5
#define VIRTUAL_EMPTY3 6

@end
