//
//  PSTableModel.m
//  ArmorP3V1
//

#import "PSTableElement.h"
#import "PSTableModel.h"
#import "PSMutex.h"

@implementation PSTableModel
@synthesize selectable = _selectable;

-(id)init {
    self = [super init];
    
    if (self) {
        _listSection = [[NSMutableArray alloc]init];
        _selectable = PS_SELECTABLE_NONE;
    }else {
        [[PSMutex mainMutex] raiseMemoryError];
    }
    [[PSMutex mainMutex] showMemoryAlertIfError];
    
    return self;
}

-(void)dealloc
{
    [self validate];
    [_listSection release];
    [super dealloc];
}

-(int)count {
    return _listSection.count;
}

-(id)getSectionAtIndex:(NSInteger)index {
    return [_listSection objectAtIndex: index];
}

-(PSTableSection*)getSection:(NSString *)sectionName :(BOOL)createWhenEmpty
{
    [self validate];
    PSTableSection* sect = nil;
    if (sectionName == nil) {
        for (int i = 0; i < _listSection.count; ++ i) {
            PSTableSection *seek = [_listSection objectAtIndex:i];
            if (seek.title == nil) {
                sect = seek;
                break;
            }
        }
        if (sect == nil && createWhenEmpty) {
            sect = [[PSTableSection alloc]init];
            sect.title = sectionName;
            [_listSection addObject: sect];
            [sect release];
        }
    }else {
        for (int i = 0; i < _listSection.count; ++ i) {
            PSTableSection *seek = [_listSection objectAtIndex:i];
            if ([seek.title isEqual:sectionName]) {
                sect = seek;
                break;
            }
        }
        if (sect == nil && createWhenEmpty) {
            sect = [[PSTableSection alloc]init];
            sect.title = sectionName;
            [_listSection addObject: sect];
            [sect release];
        }
    }
    [self validate];
    return sect;
}

-(void)removeSection:(NSString*)sectionName
{
    PSTableSection* sect = [self getSection:sectionName:FALSE];
    if (sect) {
        [_listSection removeObject: sect];
    }
}

-(id)elementOfValue:(NSInteger)section: (NSObject*)value
{
    [self validate];
    PSTableSection* sect = [_listSection objectAtIndex:section];
    for (int i = 0; i < sect.listElements.count; ++ i) {
        PSTableElement* elem = [sect.listElements objectAtIndex:i];
        if ([value isEqual:elem.value]) {
            return elem;
        }
    }
    return nil;
}

-(id)elementOfInteger:(NSInteger)section: (NSInteger)value
{
    [self validate];
    PSTableSection* sect = [_listSection objectAtIndex:section];
    for (int i = 0; i < sect.listElements.count; ++ i) {
        PSTableElement* elem = [sect.listElements objectAtIndex: i];
        if (value == elem.valueOfInteger) {
            return elem;
        }
    }
    return nil;
}

-(void)ListupSelectedElment:(NSMutableArray*)listElement
{
    [self validate];
    for (int i = 0; i < _listSection.count; ++ i) {
        PSTableSection* sect = [_listSection objectAtIndex: i];
        for (int j = 0; j < sect.listElements.count; ++ j) {
            PSTableElement* elem = [sect.listElements objectAtIndex:j];
            if (elem.selected) {
                [listElement addObject:elem];
            }
        }
    }
}

-(id)selectedElement
{
    [self validate];
    for (int i = 0; i < _listSection.count; ++ i) {
        PSTableSection* sect = [_listSection objectAtIndex: i];
        for (int j = 0; j < sect.listElements.count; ++ j) {
            PSTableElement* elem = [sect.listElements objectAtIndex:j];
            if (elem.selected) {
                return elem;
            }
        }
    }
    return nil;
}

-(void)selectOneElement:(PSTableElement*)elem:(BOOL)selected
{
    [self validate];
    for (int i = 0; i < _listSection.count; ++ i) {
        PSTableSection* sect = [_listSection objectAtIndex: i];
        for (int j = 0; j < sect.listElements.count; ++ j) {
            PSTableElement* elem2 = [sect.listElements objectAtIndex:j];
            if (elem == elem2) {
                elem2.selected = TRUE;
            }else {
                elem2.selected = FALSE;
            }
        }
    }
}

-(id)easyAddObject:(NSString*)section:(NSString*)text:(NSObject*)value
{
    [self validate];
    PSTableSection* sect = [self getSection: section :TRUE];
    PSTableElement* elem = [[PSTableElement alloc]init];
    elem.text = text;
    elem.value = value;
    [sect.listElements addObject:elem];
    [elem release];
    return elem;
}

-(id)easyAddInteger:(NSString*)section:(NSString*)text:(NSInteger)valueOfInteger
{
    [self validate];
    PSTableSection* sect = [self getSection:section :TRUE];
    PSTableElement* elem = [[PSTableElement alloc]init];
    elem.text = text;
    elem.valueOfInteger = valueOfInteger;
    [sect.listElements addObject:elem];
    [elem release];
    return elem;
}

-(PSTableElement*)easyFindByObject:(NSObject*)value
{
    [self validate];
    for (int i = 0; i < _listSection.count; ++ i) {
        PSTableSection* sect = [_listSection objectAtIndex: i];
        for (int j = 0; j < sect.listElements.count; ++ j) {
            PSTableElement* elem = [sect.listElements objectAtIndex:j];
            if ([elem.value isEqual:value]) {
                return elem;
            }
        }
    }
    return nil;
}

-(PSTableElement*)easyFindByInteger:(NSInteger)valueOfInteger
{
    [self validate];
    for (int i = 0; i < _listSection.count; ++ i) {
        PSTableSection* sect = [_listSection objectAtIndex: i];
        for (int j = 0; j < sect.listElements.count; ++ j) {
            PSTableElement* elem = [sect.listElements objectAtIndex:j];
            if (elem.valueOfInteger == valueOfInteger) {
                return elem;
            }
        }
    }
    return nil;
}

-(PSTableElement*)easyElementByIndex:(NSInteger)section:(NSInteger)row
{
    [self validate];
    PSTableSection* sect = [_listSection objectAtIndex:section];
    PSTableElement* elem = [sect.listElements objectAtIndex:row];
    return elem;
}

-(void)validate {
    /*
    NSLog(@"sect.length = %d", self.count);
    for (int i = 0; i < self.count; ++ i) {
        PSTableSection* sect = [self getSectionAtIndex: i];
        NSLog(@"sect = %d", sect);
        NSLog(@"sect retainCount = %d", sect.retainCount);
        NSLog(@"sect class = %@", [sect class]);

        if (sect.class != [PSTableSection class]) {
            NSLog(@"fatal type error");
            abort();
        }
    }
     */
}

-(void)mergeSectionsFromTable:(PSTableModel*) model2 {
    for (int i = 0; i < model2.count; ++ i) {
        PSTableSection* sect = [model2 getSectionAtIndex: i];
        [_listSection addObject: sect];
    }
}

@end
