//
//  PSTableSection.m
//  ArmorP3V1
//

#import "PSTableModel.h"
#import "PSTableSection.h"
#import "PSMutex.h"
#import "PSTableElement.h"

@implementation PSTableSection

@synthesize title = _title;
@synthesize selectable = _selectable;
@synthesize listElements = _listElements;

- (id)init {
    id result = [super init];
    if (result) {
        _listElements = [[NSMutableArray alloc]init];
    }else {
        [[PSMutex mainMutex] raiseMemoryError];
    }
    [[PSMutex mainMutex] showMemoryAlertIfError];
    return self;
}

- (void)dealloc {
    [_title release];
    [_listElements release];
    [super dealloc];
}

-(void)listupSelection:(NSMutableArray*)listCell
{
    for (int j = 0; j < _listElements.count; ++ j) {
        PSTableElement* elem = [_listElements objectAtIndex:j];
        if (elem.selected) {
            [listCell addObject:elem];
        }
    }
}

-(id)easyAddObject:(NSString*)text:(NSObject*)value
{
    PSTableElement* elem = [[PSTableElement alloc]init];
    elem.text = text;
    elem.value = value;
    [_listElements addObject:elem];
    [elem release];
    return elem;
}

-(id)easyAddInteger:(NSString*)text:(NSInteger)valueOfInteger
{
    PSTableElement* elem = [[PSTableElement alloc]init];
    elem.text = text;
    elem.valueOfInteger = valueOfInteger;
    [_listElements addObject:elem];
    [elem release];
    return elem;
}

-(id)addElement:(id)elem {
    NSObject* obj = elem;
    if (obj.class == [PSTableElement class]) {
        [_listElements addObject: elem];
    }else {
        NSException *exception = [[NSException alloc]initWithName:@"memoryerror" reason:@"nil" userInfo:nil];
        [exception raise];
    }
    return elem;
}

@end
