//
//  PSWrap.m
//  ArmorP3V1
//

#import "PSWrap.h"
#import "SkillSet.h"
#import "PSItem.h"
#import "PSMutex.h"

@implementation PSWrap

@synthesize item = _item;
@synthesize sameArmors = _sameArmors;
@synthesize childArmors = _childArmors;
@synthesize charmGroup = _charmGroup;
@synthesize charmGroupSeek = _charmGroupSeek;
@synthesize maskedSkills = _maskedSkills;
@synthesize maskedSkillsSummary = _maskedSkillsSummary;

-(id)copyWithZone:(NSZone *)zone {
    [self retain];
    return self;
}

-(id)initWithItem:(PSItem*)item :(SkillSet*)columns {
    self = [super init];
    if (self) {
        _item = item;
        [item retain];
        _maskedSkills = [[SkillSet alloc]initWithColumn:columns];
        _sameArmors = [[NSMutableArray alloc]init];
        _childArmors = [[NSMutableArray alloc]init];
        _charmGroup = nil;
        _charmGroupSeek = nil;
    }else {
        [[PSMutex mainMutex] raiseMemoryError];
    }
    [[PSMutex mainMutex] showMemoryAlertIfError];
    return self;
}

-(void)dealloc
{
    [_item release];
    [_maskedSkills release];
    [_sameArmors release];
    [_childArmors release];
    [_charmGroup release];
    [_charmGroupSeek release];
    [super dealloc];
}

+(int)comparePSWrap:(id)a to:(id)b {
    if (a == b) {
        return 0;
    }
    if (a == nil) {
        return -1;
    }
    if (b == nil) {
        return 1;
    }
    PSWrap* that = a;
    PSWrap* target = b;
    
    return [PSItem comparePSItem:that.item to:target.item];
}

-(NSUInteger)hash {
    return _item.name.hash;
}

-(BOOL)isEqual:(id)object { 
    int x = [PSWrap comparePSWrap:self to:object];
    if (x == 0) return TRUE;
    return FALSE;
}

- (NSString*) description
{
    return _item.description;
}

-(void)getAdditionalInfo:(NSMutableString*)str {
    if (_item.itemType == ITEM_TYPE_CHARM && _charmGroup != nil) {
        [str appendFormat:@"同等/上位お守り{%d pattern\n", _charmGroup.count];
        for (int i = 0; i < _charmGroup.count; ++ i) {
            PSWrap *charm = [_charmGroup objectAtIndex:i];
            [str appendString: @"  "];
            [charm.item getArmorName: str];
            [str appendString: @"\n"];
        }
        [str appendString:@"}\n"];
        return;
    }
    if (_item.isVirtual) {
        [str appendString:@"同等防具{\n"];
        for (int i = 0; i < _sameArmors.count; ++ i) {
            PSWrap *wrap = [_sameArmors objectAtIndex:i];
            [str appendString: @"  "];
            [wrap.item getArmorName: str];
            [str appendString:@"\n"];
        }
        [str appendString:@"}\n"];
        return;
    }
    return;
}

-(void)getString:(NSMutableString*)str {
    [str appendFormat: @"%@[%d]", _item.name, _item.slotCount];
    [_maskedSkills skillToString:str :nil :TRUE];
}

static NSMutableDictionary* mapVirtual = nil;

+(PSWrap *)getVirtualWrap:(int)itemType: (int)slotCount {
    if (mapVirtual == nil) {
        mapVirtual = [[NSMutableDictionary alloc]init];
    }
    PSItem* item = [PSItem getVirtualItem:itemType :slotCount];
    PSWrap* wrap = [mapVirtual objectForKey:item];
    if (wrap == nil) {
        wrap = [[PSWrap alloc]initWithItem:item :nil];
        [mapVirtual setObject:wrap forKey:item];
        [wrap release];
    }
    return wrap;
}

-(id)keyEnumerator {
    NSException *exception = [[NSException alloc]initWithName:@"memoryerror" reason:@"nil" userInfo:nil];
    [exception raise];
    return nil;
}

-(void)resetCharmGroup {
    [_charmGroup release];
    [_charmGroupSeek release];
    
    _charmGroup = [[NSMutableArray alloc]init];
    _charmGroupSeek = [[NSMutableArray alloc]init];
}

@end
