//
//  SkillKindRepository.h
//  MHP3SkillSim
//

#import <Foundation/Foundation.h>
#import "SkillKind.h"
#import "SkillPoint.h"
#import "SkillCategory.h"

@interface SkillDB : NSObject {
}

@property (nonatomic, readonly) NSMutableArray *listCategory;
@property (nonatomic, readonly) NSMutableArray *listCategoryKindOrder;
@property (nonatomic, readonly) SkillCategory  *noCategory;
@property (nonatomic, readonly) NSMutableArray *listKindMaster;

-(void)sort;

-(int)countOfCategory;
-(int)indexOfCategory: (NSString*)categoryName;
-(id)categoryOfIndex: (int)index;

-(int)countOfKind;
-(int)indexOfKind: (NSString*)kindName;
-(id)kindOfIndex: (int)index;

-(SkillKind*)findSkillKindByName:(NSString*) name;

-(void)addSkillName:(NSString*) skillName : (NSString*) kindName : (int) point : (BOOL) positive;
-(void)setCategory : (NSString*)categoryName : (NSString*)skillName;

-(SkillPoint*) getNearSkillPoint:(SkillPoint*) point;
-(SkillPoint*) getMatchSkillPoint:(SkillPoint*) point;

-(SkillPoint*)pointNameToPoint:(NSString*)pointName;

@end
