//
//  SkillKind.m
//  MHP3SkillSim
//

#import "SkillKind.h"
#import "Repository.h"
#import "SkillDB.h"
#import "PSMutex.h"

@implementation SkillKind

@synthesize name = _name;

-(id)init {
    self = [super init];
    if (self) {
        _name = nil;
    }else {
        [[PSMutex mainMutex] raiseMemoryError];
    }
    return self;
}

-(void)dealloc {
    [_name release];
    [super dealloc];
}

-(NSUInteger)hash {
    return _name.hash;
}

-(BOOL)isEqual:(id)object {
    if (self == object) {
        return TRUE;
    }
    return [_name isEqual:object];
}

-(id)copyWithZone:(NSZone *)zone {
    [self retain];
    return self;
}

+(int)compareSkillKind:(id)a to:(id)b {
    if (a == b) return 0;
    SkillKind* k1 = a;
    SkillKind* k2 = b;
    
    return [k1.name compare: k2.name];
}

+(SkillKind*)findKindByName:(NSString*)text {
    Repository* repo = [Repository mainRepository];
    SkillDB* skillDB = repo.skillDB;
    if (text.length > 0) {
        NSString *replace = nil;

        if ([text hasPrefix:@"--"]) {
            return nil;
        }
        if ([text isEqual: @"剥ぎとり"]) {
            replace = @"剥ぎ取り";
            [replace retain];
        }
        if ([text hasSuffix:@"ビン追加"]) {
            NSString* temp = [text substringToIndex: text.length - 4];
            replace = [[NSString alloc]initWithFormat:@"%@瓶追加", temp];
        }
        if ([text isEqual: @"接激瓶追加"] || [replace isEqual: @"接激瓶追加"]) {
            [replace release];
            replace = [[NSString alloc]initWithString: @"接撃瓶追加"];
        }        
        if (replace != nil) {
            SkillKind* kind1 = [skillDB findSkillKindByName:replace];
            [replace release];
            return kind1;
        }else {
            SkillKind* kind1 = [skillDB findSkillKindByName:text];
            return kind1;
        }
    }
    return nil;
}


@end
