//
//  SkillSet.h
//  MHP3SkillSim
//

#import <Foundation/Foundation.h>
#import "SkillKind.h"
#import "SkillPoint.h"

@interface SkillSet : NSObject <NSCopying> {
}

//@property (readonly) NSString* posAlloc;
@property (readonly) NSMutableArray* listKind;
@property (readonly) int count;
@property (readonly) int capacity;
@property (readonly) int* point;
@property (readonly) BOOL *positive;

+(int)compareSkillSet:(id)a to:(id)b;

-(void)removeAllObjects;
-(id)init;
-(id)initWithCapacity:(int)x;
-(id)initWithColumn: (SkillSet*)filter;
-(void)cleanup;
-(void)ensureCapacity:(int)x;
-(void)set: (SkillKind*) kind: (NSInteger) point: (BOOL) range;
-(BOOL) isFixedBy: (SkillSet*)filter;
-(int) findByKind: (SkillKind*) kind;
-(SkillSet*) fixColumnBy: (SkillSet*) filter;
-(void) minus_fixed: (SkillSet*) slotSkill;
-(void) minus_only: (SkillSet*) slotSkill;
-(void) sum_only:(SkillSet*)slotSkill;
-(void) sum_all: (SkillSet*) sum;
-(void) sum_fixed: (SkillSet*) slotSkill;
-(void) set_all: (SkillSet*) slotSkill;
-(void) set_only: (SkillSet*) slotSkill;
-(BOOL)isOver: (SkillSet*)slotSkill;
-(void)skillToString: (NSMutableString*) str : (SEL) sorter: (BOOL) ignoreZero;
-(int)indexOfKind:(SkillKind*)kind;
-(NSMutableArray*) getNamedSkillNameForDisplay;
-(NSMutableArray*) getNamedSkillNameForSearch;
-(void) getNamedSkillSetForDisplay:(SkillSet*)dest;
-(SkillSet*) canonical;
-(int)totalDiffPoint;
-(int) maxDiffPoint;
-(BOOL) isZero;
-(void)sortByPower;
-(void)sortByOrdinary;
-(SkillPoint*) getAsSkillPoint: (int)index;
-(void)removeAtIndex: (int)index;
-(SkillSet*)skillSetOfChange:(SkillSet*)originalSkills;

@end
