//
//  TableControllerForMySet.m
//  ArmorP3V1
//

#import "TableControllerForMySet.h"
#import "TableControllerForArmorSet.h"
#import "TableControllerForMySetSub.h"

@implementation TableControllerForMySet

-(id)init {
    [self initWithStyle: UITableViewStyleGrouped];
    if (self) {
    }
    return self;
}

-(void)dealloc {
    [super dealloc];
}

-(void)viewDidAppear:(BOOL)animated {
    [super viewDidAppear: animated];
    [self createDatas];
}

-(void)callBackLoad1:(PSTableModel *)model {
    PSTableSection* sect = [model getSection: @"マイセット" : TRUE];
    Repository *repo = [Repository mainRepository];
    PSMySet* myset = repo.myset;

    for (int hr = 99; hr >= 0; hr --) {
        for (int hunterType = 0; hunterType <= 2; ++ hunterType) {
            for (int genderType = 1; genderType <= 2; ++ genderType) {
                NSMutableArray* listHit = [[NSMutableArray alloc]init];
                
                for (int i = 0; i < myset.listArmorSet.count; ++ i) {
                    PSArmorSet* armor = [myset.listArmorSet objectAtIndex:i];
                    if (armor.hunterType == hunterType && armor.hunterRank == hr && armor.genderType == genderType) {
                        [listHit addObject:armor];
                    }
                }
                
                if (listHit.count == 0) {
                    [listHit release];
                    continue;
                }
                
                NSMutableString* title = [[NSMutableString alloc]init];
                [title appendFormat:@"HR %d", hr];
                if (hunterType == HUNTER_TYPE_SWORD) {
                    [title appendString: @":剣士"];
                }else if (hunterType == HUNTER_TYPE_GUN) {
                    [title appendString: @":ガンナー"];
                }else {
                    [title appendString: @":剣士+ガンナー"];
                }
                if (genderType == GENDER_TYPE_MAN) {
                    [title appendString: @":男"];
                }else if (genderType == GENDER_TYPE_WOMAN) {
                    [title appendString: @":女"];
                }else {
                    [title appendString: @":男+女"];
                }
                
                PSTableModel* nextModel = [[PSTableModel alloc]init];
                
                PSTableElement* elem = [[PSTableElement alloc]init];
                elem.text = title;
                elem.nextModel = nextModel;
                
                [sect.listElements addObject: elem];
                [elem release];
                
                PSTableSection* nextSection = [[PSTableSection alloc]init];
                nextSection = [nextModel getSection:nil: TRUE];
                
                [nextModel release];
                
                for (int i = 0; i < listHit.count; ++ i) {
                    PSTableElement* nextElement = [[PSTableElement alloc]init];
                    nextElement.value = [listHit objectAtIndex:i];
                    [nextSection.listElements addObject: nextElement];
                    nextElement.flgNextView = TRUE;
                }
                elem.valueOfBadge = listHit.count;
                elem.cellStyle = PS_CELL_BADGE;
                
                [title release];
                [listHit release];
            }
        }
    }
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    PSTableModel* model = self.model;
    PSTableSection* sect = [model getSectionAtIndex:indexPath.section];
    PSTableElement* elem = [sect.listElements objectAtIndex:indexPath.row];
    
    [elem.nextModel validate];
    TableControllerForMySetSub* view = [[TableControllerForMySetSub alloc]initWithTableModel:elem.nextModel];

    UIBarButtonItem *backBarButtonItem = 
    [[UIBarButtonItem alloc] initWithTitle:@"マイセット"
                                     style:UIBarButtonItemStyleBordered
                                    target:nil 
                                    action:nil];
    [self.navigationItem setBackBarButtonItem:backBarButtonItem];
    
    [self.navigationController pushViewController:view animated:YES];
    [view release];  
}

@end
