//
//  TableControllerForMySet.m
//  ArmorP3V1
//

#import "TableControllerForMySetSub.h"
#import "TableControllerForArmorSet.h"
#import "Repository.h"

@implementation TableControllerForMySetSub

@synthesize modelSource = _modelSource;

-(id)initWithTableModel:(PSTableModel*)model {
    [self initWithStyle: UITableViewStyleGrouped];
    if (self) {
        _modelSource = model;
        [_modelSource retain];
        [model validate];
    }
    return self;
}

-(void)dealloc {
    [_modelSource release];
    [super dealloc];
}

-(void)callBackLoad1:(PSTableModel *)model {
    for (int i = 0; i < _modelSource.count; ++ i) {
        PSTableSection* sect = [_modelSource getSectionAtIndex: i];
        PSTableSection* newSect = [model getSection:sect.title : TRUE];
        
        for (int j = 0; j < sect.listElements.count; ++ j) {
            PSTableElement* elem = [sect.listElements objectAtIndex:j];
            PSTableElement* newElem = [[PSTableElement alloc]init];
            
            newElem.value = elem.value;
            newElem.text = 0;
            [newSect.listElements addObject:newElem];
            [newElem release];
        }
    }
}

-(void)fillTextForElement:(NSIndexPath *)index :(PSTableElement *)element {
    PSArmorSet* set = element.value;
    NSMutableString* text = [[NSMutableString alloc]init];
    
    int deffence = 0;
    int deffenceMin = 0;
    int shell = 0;
    
    for(int i = 0; i < set.listArmor.count; ++ i) {
        PSWrap *wrap = [set.listArmor objectAtIndex:i];
        deffence += wrap.item.defMax;
        deffenceMin += wrap.item.defInitial;
    }
    [text appendFormat:@"%d. 防御力[%d→%d]／武器スロ[%d]", index.row + 1, deffenceMin, deffence, set.weaponSlotCount
     ];
    [text appendString:@"\n"];
    
    for(int i = 0; i < set.listArmor.count; ++ i) {
        PSWrap *wrap = [set.listArmor objectAtIndex:i];
        /*if (wrap.item.isVirtualNone) {
            [text appendFormat:@"%@:%@", [PSItemType itemTypeText:i], wrap.item.name];
        }else*/ {
            [text appendFormat:@"%@:%@[%d]", [PSItemType itemTypeText:i], wrap.item.name, wrap.item.slotCount];
            if (i == ITEM_TYPE_CHARM) {
                [text appendString:@" "];
                [wrap.item.skills skillToString:text :nil :TRUE];
            }
        }
        [text appendString:@"\n"];
    }
    [text appendString:@"耐性値:"];
    [text appendFormat:@"火[%d]", set.shellFire];    shell += set.shellFire;
    [text appendFormat:@"水[%d]", set.shellWater];   shell += set.shellWater;
    [text appendFormat:@"氷[%d]", set.shellIce];     shell += set.shellIce;
    [text appendString:@"\n　　　 "];
    [text appendFormat:@"雷[%d]", set.shellThunder]; shell += set.shellThunder;
    [text appendFormat:@"龍[%d]", set.shellDragon];  shell += set.shellDragon;
    [text appendFormat:@"計[%d] ", shell];
    [text appendString:@"\n"];
    [text appendString:@"--------------------\n"];
    
    NSMutableArray* skills = [set.targetSkills getNamedSkillNameForSearch];
    for (int i = 0; i < skills.count; ++ i) {
        NSString* str = [skills objectAtIndex:i];
        [text appendFormat: @"%@\n", str];
    }
    
    element.text = text;
    [text release];
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    PSTableModel* model = self.model;
    PSTableSection* sect = [model getSectionAtIndex: indexPath.section];
    PSTableElement* elem = [sect.listElements objectAtIndex: indexPath.row];

    PSArmorSet* set = elem.value;
    
    [set calculateUseList:FALSE];
    
    TableControllerForArmorSet* view = [[TableControllerForArmorSet alloc]initWithArmorSet:set];
    view.fromMyset = TRUE;
    
    UIBarButtonItem *backBarButtonItem = 
    [[UIBarButtonItem alloc] initWithTitle:@"一覧"
                                     style:UIBarButtonItemStyleBordered
                                    target:nil 
                                    action:nil];
    [self.navigationItem setBackBarButtonItem:backBarButtonItem];
    [backBarButtonItem release];        
    
    [self.navigationController pushViewController:view animated:YES];
    [view release];  
}

-(CGFloat)tableView:tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath {
    CGFloat height = [super tableView:tableView heightForRowAtIndexPath:indexPath];
    return height + 50;
}

@end
