//
//  TableControllerForSetting.m
//  MHP3SkillSim
//

#import "TableControllerForSetting.h"
#import "Repository.h"
#import "NamedUISwitch.h"
#import "PSTableModel.h"
#import "TableControllerForTarget.h"
#import "TableControllerForSettingSub.h"
#import "Repository.h"
#import "PSItem.h"
#import "PSMutex.h"

#define CONFIG_MIN  0
#define CONFIG_GENDER_TYPE 0
#define CONFIG_HUNTER_RANK 1
#define CONFIG_TOWN_RANK   2
#define CONFIG_HUNTER_TYPE 3
#define CONFIG_ITEM_TARGET 4
#define CONFIG_CHARM_CSV   5
#define CONFIG_FUKUGO      6
#define CONFIG_MAX  6

@implementation TableControllerForSetting

-(id)init
{
    self = [self initWithStyle:UITableViewStyleGrouped];
    return self;
}

-(id)initWithStyle:(UITableViewStyle)style {
    self = [super initWithStyle:style];
    if (self) {
        self.navigationItem.title = @"オプション";
    }else {
        [[PSMutex mainMutex] raiseMemoryError];
    }
    [[PSMutex mainMutex] showMemoryAlertIfError];
    return self;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
     PSTableModel* model = self.model;
     PSTableSection* sect = [model getSectionAtIndex: indexPath.section];
     PSTableElement* elem = [sect.listElements objectAtIndex: indexPath.row];
    if (elem.flgNextView == FLG_NEXT_ITEM) {
        TableControllerForSettingSub* nextView = [TableControllerForSettingSub alloc];
        [nextView initWithData:elem];
        UIBarButtonItem *backBarButtonItem = 
        [[UIBarButtonItem alloc] initWithTitle:@"戻る"
                                         style:UIBarButtonItemStyleBordered
                                        target:nil 
                                        action:nil];
        [self.navigationItem setBackBarButtonItem:backBarButtonItem];
        [backBarButtonItem release];        
        [self.navigationController pushViewController:nextView animated:YES];
        [nextView release];
        return;
    }
    else if (elem.flgNextView == FLG_NEXT_VIEW) {
        if ([elem.strNextView isEqual: @"TableControllerForTarget"]) {
            TableControllerForTarget* nextView = [TableControllerForTarget alloc];
            [nextView init];
            UIBarButtonItem *backBarButtonItem = 
            [[UIBarButtonItem alloc] initWithTitle:@"戻る"
                                             style:UIBarButtonItemStyleBordered
                                            target:nil 
                                            action:nil];
            [self.navigationItem setBackBarButtonItem:backBarButtonItem];
            [backBarButtonItem release];        
            [self.navigationController pushViewController:nextView animated:YES];
            [nextView release];
            return;
        }else {
            NSException *exception = [[NSException alloc]initWithName:@"memoryerror" reason:@"nil" userInfo:nil];
            [exception raise];
        }
    }
}

-(void)updateScreen {
    if (self.model != nil) {
        Repository* repo = [Repository mainRepository];

        PSTableModel* model = self.model;
        PSTableSection* sect = [model getSectionAtIndex:0];
        PSTableElement* elem;
        
        PSTableModel* nextModel;
        PSTableElement* selectedElement;
        
        elem = [sect.listElements objectAtIndex:CONFIG_GENDER_TYPE];
        nextModel = elem.nextModel;
        selectedElement = nextModel.selectedElement;
        elem.valueOfSummary = selectedElement.text;
        elem.valueOfInteger = selectedElement.valueOfInteger;
        
        elem = [sect.listElements objectAtIndex:CONFIG_HUNTER_RANK];
        nextModel = elem.nextModel;
        selectedElement = nextModel.selectedElement;
        elem.valueOfSummary = selectedElement.text;
        elem.valueOfInteger = selectedElement.valueOfInteger;

        elem = [sect.listElements objectAtIndex:CONFIG_TOWN_RANK];
        nextModel = elem.nextModel;
        selectedElement = nextModel.selectedElement;
        elem.valueOfSummary = selectedElement.text;
        elem.valueOfInteger = selectedElement.valueOfInteger;

        elem = [sect.listElements objectAtIndex:CONFIG_HUNTER_TYPE];
        nextModel = elem.nextModel;
        selectedElement = nextModel.selectedElement;
        elem.valueOfSummary = selectedElement.text;
        elem.valueOfInteger = selectedElement.valueOfInteger;
    }
}

-(void)catchupValues
{
    if (self.model != nil) {
        [self updateScreen];
        
        Repository* repo = [Repository mainRepository];
        PSConfig* config = repo.config;
        PSTableModel* model = self.model;
        PSTableSection* sect = [model getSectionAtIndex: 0];
        PSTableElement* elem;

        elem = [sect.listElements objectAtIndex:CONFIG_GENDER_TYPE];
        config.session.searchGenderType = elem.valueOfInteger;

        elem = [sect.listElements objectAtIndex:CONFIG_HUNTER_RANK];
        config.session.searchHunterRank = elem.valueOfInteger;

        elem = [sect.listElements objectAtIndex:CONFIG_TOWN_RANK];
        config.session.searchTownRank = elem.valueOfInteger;
        
        elem = [sect.listElements objectAtIndex:CONFIG_HUNTER_TYPE];
        config.session.searchHunterType = elem.valueOfInteger;

        elem = [sect.listElements objectAtIndex:CONFIG_CHARM_CSV];
        config.session.searchCharmCSVTable = (elem.valueOfInteger != 0) ? 1 : 0;
        
        elem = [sect.listElements objectAtIndex:CONFIG_FUKUGO];
        config.session.searchFukugo = (elem.valueOfInteger != 0) ? TRUE : FALSE;
        NSLog(@"fukugo = %d", elem.valueOfInteger);
    }
}

-(void)callBackLoad1:(PSTableModel *)model {
    PSTableSection* sect = nil;
    PSTableModel* nextModel = nil;
    
    if (model.count > 0) {
        sect = [model getSectionAtIndex: 0];
    }else {
        sect = [model getSection:@"キャラクター" : TRUE];
    }
    
    Repository* repo = [Repository mainRepository];
    PSConfig* config = repo.config;
    
    for(int i = CONFIG_MIN; i <= CONFIG_MAX; ++ i) {
        PSTableElement *elem = [[PSTableElement alloc]init];
        PSTableElement *elemsel;
        
        elem.accessoryType = UITableViewCellAccessoryNone;
        switch (i) {
            case CONFIG_GENDER_TYPE:
                elem.text = @"キャラ";
                elem.cellStyle = PS_CELL_SUMMARY;
                elem.accessoryType = UITableViewCellAccessoryDisclosureIndicator;
                elem.flgNextView = FLG_NEXT_ITEM;
                
                nextModel = [[PSTableModel alloc]init];
                [nextModel easyAddInteger:nil: @"男" : GENDER_TYPE_MAN];
                [nextModel easyAddInteger:nil: @"女" : GENDER_TYPE_WOMAN];
                elemsel = [nextModel easyFindByInteger: config.session.searchGenderType];
                elemsel.selected = TRUE;
                
                elem.valueOfSummary = elemsel.text;
                elem.nextModel = nextModel;
                [nextModel release];
                
                break;
            case CONFIG_HUNTER_RANK:
                elem.text = @"集会浴場";
                elem.cellStyle = PS_CELL_SUMMARY;
                elem.accessoryType = UITableViewCellAccessoryDisclosureIndicator;
                elem.flgNextView = FLG_NEXT_ITEM;
                    
                nextModel = [[PSTableModel alloc]init];
                [nextModel easyAddInteger: nil: @"HR6" :6];
                [nextModel easyAddInteger: nil: @"HR5" :5];
                [nextModel easyAddInteger: nil: @"HR4" :4];
                [nextModel easyAddInteger: nil: @"HR3" :3];
                [nextModel easyAddInteger: nil: @"HR2" :2];
                [nextModel easyAddInteger: nil: @"HR1" :1];
                elemsel = [nextModel easyFindByInteger: config.session.searchHunterRank];
                elemsel.selected = TRUE;
                
                elem.valueOfSummary = elemsel.text;
                elem.nextModel = nextModel;
                [nextModel release];
                
                break;
            case CONFIG_TOWN_RANK:
                elem.text = @"村クエ";
                elem.cellStyle = PS_CELL_SUMMARY;                
                elem.flgNextView = FLG_NEXT_ITEM;
                
                nextModel = [[PSTableModel alloc]init];
                [nextModel easyAddInteger:nil: @"☆5" :5];
                [nextModel easyAddInteger:nil: @"☆4" :4];
                [nextModel easyAddInteger:nil: @"☆3" :3];
                [nextModel easyAddInteger:nil: @"☆2" :2];
                [nextModel easyAddInteger:nil: @"☆1" :1];
                elemsel = [nextModel easyFindByInteger: config.session.searchTownRank];
                elemsel.selected = TRUE;
                
                elem.valueOfSummary = elemsel.text;
                elem.accessoryType = UITableViewCellAccessoryDisclosureIndicator;
                elem.nextModel = nextModel;
                [nextModel release];
                break;
            case CONFIG_HUNTER_TYPE:
                elem.text = @"武器";
                elem.cellStyle = PS_CELL_SUMMARY;
                elem.flgNextView = FLG_NEXT_ITEM;
                
                nextModel = [[PSTableModel alloc]init];
                [nextModel easyAddInteger:nil: @"剣士" : HUNTER_TYPE_SWORD];
                [nextModel easyAddInteger:nil: @"ガンナー" : HUNTER_TYPE_GUN];
                
                elemsel = [nextModel easyFindByInteger: config.session.searchHunterType];
                elemsel.selected = TRUE;
                
                elem.valueOfSummary = elemsel.text;
                elem.accessoryType = UITableViewCellAccessoryDisclosureIndicator;
                elem.nextModel = nextModel;
                [nextModel release];
                break;
            case CONFIG_ITEM_TARGET: {
                int countTotal = 0;
                int countSelected = 0;
                PSBaseItems* data = repo.items;
                for(int i = 0; i < 5; ++i) {
                    NSMutableArray* sect = [data arrayByType:i];
                    for(int j = 0; j < sect.count; ++j) {
                        PSItem* item = [sect objectAtIndex:j];
                        if ([PSSession isExistForThisHunber:config.session :item]) {
                            countTotal ++;
                            if (item.isCheckedForSearch) {
                                countSelected ++;
                            }
                        }
                    }
                }
                elem.text = @"対象防具";
                elem.cellStyle = PS_CELL_SUMMARY;
                NSString* str = [[NSString alloc]initWithFormat:@"%d/%d", countSelected, countTotal];;
                elem.valueOfSummary = str;
                elem.accessoryType = UITableViewCellAccessoryDisclosureIndicator;
                elem.flgNextView = FLG_NEXT_VIEW;
                elem.strNextView = @"TableControllerForTarget";
                [str release];
                break;

            }
            case CONFIG_CHARM_CSV: {
                elem.text = @"全お守り";
                elem.cellStyle = PS_CELL_SWITCH;
                elem.accessoryType = UITableViewCellAccessoryNone;
                elem.valueOfInteger = repo.config.session.searchCharmCSVTable;
                break;
            }
            case CONFIG_FUKUGO: {
                elem.text = @"複合スキル";
                elem.cellStyle = PS_CELL_SWITCH;
                elem.accessoryType = UITableViewCellAccessoryNone;
                elem.valueOfInteger = repo.config.session.searchFukugo;
                break;
            }
            default:{
                NSException *exception = [[NSException alloc]initWithName:@"memoryerror" reason:@"nil" userInfo:nil];
                [exception raise];
            }
        }
            
        [sect.listElements addObject:elem];
        [elem release];
    }        
}

-(void)viewDidAppear:(BOOL)animated {
    [self catchupValues];
    [self createDatas];
}

@end
