# $Id: Makefile.inc,v 1.4 2006/10/28 09:04:13 securedog Exp $

MAKEOBJDIR?=	${.CURDIR}
PREFIX?=	/usr/local
BINDIR?=	${PREFIX}/bin
MANDIR?=	${PREFIX}/man/man
SHAREDIR?=	${PREFIX}/share
ETCDIR?=	${PREFIX}/etc
PORTSDIR?=	/usr/ports
PKGSRCDIR?=	/usr/pkgsrc
PKG_DBDIR?=	/var/db/pkg
MAKE?=		make

.if !defined(BINOWN)
ID?=		id
BINOWN!=	${ID} -un
BINGRP!=	${ID} -gn
SHAREOWN=	${BINOWN}
SHAREGRP=	${BINGRP}
.endif

.if !defined(OPSYS)
UNAME?=		uname
OPSYS!=		${UNAME} -s
.endif

RELROOT?=	../
ABSROOT=	${.CURDIR}/${RELROOT:S,/$,,}

DEFINED_TYPES=	WITH_PKGSRC WITH_OPENBSD WITH_CONFIG WITH_DEBUG
REINPLACE_ARGS=	-e 's|/usr/local|${PREFIX}|g' \
		-e 's|/usr/ports|${PORTSDIR}|g' \
		-e 's|/usr/pkgsrc|${PKGSRCDIR}|g' \
		-e 's|/var/db/pkg|${PKG_DBDIR}|g' \
		-e 's|"make"|"${MAKE}"|g'

.if !defined(WITH_FREEBSD) && !defined(WITH_PKGSRC) && !defined(WITH_OPENBSD)
.if exists(${PORTSDIR})
.if ${OPSYS} == "FreeBSD"
WITH_FREEBSD?=	YES
.elif ${OPSYS} == "OpenBSD"
WITH_OPENBSD?=	YES
.endif
.elif ${OPSYS} == "NetBSD" || exists(${PKGSRCDIR})
WITH_PKGSRC?=	YES
.endif
.endif

WITH_CONFIG?=	YES
.if defined(WITH_LITE)
.undef WITH_CONFIG
.undef WITH_DEBUG
.endif

.include "mk/prog.hack.mk"
