#!/usr/local/bin/perl

# --------------------------------------------------------
# PositLog
#
# The position logger for web contents.
#
# positlog.cgi 
#     main cgi script for PositLog
#  (tested under perl 5.8.4)
#
# Copyright (c) 2006 Hidekazu Kubota (Taro Sosui) All right reserved
#  <taro@summer.nifty.jp>
#   http://storybook.jp/
#
# --------------------------------------------------------

# --------------------------------------------------------
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
# --------------------------------------------------------


use strict;
# Default library (upper perl 5.8)
use CGI qw/-debug :standard/;
use CGI::Cookie;
use Storable qw(lock_retrieve lock_nstore);
# Additional modules
use PositLogConfig;


# Set default world position (pixel) 
my $worldTop = 0;
my $worldLeft = 0;

# parameters are already URL decoded.
my $CGI = new CGI;

# view position
my $arg_vp = $CGI->param("vp");
# sprite id
my $arg_id = $CGI->param("id");
# edge of contents
my $arg_edge = $CGI->param("edge");

my $pageid = $CGI->param("load");

if($pageid eq "")
{
    my $homepageid = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "homepage.cgi")} or {};
    if($homepageid ne "")
    {
	$pageid = $$homepageid;
    }
}

# load serialized configuration data
my $configHash = eval{Storable::lock_retrieve($PositLogConfig::datapath . $pageid . "/config.dat")};
if($@)
{
    print $CGI->header(-charset => 'utf-8');
    print "<html><head><title>PositLog: Page not found</title></head><body style='background-color: #c0c0c0;'><h1 style='background-color: #305030; color: #ffffff; padding: 5px; font-size: 18px;'>Page not found</h1></body></html>";
    exit(0);
}


my $positlogMode = $CGI->param("mode");
# Check available mode
if($positlogMode ne "ViewMode"
   && $positlogMode ne "EditMode"
   && $positlogMode ne "Login"
   && $positlogMode ne "Logout"
    )
{
    # default mode
    $positlogMode = "ViewMode";
}

#-------------------------------------------------------------
# Authentication
#-------------------------------------------------------------
my $loginerror = "";
my $validUser = 0; # 0: invalid user, 1: valid user or admin user
my $adminUser = 0; # 0: not admin, 1: admin user

my $loginid = $CGI->param("loginid");
my $loginpass = $CGI->param("loginpass");

my $permissionHash;

my $adminnameAuth = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "key.cgi")};
if($@){ warn $@; print $CGI->header(-charset => 'utf-8'); print "Cannot read the authentication file for admin.<br>\n"; exit(0);}
my $useridAuth = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "authentication.cgi")};
if($@){ warn $@; print $CGI->header(-charset => 'utf-8'); print "Cannot read the authentication file for users.<br>\n"; exit(0);}

sub showLoginScreen()
{
    my ($clearid, $mode) = @_;

    if($clearid eq "clearid")
    {
	$loginid = "";
    }

    my $HEADER = "<!DOCTYPE html PUBLIC '-//W3C//DTD HTML 4.01 Transitional//EN'\n
   'http://www.w3.org/TR/html4/loose.dtd'>\n
<html lang='ja-JP'>\n
	<head>\n
		<meta http-equiv='Content-Type' content='text/html;charset=UTF-8'>\n
		<meta http-equiv='Content-Style-Type' content='text/css'>\n
		<link rel='stylesheet' href='" . $PositLogConfig::systempath . "logincheck.css' type='text/css'>\n
		<title>PositLog Administration : Login</title>\n
	</head>\n";

    my $BODY = "<body onLoad=\"(document.getElementById('loginid')).focus()\">\n
  <div id='logintop'>\n
  <div id='login'>\n
  <h1>Login to <a href='./positlog.cgi?load=" . $pageid . "'>" . $configHash->{"page_title"} . "</a></h1>\n
  <form id='loginform' action='positlog.cgi?load=" . $pageid . "&mode=" . $mode . "' method='post'>\n
    <p>\n
      user name<br>\n
      <input type='text' name='loginid' id='loginid' value='" . $loginid . "' size='20' tabindex='1'>\n
    </p>\n
    <p>\n
      password<br>\n
      <input type='password' name='loginpass' id='loginpass' value='' size='20' tabindex='2'>\n
    </p>\n
    <p id='submitarea'>\n" . $loginerror . 
    "&nbsp;&nbsp;<input type='submit' id='submitbtn' value='Login' tabindex='3'><br>\n
    </p>\n
    <input type='hidden' name='mode' id='mode' value='" . $mode . "'>\n
    <input type='hidden' name='load' id='load' value='" . $pageid . "'>\n
  </form>\n
  </div>\n
  <div id='copyright'>\n
  Powered by <a href='http://storybook.jp/'>PositLog</a>\n
  </div>\n
  </div>\n
</body>\n";

    my $FOOTER = "</html>";

    print $HEADER . $BODY . $FOOTER;
}


if($loginid eq "")
{
# Read temporal cookie
    $loginid = $CGI->cookie("loginid") || "";
    $loginpass = $CGI->cookie("loginpass") || "";
    if($loginid eq "" || $loginid eq "public")
    {
	$loginid = "public";
	$loginpass = "";
    }
}
elsif($loginid eq "public")
{
    $loginpass = "";
}

if($positlogMode eq "Logout")
{
    $positlogMode = "ViewMode";
    #-------------------
    # Logout and Show View Screen
    #-------------------
    $loginid = "public";
    $loginpass = "";
}

if($loginid eq "public" || $positlogMode eq "EditMode")
{
    $permissionHash = eval{Storable::lock_retrieve($PositLogConfig::datapath . $pageid . "/permission.cgi")} or {};
    if($permissionHash eq "")
    {
	print $CGI->header(-charset => 'utf-8');
	print "Cannot read the page permission.<br>\n";
	exit(0);
    }
}


if($positlogMode eq "EditMode" && $loginid eq "public")
{

    if(scalar($permissionHash->{"write_plainsprite"}{"public"}) == 1
       ||scalar($permissionHash->{"write_attachedsprite"}{"public"}) == 1
       || scalar($permissionHash->{"write_supersprite"}{"public"}) == 1)
    {
	$positlogMode = "EditMode";
    }
    else
    {
	$positlogMode = "Login";
    }
}


if($positlogMode eq "Login")
{
    if($loginid eq "public")
    {
	$loginid = "";
    }
    print $CGI->header(-charset => 'utf-8');
    &showLoginScreen("", "EditMode");
    exit(0);
}
elsif($positlogMode eq "EditMode" || $positlogMode eq "ViewMode")
{
    if($loginid eq "public")
    {
	# public user
	$loginpass = "";

	my $cookieUser = new CGI::Cookie(
	    -path => "$PositLogConfig::cgipath",
	    -name => "loginid",
	    -value => "$loginid",
	    );
	my $cookiePass = new CGI::Cookie(
	    -path => "$PositLogConfig::cgipath",
	    -name => "loginpass",
	    -value => "$loginpass",
	    );

	print $CGI->header(-charset => 'utf-8', -cookie => [$cookieUser,$cookiePass]);
    }
    else
    {
	# login user

	if($adminnameAuth ne "" && $adminnameAuth->{$loginid})
	{
	    my $cryptpass = $adminnameAuth->{$loginid}{"password"};
	    my $salt="lc";
	    my $cryptpass2 = crypt($loginpass, $salt);
	    if($cryptpass eq $cryptpass2)
	    {
		$validUser = 1;
		$adminUser = 1;
	    }
	    else
	    {
		$loginerror = "<span style='color:red; font-size:12px;'>Invalid user id or password!</span>";
		$validUser = 0;
		$adminUser = 0;
	    }
	}
	elsif($useridAuth ne "" && $useridAuth->{$loginid})
	{
	    my $cryptpass = $useridAuth->{$loginid}{"password"};
	    my $salt="ry";
	    my $cryptpass2 = crypt($loginpass, $salt);
	    if($cryptpass eq $cryptpass2)
	    {
		$validUser = 1;
		$adminUser = 0;
	    }
	    else
	    {
		$loginerror = "<span style='color:red; font-size:12px;'>Invalid user id or password!</span>";
		$validUser = 0;
		$adminUser = 0;
	    }
	}
	else
	{
	    if($loginid eq ""	&& $loginpass eq "")
	    {
		$loginerror = "";
	    }
	    else
	    {
		$loginerror = "<span style='color:red; font-size:12px;'>Invalid user id or password!</span>";
	    }
	    $validUser = 0;
	    $adminUser = 0;
	}


	if(!$validUser && !$adminUser)
	{
	    # invalid user 

	    $loginpass = "";
	    my $cookieUser = new CGI::Cookie(
		-path => "$PositLogConfig::cgipath",
		-name => "loginid",
		-value => "$loginid",
		);
	    my $cookiePass = new CGI::Cookie(
		-path => "$PositLogConfig::cgipath",
		-name => "loginpass",
		-value => "$loginpass",
		);

	    print $CGI->header(-charset => 'utf-8', -cookie => [$cookieUser,$cookiePass]);
	    &showLoginScreen("", $positlogMode);
	    exit(0);
	}
	else
	{
	    # valid user 

	    my $cookieUser = new CGI::Cookie(
		-path => "$PositLogConfig::cgipath",
		-name => "loginid",
		-value => "$loginid",
		);
	    my $cookiePass = new CGI::Cookie(
		-path => "$PositLogConfig::cgipath",
		-name => "loginpass",
		-value => "$loginpass",
		);
	    print $CGI->header(-charset => 'utf-8', -cookie => [$cookieUser,$cookiePass]);
	}

    }
}


#-------------------------------------------------------------
# Can read?
#-------------------------------------------------------------

my $permissionHash = eval{Storable::lock_retrieve($PositLogConfig::datapath . $pageid . "/permission.cgi")};
if($@){ warn $@; print "Cannot read permission.cgi."; exit(0); }

my $canRead = 0;
if($adminUser)
{
    $canRead = 1;
}
elsif(scalar($permissionHash->{"read_page"}{"public"}) == 1)
{
    $canRead = 1;
}
else
{
    # check user list
    if(scalar($permissionHash->{"read_page"}{$loginid}) == 1)
    {
	$canRead = 1;
    }
    else
    {
	# check user group list
	foreach my $usergroupname (keys %{$permissionHash->{"read_page_group"}})
	{
	    my $usergroupnameenc = $usergroupname;
	    $usergroupnameenc =~ s/([^\w ])/'%' . unpack('H2', $1)/eg;
	    $usergroupnameenc =~ tr/ /+/;

	    my $UserList = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "usergroup_" . $usergroupnameenc . ".cgi")} or {};
	    if($UserList eq ""){print "<div style='text-align: center'>Error! : Cannot open '" . $usergroupname . "' user group.<br>\n</div>\n"; exit(0); };
	    if(scalar($UserList->{$loginid}) == 1)
	    {
		$canRead = 1;
	    }
	}
    }
}

if(!$canRead)
{
    $loginerror = "<span style='color:red; font-size:12px;'>You don't have permission.</span>";
    &showLoginScreen("clearid", "ViewMode");
    exit(0);
}


#-------------------------------------------------------------
# Can edit?
#-------------------------------------------------------------


if($positlogMode eq "EditMode" && $validUser && !$adminUser)
{
    my $canEdit = 0;

    if(
	scalar($permissionHash->{"write_plainsprite"}{$loginid}) == 1
       || scalar($permissionHash->{"write_attachedsprite"}{$loginid}) == 1
       || scalar($permissionHash->{"write_supersprite"}{$loginid}) == 1
	)
    {
	$canEdit = 1;
    }
    else
    {
	# check user group list
	foreach my $usergroupname (keys %{$permissionHash->{"write_plainsprite_group"}})
	{
	    my $usergroupnameenc = $usergroupname;
	    $usergroupnameenc =~ s/([^\w ])/'%' . unpack('H2', $1)/eg;
	    $usergroupnameenc =~ tr/ /+/;

	    my $UserList = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "usergroup_" . $usergroupnameenc . ".cgi")} or {};
	    if($UserList eq ""){print "<div style='text-align: center'>Error! : Cannot open '" . $usergroupname . "' user group.<br>\n</div>\n"; exit(0); };
	    if($UserList->{$loginid} == 1)
	    {
		$canEdit = 1;
	    }
	}
	foreach my $usergroupname (keys %{$permissionHash->{"write_attachedsprite_group"}})
	{
	    my $usergroupnameenc = $usergroupname;
	    $usergroupnameenc =~ s/([^\w ])/'%' . unpack('H2', $1)/eg;
	    $usergroupnameenc =~ tr/ /+/;

	    my $UserList = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "usergroup_" . $usergroupnameenc . ".cgi")} or {};
	    if($UserList eq ""){print "<div style='text-align: center'>Error! : Cannot open '" . $usergroupname . "' user group.<br>\n</div>\n"; exit(0); };
	    if($UserList->{$loginid} == 1)
	    {
		$canEdit = 1;
	    }
	}
	foreach my $usergroupname (keys %{$permissionHash->{"write_supersprite_group"}})
	{
	    my $usergroupnameenc = $usergroupname;
	    $usergroupnameenc =~ s/([^\w ])/'%' . unpack('H2', $1)/eg;
	    $usergroupnameenc =~ tr/ /+/;

	    my $UserList = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "usergroup_" . $usergroupnameenc . ".cgi")} or {};
	    if($UserList eq ""){print "<div style='text-align: center'>Error! : Cannot open '" . $usergroupname . "' user group.<br>\n</div>\n"; exit(0); };
	    if($UserList->{$loginid} == 1)
	    {
		$canEdit = 1;
	    }
	}

    }

    if(!$canEdit)
    {
	$loginerror = "<span style='color:red; font-size:12px;'>You don't have permission.</span>";
	&showLoginScreen("clearid", "EditMode");
	exit(0);
    }

}



#-------------------------------------------------------------
# View Single Sprite
#-------------------------------------------------------------
my $singleSpriteID = $CGI->param("spriteid");
if($singleSpriteID ne "")
{
    my $singleHTML = "<!DOCTYPE html PUBLIC '-//W3C//DTD HTML 4.01 Transitional//EN'\n
   'http://www.w3.org/TR/html4/loose.dtd'>\n
<html lang='ja-JP'>\n
	<head>\n
		<meta http-equiv='Content-Type' content='text/html;charset=UTF-8'>\n
		<meta http-equiv='Content-Style-Type' content='text/css'>\n
		<link rel='stylesheet' href='" . $PositLogConfig::systempath . "positlog_single.css' type='text/css'>\n
		<title>PositLog : $singleSpriteID</title>\n
	</head>\n <body>\n";

    my $singleContents = "no contents";
    my $contents = eval{ Storable::lock_retrieve($PositLogConfig::datapath . $pageid . "/static/" . $singleSpriteID.".spr")} or "";
    if($contents ne "")
    {
	$singleContents = $$contents;
    }

    $singleHTML .= "<div class='positlogsinglesprite'>\n<h1><a href='./positlog.cgi?load=" . $pageid . "&id=" . $singleSpriteID . "'>[ " . $singleSpriteID . " ]</a> in <a href='./positlog.cgi?load=" . $pageid . "'>" . $configHash->{"page_title"} . "</a></h1>\n";
    $singleHTML .= "<p>This page is generated or imported by PositLog</p>\n";
    $singleHTML .= "</div>\n";
    $singleHTML .= $singleContents . "\n";

    $singleHTML .= "</body></html>";

    print $singleHTML;

    exit(0);
}

#-------------------------------------------------------------
# Load Page
#-------------------------------------------------------------

# load serialized page data
my $spritesHash = eval{ Storable::lock_retrieve($PositLogConfig::datapath . $pageid . "/sprites.dat")} or {};

if($spritesHash eq "")
{
    print "Cannot read the sprite list.\n";
    exit(0);
}


my $bodycolor = "#" . $configHash->{"page_bgcolor"};
my $footercolor = "#" . $configHash->{"footer_bgcolor"};
my $worldWidth = $configHash->{"page_width"};
my $worldHeight = $configHash->{"page_height"};

my $sprite_autolink = $configHash->{"sprite_autolink"};
my $sprite_autobr = $configHash->{"sprite_autobr"};
my $sprite_html = $configHash->{"sprite_html"};

if($adminUser)
{
    $sprite_html = 1;
}

my $autolinkValue = 0;
if(!$adminUser && scalar($sprite_html) != 1 && scalar($sprite_autolink) == 1)
{
    $autolinkValue = 1;
}

my $autobrValue = 0;
if(!$adminUser && scalar($sprite_html) != 1 && scalar($sprite_autobr) == 1)
{
    $autobrValue = 1;
}


# ----------------------------
# sub getSpritesFromPlugin
#   executes function dynamically
# ----------------------------

sub getSpritesFromPlugin {
    my ($moduleName, $args) = @_;
    eval 'use ' .$moduleName .';' . $moduleName . q/::getSprites($pageid, $args)/;
}


# ----------------------------
# sub importDynamicSprites
#   returns  (keylist from a module):(and its contents)
# ----------------------------

sub importDynamicSprites
{
    my $moduleBody = "";

    my ($moduleID, $authorName, $zindex, $args) = @_;

    # getSprites(arg1, arg2, ...) returns associative array ("date,spriteid", "contents", ...)
    my $spriteidPlugincontents = &getSpritesFromPlugin("PositLogPlugin::" . $moduleID, $args);

    # current number of sprites
    my $spriteCounter = scalar($zindex);

    # variables for generating new spriteStyle
    my $xcount = 0;
    my $xdiv = $worldWidth / 40 -1;
    my $ycount = 0;
    my $ydiv = $worldHeight / 40 -1;


    # sort by date
    foreach my $keyID (sort {$b cmp $a} keys %$spriteidPlugincontents) {
	# get modified date and spriteID
	$keyID =~ /^(\w+?),(\w+?)$/s;
	my $modified_time = $1;
	my $spriteID = $2;

	# check if existing page data includes style of $spriteID
	my $spriteStyle = $spritesHash->{$spriteID}{"style"};
	if (!$spriteStyle) {
	    # if not, generate new spriteStyle

	    my $newleft = 10;
	    my $newtop = 10;
	    if ($xcount > $xdiv) {
		$xcount = 0;
		$ycount ++;
		if ($ycount > $ydiv) {
		    $ycount = 0;
		}
	    }
	    $newleft += 40 * $xcount;
	    $newtop += 40 * $ycount;

	    $xcount ++;

	    $spriteStyle = "border-left:0px none #000000; border-right:0px none #000000; border-top:0px none #000000; border-bottom:0px none #000000; top:" . $newtop ."px; left:" . $newleft . "px; width:120px;  z-index:" . $spriteCounter . ";";
	}

	# create sprite
	my $valueContents = $spriteidPlugincontents->{$keyID};

	$moduleBody .= "<li class='sprite' id='";
	$moduleBody .= $spriteID;
	$moduleBody .= "' style='" . $spriteStyle . "'>\n";
	$moduleBody .= "<div class='$moduleID'>";
	$moduleBody .= "<div class='spritecontents' id='";
	$moduleBody .= $spriteID;
	$moduleBody .= "_contents'>";
	$moduleBody .= $valueContents;
	$moduleBody .= "</div>\n";

	$moduleBody .= "<div class='spriteinfo'>";

	$moduleBody .= "<span class='spriteauthor' id='";
	$moduleBody .= $spriteID;
	$moduleBody .= "_author'";
	if(scalar($spritesHash->{$spriteID}{"display_author"}) == 1)
	{
	    $moduleBody .= " style='display:block;'>";
	}
	else
	{
	    $moduleBody .= " style='display:none;'>";
	}
	$moduleBody .= $authorName;
	$moduleBody .= "</span>\n";

	$moduleBody .= "<span class='spritetime' id='";
	$moduleBody .= $spriteID;
	$moduleBody .= "_time'";
	if(scalar($spritesHash->{$spriteID}{"display_created_time"}) == 1)
	{
	    $moduleBody .= " style='display:block;'>";
	}
	else
	{
	    $moduleBody .= " style='display:none;'>";
	}
	$modified_time =~ /^(\d\d\d\d)(\d\d)(\d\d)(\d\d)(\d\d)(\d\d)$/i;
	my $timeStr = $1 . "/" . $2 . "/" . $3 . " " . $4 . ":" . $5 . ":" .$6;
	$moduleBody .= $timeStr;
	$moduleBody .= "</span>\n";

	$moduleBody .= "<span class='spritepositlink' id='";
	$moduleBody .= $spriteID;
	$moduleBody .= "_positlink'";
	if(scalar($spritesHash->{$spriteID}{"display_positlink"}) == 1)
	{
	    $moduleBody .= " style='display:block;'>";
	}
	else
	{
	    $moduleBody .= " style='display:none;'>";
	}
	$moduleBody .= "<a href='./positlog.cgi?load=" . $pageid . "&id=" . $spriteID . "'>positlink</a>";
	$moduleBody .= "</span>\n";

	$moduleBody .= "<span class='spritefragmentlink' id='";
	$moduleBody .= $spriteID;
	$moduleBody .= "_fragmentlink'";
	if(scalar($spritesHash->{$spriteID}{"display_fragmentlink"}) == 1)
	{
	    $moduleBody .= " style='display:block;'>";
	}
	else
	{
	    $moduleBody .= " style='display:none;'>";
	}
	$moduleBody .= "<a href='./positlog.cgi?load=" . $pageid . "#" . $spriteID . "'>#</a>";
	$moduleBody .= "</span>\n";


	$moduleBody .= "</div>\n";
	$moduleBody .= "</div>\n";

	$moduleBody .= "</li>";

	$spriteCounter++;
    }


    my $result = $moduleBody;

    # return

    \$result;
}


# ---------------------------
#    Generate HTML BODY
# ---------------------------

# Check user agent
my $useragent = $ENV{'HTTP_USER_AGENT'};

# wzero3 [es]:  Mozilla/4.0 (compatible; MSIE 6.0; Windows CE; SHARP/WS007SH; PPC; 480x640) Opera 8.60 [ja]

my $basefontsize = " ";
if($useragent =~ /SHARP\/WS00.*Opera/gi)
{
    $basefontsize = "font-size: 75%;";
}

my $BODY = "<body id='positlogbody' onLoad='bodyOnLoad()' style='background-color:" . $bodycolor . ";" . $basefontsize . "'>\n\n";

# add controlpanel
if($positlogMode eq "EditMode")
{
    $BODY .= "<div id='controlpanel' style='width: " . $worldWidth ."px;'>"
	. "<div id='newspritebtn'></div>";
    if(scalar($permissionHash->{"create_page"}{$loginid}) == 1 || $adminUser)
    {
	$BODY .= "<div id='newpagebtn'></div>";
    }

# The trouble is that the admin id is displayed in ViewMode
# because positlogadmin.cgi leaves id_cookie.
# $adminUser = 0 and $loginid = admin's id in ViewMode
# after logging into positlogadmin.cgi by admin's id.
# Consequetly, $loginid is displayed in only EditMode.
    
    if($adminUser)
    {
	$BODY .= "<div id='yourid'><a href='./pageproperty.cgi?page=$pageid'>&lt;property&gt;</a>&nbsp;&nbsp;&nbsp;&nbsp;admin's ID</div>";
    }		
    else
    {
	$BODY .= "<div id='yourid'>ID [$loginid]</div>";
    }

    $BODY .= "<div id='controlresult'>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</div>"
	. "</div>\n\n";

}

# add spritesworld (root node of sprites)
my $borderTop = "0px";
if($positlogMode eq "EditMode")
{
    $worldTop = $worldTop + 30;
#    $borderTop = "1px dotted #c0c0c0";
}

# background-color is needed for changing mouse cursor in spritesworld area on IE6
$BODY .= "<div id='spritesworld' style='z-index: 0; left:" . $worldLeft . "px;top:" . $worldTop . "px;width:" . $worldWidth ."px;height:" . $worldHeight . "px; border-top:" . $borderTop .  "; background-color:" . $bodycolor . ";";

my $background_image = $configHash->{'background_image'};
if($background_image ne "")
{
    $BODY .= "background-image:url(\"" . $PositLogConfig::bgimagespath . $background_image . "\");";
}
$BODY .= "background-position:0px 0px;'>";


# ---------------------------
# generate sprites
# ---------------------------

# left and top style must be set here
# to read these style from JavaScript by elm.style 

# attention!! 
# No line feeds (\n) or another characters allowed between <ul> and <li>
# because <ul class="spriteslist"> can include only <li> element.
if($arg_vp ne "" || $arg_id ne "" || $arg_edge ne "")
{
    $BODY .= "\n<ul id='spriteslist' style='left:0px; top:0px; display:none;'>";
}
else
{
    $BODY .= "\n<ul id='spriteslist' style='left:0px; top:0px; display:block;'>";
}

# retrieve sprites in a page

my %spriteidContents;
my %idPosition;

foreach my $keyID (keys %$spritesHash) {
    my $type = $spritesHash->{$keyID}{"type"};
    if($type eq "dynamic")
    {
	next;
    }

    my $valueStyle = $spritesHash->{$keyID}{"style"};
    my $author_id = $spritesHash->{$keyID}{"author_id"};
    my $created_time = $spritesHash->{$keyID}{"created_time"};
    my $display_created_time = $spritesHash->{$keyID}{"display_created_time"};
    my $display_author = $spritesHash->{$keyID}{"display_author"};

    my $display_positlink = $spritesHash->{$keyID}{"display_positlink"};
    my $display_fragmentlink = $spritesHash->{$keyID}{"display_fragmentlink"};

    my $public_author = $spritesHash->{$keyID}{"public_author"};
    my $public_password = $spritesHash->{$keyID}{"public_password"};

    # get position
    $valueStyle =~ /top:(-*\d+)px/is;
    my $spritetop = $1;
    $valueStyle =~ /left:(-*\d+)px/is;
    my $spriteleft = $1;
    $valueStyle =~ /z-index:(-*\d+?);/is;
    my $spriteZindex = $1;

    my $spriteposition = sprintf("%010d:%010d", $spritetop, $spriteleft);
    $idPosition{$keyID} = $spriteposition;


    # get contents
    my $spriteContents = eval{ Storable::lock_retrieve($PositLogConfig::datapath . $pageid . "/static/" . $keyID.".spr")} or "";
    my $staticContents;


    if($spriteContents ne ""){
	$staticContents .= "<li class='sprite' id='";
	$staticContents .= $keyID;
#		$staticContents .= "' name='";
#		$staticContents .= $keyID;
	$staticContents .= "' style='" . $valueStyle . "'>\n";

	$staticContents .= "<div class='spritecontents' id='";
	$staticContents .= $keyID;
	$staticContents .= "_contents'>";
	$staticContents .= $$spriteContents;
	$staticContents .= "</div>\n";

	$staticContents .= "<div class='spriteinfo'>";


	$staticContents .= "<span class='spriteauthor' id='";
	$staticContents .= $keyID;
	$staticContents .= "_author'";
	if(scalar($display_author) == 1)
	{
	    $staticContents .= " style='display:block;'>";
	}
	else
	{
	    $staticContents .= " style='display:none;'>";
	}

	my $authorName = "";
	if($author_id eq "admin")
	{
	    $authorName .= "admin";
	}
	else
	{
	    if($author_id eq "public")
	    {
		if($public_password eq "")
		{
		    if($public_author eq "" || $public_author eq "public")
		    {
			$authorName .= "[public]";
		    }
		    else
		    {
			$authorName .= '[' . $public_author . ']';
		    }
		}
		else
		{
		    if($public_author eq "" || $public_author eq "public")
		    {
			$authorName .= "&lt;public&gt;";
		    }
		    else
		    {
			$authorName .= '&lt;' . $public_author . '&gt;';
		    }
		}

	    }
	    else
	    {
		$authorName .= $useridAuth->{$author_id}{"nickname"};
	    }
	}

	$staticContents .= $authorName;
	$staticContents .= "</span>\n";



	$staticContents .= "<span class='spritetime' id='";
	$staticContents .= $keyID;
	$staticContents .= "_time'";

	if(scalar($display_created_time) == 1)
	{
	    $staticContents .= " style='display:block;'>";
	}
	else
	{
	    $staticContents .= " style='display:none;'>";
	}
	
	$created_time =~ /^(\d\d\d\d)(\d\d)(\d\d)(\d\d)(\d\d)(\d\d)$/i;
	my $timeStr = "";
	if($created_time ne "")
	{
	    $timeStr = $1 . "/" . $2 . "/" . $3 . " " . $4 . ":" . $5 . ":" .$6;
	}

	$staticContents .= $timeStr;
	$staticContents .= "</span>\n";


	$staticContents .= "<span class='spritepositlink' id='";
	$staticContents .= $keyID;
	$staticContents .= "_positlink'";
	if(scalar($display_positlink) == 1)
	{
	    $staticContents .= " style='display:block;'>";
	}
	else
	{
	    $staticContents .= " style='display:none;'>";
	}
	$staticContents .= "<a href='./positlog.cgi?load=" . $pageid . "&id=" . $keyID . "'>positlink</a>";
	$staticContents .= "</span>\n";


	$staticContents .= "<span class='spritefragmentlink' id='";
	$staticContents .= $keyID;
	$staticContents .= "_fragmentlink'";
	if(scalar($display_fragmentlink) == 1)
	{
	    $staticContents .= " style='display:block;'>";
	}
	else
	{
	    $staticContents .= " style='display:none;'>";
	}
	$staticContents .= "<a href='./positlog.cgi?load=" . $pageid . "#" . $keyID . "'>#</a>";
	$staticContents .= "</span>\n";


	$staticContents .= "</div>\n";

	# attention!! 
	# No line feeds (\n) or another characters allowed between </li> and <li>
	# because <ul class="spriteslist"> can include only <li> element.
	$staticContents .= "</li>";


	if($$spriteContents =~ /\[\[(.+?),\s*(.+?)\]\]/is)
	{
	    # import dynamic sprites

	    my $moduleName = "";
	    foreach my $mName (@PositLogConfig::spriteModules){
		if($mName eq $1){
		    $moduleName = $mName;
		}
	    }
	    if($moduleName ne ""){
		# load module
		my $dcontents = &importDynamicSprites($moduleName, $authorName, $spriteZindex, $2);
		$staticContents .= $$dcontents;
	    }
	}

	$spriteidContents{$keyID} = $staticContents;
    }
}

# sort by position (compare top (and left) values)
foreach my $sortedID (sort {$idPosition{$a} <=> $idPosition{$b}} keys %idPosition) {
    $BODY .= $spriteidContents{$sortedID};
}

$BODY .= "</ul>";

# footer of spritesworld
$BODY .= "\n</div>";

# -----------------------------------
#    Generate HTML HEADER 
# -----------------------------------

my $HEADER1 = q{<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"
    "http://www.w3.org/TR/html4/loose.dtd">
    <html lang="ja-JP">
    <head>
    <meta http-equiv="Content-Type" content="text/html;charset=UTF-8">
    <meta http-equiv="Content-Style-Type" content="text/css">
    <meta http-equiv="Content-Script-Type" content="text/javascript">};


$HEADER1 .= "		<script type='text/javascript'>\n<!--\n
 var pageidValue='" . $pageid ."';
 var vpValue='" . $arg_vp ."';
 var idValue='" . $arg_id ."';
 var edgeValue='" . $arg_edge ."';
 var positlogMode='" . $positlogMode ."';
 var IMAGEFILEPATH='" . $PositLogConfig::systempath ."';
 var CGIFILEPATH='" . $PositLogConfig::cgipath ."';
 var spritehtmlValue='" . $sprite_html ."';
 var autobrValue='" . $autobrValue ."';
 var autolinkValue='" . $autolinkValue ."';
// -->\n		</script>\n";

$HEADER1 .= "		<script type='text/javascript' src='" .  $PositLogConfig::systempath . "positlog.js' charset='UTF-8'></script>\n";


my $CSSHEADER = "";

foreach my $cssfile (@PositLogConfig::cssFiles) {
    $CSSHEADER .= "		<link rel='stylesheet' href='" .  $PositLogConfig::systempath . $cssfile ."' type='text/css'>\n";
}

my $pagetitle = "		<title>" . $configHash->{"page_title"} . "</title>\n";

my $HEADER2 = "</head>\n";

my $HEADER = $HEADER1 . $CSSHEADER .  $pagetitle . $HEADER2;


# ---------------------------
#    Generate HTML FOOTER
# ---------------------------

#my $FOOTER = "<div id='footer' style='top:" . ($worldTop + $worldHeight + 5)  . "px; width: ". $worldWidth . "px; background-color: $footercolor'>";
my $FOOTER = "<div id='footer' style='position: fixed; bottom: 0px; width: ". $worldWidth . "px; background-color: $footercolor; display:block;'>";

$FOOTER .= "<span id='homeposition'><a href='./positlog.cgi?load=" . $pageid;
if($positlogMode eq "EditMode")
{
    $FOOTER .= "&mode=EditMode";
}
$FOOTER .= "'>[Top]</a></span>";

$FOOTER .= "<span id='login'>";

if($positlogMode eq "EditMode")
{
    $FOOTER .= "&nbsp;&nbsp;<a href='./positlog.cgi?load=" . $pageid . "&mode=ViewMode'>[View]</a>";
}
elsif($positlogMode eq "ViewMode")
{
    if($loginid eq "public")
    {
	if(scalar($permissionHash->{"write_plainsprite"}{"public"}) == 1
	   ||scalar($permissionHash->{"write_attachedsprite"}{"public"}) == 1
	   || scalar($permissionHash->{"write_supersprite"}{"public"}) == 1)
	{
	    $FOOTER .= "&nbsp;&nbsp;<a href='./positlog.cgi?load=" . $pageid . "&mode=EditMode'>[Edit]</a>";
	}
    }
    else
    {
	$FOOTER .= "&nbsp;&nbsp;<a href='./positlog.cgi?load=" . $pageid . "&mode=EditMode'>[Edit]</a>";
    }

}

if($loginid ne "public")
{
    $FOOTER .= "&nbsp;&nbsp;";
    $FOOTER .= "<a href='./positlog.cgi?load=" . $pageid . "&mode=Logout'>[Logout]</a>";
    $FOOTER .= "&nbsp;&nbsp;";
    $FOOTER .= "<a href='./positlogadmin.cgi'>[Admin]</a>";
}
else
{
    $FOOTER .= "&nbsp;&nbsp;";
    $FOOTER .= "<a href='./positlog.cgi?load=" . $pageid . "&mode=Login'>[Login]</a>";
}

$FOOTER .= "&nbsp;&nbsp;";
$FOOTER .= "</span>";

$FOOTER .= "url : <span id='currentposition'> </span>&nbsp;&nbsp;";
$FOOTER .= "<span id='copyright'>&lt; <a href='http://storybook.jp/'>PositLog 0.2</a> &gt;</span></div>\n\n";


my $CLOSE .= "</body>\n</html>";




# print out

print $HEADER . $BODY . $FOOTER . $CLOSE;

