#!/usr/local/bin/perl

# --------------------------------------------------------
#
# clearCache.cgi:
#      cgi for clear cache of dynamic sprites
#  (tested under perl 5.8.4)
#
# Copyright (c) 2006 Hidekazu Kubota (Taro Sosui) All right reserved
#  <taro@summer.nifty.jp> 
#   http://positlog.storybook.jp/
#
# --------------------------------------------------------

# --------------------------------------------------------
# This file is part of PositLog.
# --------------------------------------------------------


use strict;
use CGI qw/-debug :standard/;
use Storable qw(lock_retrieve lock_nstore);   # is default library (upper perl 5.8)
use PositLogConfig;

my $CGI = new CGI;
print $CGI->header(-charset => 'utf-8'); # HTTP header

my $pageid = $CGI->param("pageid");

my $sourceID = $CGI->param("sourceID");

my $plugin = $CGI->param("plugin");
$plugin =~ /^(.+?),(.+?)$/is;
my $pluginName = "PositLogPlugin::" . $1;
my $args = $2;

# Read temporal cookie
my $loginid = $CGI->cookie("loginid") || "";
my $loginpass = $CGI->cookie("loginpass") || "";

#---------------------------
# authentication
#---------------------------
my $usernameAuth = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "authentication.cgi")} or {};
my $adminnameAuth = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "key.cgi")} or {};
my $loginerror = "";
my $validUser = 0;
my $adminUser = 0;
my $publicUser = 0;
if($adminnameAuth ne "" && $adminnameAuth->{$loginid})
{
	my $cryptpass = $adminnameAuth->{$loginid}{"password"};
	my $salt="lc";
	my $cryptpass2 = crypt($loginpass, $salt);
	if($cryptpass eq $cryptpass2)
	{
		$validUser = 1;
		$adminUser = 1;
		$publicUser = 0;
	}
	else
	{
		print "Permission denied.";
		exit(0);	
	}
}
elsif($usernameAuth ne "" && $usernameAuth->{$loginid})
{
	my $cryptpass = $usernameAuth->{$loginid}{"password"};
	my $salt="ry";
	my $cryptpass2 = crypt($loginpass, $salt);
	if($cryptpass eq $cryptpass2)
	{
		$adminUser = 0;
		$validUser = 1;
		$publicUser = 0;
	}
	else
	{
		print "Permission denied.";
		exit(0);	
	}
}
else
{
	$adminUser = 0;
	$validUser = 0;
	$publicUser = 1;
}


#------------------------------
# check page permission
#------------------------------

my $permissionHash = eval{Storable::lock_retrieve($PositLogConfig::datapath . $pageid . "/permission.cgi")} or {};
if($permissionHash eq ""){ print "Cannot read permission.cgi.";	exit(0); }

my $write_plainsprite = 0;
my $write_attachedsprite = 0;
my $write_supersprite = 0;
if($adminUser || scalar($permissionHash->{"write_plainsprite"}{$loginid}) == 1)
{
	$write_plainsprite = 1;
}
foreach my $usergroupname (keys %{$permissionHash->{"write_plainsprite_group"}})
{
	my $usergroupnameenc = $usergroupname;
	$usergroupnameenc =~ s/([^\w ])/'%' . unpack('H2', $1)/eg;
	$usergroupnameenc =~ tr/ /+/;

	my $tmpList = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "usergroup_" . $usergroupnameenc . ".cgi")} or {};
	if(scalar($tmpList->{$loginid}) == 1)
	{
		$write_plainsprite = 1;		
	}
}

if($adminUser || scalar($permissionHash->{"write_attachedsprite"}{$loginid}) == 1)
{
	$write_attachedsprite = 1;
}
foreach my $usergroupname (keys %{$permissionHash->{"write_attachedsprite_group"}})
{
	my $usergroupnameenc = $usergroupname;
	$usergroupnameenc =~ s/([^\w ])/'%' . unpack('H2', $1)/eg;
	$usergroupnameenc =~ tr/ /+/;

	my $tmpList = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "usergroup_" . $usergroupnameenc . ".cgi")} or {};
	if(scalar($tmpList->{$loginid}) == 1)
	{
		$write_attachedsprite = 1;		
	}
}

if($adminUser || scalar($permissionHash->{"write_supersprite"}{$loginid}) == 1)
{
	$write_supersprite = 1;
}
foreach my $usergroupname (keys %{$permissionHash->{"write_supersprite_group"}})
{
	my $usergroupnameenc = $usergroupname;
	$usergroupnameenc =~ s/([^\w ])/'%' . unpack('H2', $1)/eg;
	$usergroupnameenc =~ tr/ /+/;

	my $tmpList = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "usergroup_" . $usergroupnameenc . ".cgi")} or {};
	if(scalar($tmpList->{$loginid}) == 1)
	{
		$write_supersprite = 1;		
	}
}

if($write_plainsprite != 1 && $write_attachedsprite != 1 && $write_supersprite != 1)
{
	print "Permission denied.";
	exit(0);
}



#---- The following processes are performed by only authenticated user -----

# HTML or plain text processing
if($write_supersprite)
{
    print eval 'use ' .$pluginName .';' . $pluginName . q/::clearCache($pageid, $sourceID, $args)/;
}
else
{
	print "Permission denied.";
}


