/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.tool;

import java.sql.Timestamp;

public class Logger {
    public static final int LOG_ERROR = 1;
    public static final int LOG_WARNING = 2;
    public static final int LOG_NOTICE = 3;
    public static final int LOG_LOG = 4;
    public static final int LOG_DEBUG = 5;
    public static final int LOG_TRACE = 10;
    private static int level = 4;
    private static boolean withTimestamp = false;

    public static void setLevel(int l) {
        level = l;
    }

    private static void println(String prefix, String msg) {
        String t = "";
        if (withTimestamp) {
            Timestamp ts = new Timestamp(System.currentTimeMillis());
            t = ts.toString() + " ";
        }
        System.out.println(t + prefix + ": " + msg);
    }

    public static void println(String msg) {
        System.out.println(msg);
    }

    public static void warning(String msg) {
        if (level >= 2) {
            Logger.println("WARNING", msg);
        }
    }

    public static void debug(String msg) {
        if (level >= 5) {
            Logger.println("DEBUG", msg);
        }
    }

    public static void error(String msg) {
        if (level >= 1) {
            Logger.println("ERROR", msg);
        }
    }

    public static void notice(String msg) {
        if (level >= 3) {
            Logger.println("NOTICE", msg);
        }
    }

    public static void detail(String msg) {
        Logger.println("DETAIL", msg);
    }

    public static void trace(Exception e) {
        if (level >= 10) {
            e.printStackTrace();
        }
    }
}

