/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.tool.cli.action;

import java.util.ArrayList;
import org.postgresforest.tool.Logger;
import org.postgresforest.tool.lib.ForestToolException;
import org.postgresforest.tool.lib.GSCdata;
import org.postgresforest.tool.lib.GT;
import org.postgresforest.tool.lib.Instance;
import org.postgresforest.tool.util.CommandParser;
import org.postgresforest.tool.util.MessagesCommandLine;
import org.postgresforest.tool.util.Table2StringUtil;

public class GscActions {
    private static String[] SHOW_GSC_HEADER = new String[]{"DBNAME", "HOST", "PORT", "SERVERID"};

    public static void make(String hostname, String portno, String gscname, String username, String userpass) {
        try {
            GSCdata.initialize((String)hostname, (String)portno, (String)gscname, (String)username, (String)userpass);
            Logger.notice((String)GT.tr((String)"GSC \"{0}\" \u3092\u4f5c\u6210\u3057\u307e\u3057\u305f\u3002", (String)gscname));
        }
        catch (ForestToolException e) {
            Logger.error((String)GT.tr((String)"GSC \"{0}\" \u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (String)gscname));
            Logger.detail((String)e.getDetail().getMessage());
            Logger.trace((Exception)e.getDetail());
        }
    }

    public static void create(CommandParser cp, GSCdata gsc) {
        int id = -1;
        try {
            id = Integer.parseInt((String)cp.getServer().get(0));
        }
        catch (NumberFormatException e) {
            Logger.error((String)GT.tr((String)"\u5165\u529b\u3055\u308c\u305f\u30b5\u30fc\u30d0ID \"{0}\" \u306f\u4e0d\u6b63\u3067\u3059\u3002", (String)((String)cp.getServer().get(0))));
            Logger.detail((String)e.getMessage());
            Logger.trace((Exception)e);
            return;
        }
        boolean force = cp.isForce();
        Instance instance = gsc.getInstance(id);
        if (instance == null) {
            Logger.error((String)GT.tr((String)"\u30b5\u30fc\u30d0ID \"{0}\" \u306e\u30b5\u30fc\u30d0\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002", (String)((String)cp.getServer().get(0))));
            return;
        }
        String gscName = gsc.getGscName();
        int serverid = instance.getId();
        if (!gsc.copy(instance, force)) {
            Logger.error((String)GT.tr((String)"GSC \"{0}\" \u306e\u30b5\u30fc\u30d0ID \"{1}\" \u3078\u306e\u8907\u88fd\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (String)gsc.getGscName(), (String)Integer.toString(serverid)));
            return;
        }
        Logger.notice((String)GT.tr((String)"GSC \"{0}\" \u3092\u30b5\u30fc\u30d0ID \"{1}\" \u3078\u8907\u88fd\u3057\u307e\u3057\u305f\u3002", (String)gsc.getGscName(), (String)Integer.toString(serverid)));
    }

    public static void drop(CommandParser cp, GSCdata gsc) {
        int id = -1;
        try {
            id = Integer.parseInt((String)cp.getServer().get(0));
        }
        catch (NumberFormatException e) {
            Logger.error((String)GT.tr((String)"\u5165\u529b\u3055\u308c\u305f\u30b5\u30fc\u30d0ID \"{0}\" \u306f\u4e0d\u6b63\u3067\u3059\u3002", (String)((String)cp.getServer().get(0))));
            Logger.detail((String)e.getMessage());
            Logger.trace((Exception)e);
            return;
        }
        Instance instance = gsc.getInstance(id);
        if (instance == null) {
            Logger.error((String)GT.tr((String)"\u30b5\u30fc\u30d0ID \"{0}\" \u306e\u30b5\u30fc\u30d0\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002", (String)((String)cp.getServer().get(0))));
            return;
        }
        if (!gsc.drop(instance)) {
            Logger.error((String)GT.tr((String)"GSC \"{0}\" \u306e\u30b5\u30fc\u30d0ID \"{1}\" \u304b\u3089\u306e\u524a\u9664\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (String)gsc.getGscName(), (String)Integer.toString(instance.getId())));
            return;
        }
        Logger.notice((String)GT.tr((String)"GSC \"{0}\" \u3092\u30b5\u30fc\u30d0ID \"{1}\" \u304b\u3089\u524a\u9664\u3057\u307e\u3057\u305f\u3002", (String)gsc.getGscName(), (String)Integer.toString(instance.getId())));
    }

    public static void check(GSCdata gsc) {
        boolean ok = true;
        int[] ids = gsc.getGscInstances();
        for (int i = 0; i < ids.length; ++i) {
            Instance ins = gsc.getInstance(ids[i]);
            if (gsc.equals(ins)) continue;
            Logger.error((String)GT.tr((String)"GSC \"{0}\" \u306e\u5185\u5bb9\u304c\u30b5\u30fc\u30d0ID \"{1}\" \u3068\u540c\u4e00\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002", (String)gsc.getGscName(), (String)Integer.toString(ins.getId())));
            ok = false;
        }
        if (!gsc.validate(3)) {
            Logger.error((String)GT.tr((String)"\u30c6\u30fc\u30d6\u30eb\u5b9a\u7fa9\u3042\u308b\u3044\u306f\u30ec\u30b3\u30fc\u30c9\u306e\u5185\u5bb9\u304c\u540c\u4e00\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002"));
            ok = false;
        }
        if (ok) {
            Logger.notice((String)GT.tr((String)"GSC\u304a\u3088\u3073\u30c6\u30fc\u30d6\u30eb\u306e\u5185\u5bb9\u306b\u76f8\u9055\u306f\u3042\u308a\u307e\u305b\u3093\u3002"));
        }
    }

    public static void show(GSCdata gsc) {
        int[] ids = gsc.getGscInstances();
        if (ids == null) {
            Logger.error((String)GT.tr((String)"\u30b5\u30fc\u30d0ID\u3092\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3002"));
            return;
        }
        Logger.println((String)MessagesCommandLine.getString("cui.message.gsc.show"));
        Table2StringUtil table2StringUtil = new Table2StringUtil(SHOW_GSC_HEADER);
        for (int i = 0; i < ids.length; ++i) {
            int id = ids[i];
            Instance instance = gsc.getInstance(id);
            if (instance == null) {
                Logger.error((String)MessagesCommandLine.getString("cui.error.gsc.show"));
                return;
            }
            ArrayList<Object> row = new ArrayList<Object>();
            row.add(gsc.getGscName());
            row.add(instance.getHostName());
            row.add(instance.getPortNumber());
            row.add(new Integer(instance.getId()));
            table2StringUtil.addRow(row);
        }
        table2StringUtil.print();
    }
}

