/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.tool.cli.action;

import java.util.ArrayList;
import org.postgresforest.tool.Logger;
import org.postgresforest.tool.lib.ForestToolException;
import org.postgresforest.tool.lib.GSCdata;
import org.postgresforest.tool.lib.GT;
import org.postgresforest.tool.lib.Instance;
import org.postgresforest.tool.util.CommandParser;
import org.postgresforest.tool.util.MessagesCommandLine;
import org.postgresforest.tool.util.Table2StringUtil;

public class InstanceActions {
    private static final String[] SHOW_INSTANCE_HEADER = new String[]{"SERVERID", "HOST", "PORT", "STATUS"};
    public static final int SERVER_RUNNING = 1;
    public static final int SERVER_TROUBLE = -1;

    public static void create(CommandParser cp, GSCdata gsc) {
        String host = cp.getHost();
        if (host == null || host.equals("")) {
            Logger.error((String)GT.tr((String)"\u30db\u30b9\u30c8\u540d\u307e\u305f\u306fIP\u30a2\u30c9\u30ec\u30b9\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002"));
            return;
        }
        String port = cp.getPort();
        if (port == null || port.equals("")) {
            Logger.error((String)GT.tr((String)"\u30dd\u30fc\u30c8\u756a\u53f7\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002"));
            return;
        }
        Instance instance = gsc.registerInstance(host, port);
        if (instance == null) {
            Logger.error((String)GT.tr((String)"\u30b5\u30fc\u30d0 \"{0}:{1}\" \u306e\u767b\u9332\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (String)host, (String)port));
            return;
        }
        if (!instance.setStatus(1)) {
            Logger.error((String)GT.tr((String)"\u30b5\u30fc\u30d0 \"{0}\" \u306e\u30b9\u30c6\u30fc\u30bf\u30b9\u5909\u66f4\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (String)Integer.toString(instance.getId())));
            return;
        }
        Logger.notice((String)GT.tr((String)"\u30b5\u30fc\u30d0 \"{0}:{1}\" \u3092\u767b\u9332\u3057\u307e\u3057\u305f\u3002", (String)host, (String)port));
    }

    public static void drop(CommandParser cp, GSCdata gsc) {
        String id = (String)cp.getServer().get(0);
        int instanceId = 0;
        if (id == null || id.equals("")) {
            Logger.error((String)GT.tr((String)"\u30b5\u30fc\u30d0ID\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002"));
            return;
        }
        try {
            instanceId = Integer.parseInt(id);
        }
        catch (NumberFormatException e) {
            Logger.error((String)GT.tr((String)"\u6307\u5b9a\u3055\u308c\u305f\u30b5\u30fc\u30d0ID\u304c\u4e0d\u6b63\u3067\u3059\u3002"));
            return;
        }
        if (gsc.getInstance(instanceId) == null) {
            Logger.error((String)GT.tr((String)"\u30b5\u30fc\u30d0ID \"{0}\" \u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002", (String)id));
            return;
        }
        if (gsc.unregisterInstance(instanceId)) {
            Logger.notice((String)GT.tr((String)"\u30b5\u30fc\u30d0ID \"{0}\" \u306e\u524a\u9664\u3092\u884c\u3044\u307e\u3057\u305f\u3002", (String)id));
            return;
        }
        Logger.error((String)GT.tr((String)"\u30b5\u30fc\u30d0ID \"{0}\" \u306e\u524a\u9664\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (String)id));
    }

    public static void show(GSCdata gsc) {
        int[] ids = null;
        try {
            ids = gsc.getInstanceIds();
        }
        catch (ForestToolException e) {
            Logger.error((String)GT.tr((String)"\u30b5\u30fc\u30d0ID\u4e00\u89a7\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002"));
            Logger.error((String)e.getDetail().getMessage());
            Logger.trace((Exception)e.getDetail());
            return;
        }
        System.out.println(MessagesCommandLine.getString("cui.message.instance.show"));
        Table2StringUtil table2StringUtil = new Table2StringUtil(SHOW_INSTANCE_HEADER);
        if (ids != null) {
            for (int i = 0; i < ids.length; ++i) {
                int id = ids[i];
                Instance instance = gsc.getInstance(id);
                if (instance == null) {
                    Logger.error((String)GT.tr((String)"\u30b5\u30fc\u30d0ID \"{0}\" \u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f\u3002", (String)Integer.toString(id)));
                    return;
                }
                ArrayList<Object> row = new ArrayList<Object>();
                row.add(new Integer(instance.getId()));
                row.add(instance.getHostName());
                row.add(instance.getPortNumber());
                row.add(InstanceActions.convertStatus(instance.getStatus()));
                table2StringUtil.addRow(row);
            }
        }
        table2StringUtil.print();
    }

    public static void set(CommandParser cp, GSCdata gsc, int status) {
        int id;
        try {
            id = Integer.parseInt((String)cp.getServer().get(0));
        }
        catch (NumberFormatException e) {
            Logger.error((String)GT.tr((String)"\u5165\u529b\u3055\u308c\u305f\u30b5\u30fc\u30d0ID\u306f\u4e0d\u6b63\u3067\u3059\u3002"));
            return;
        }
        Instance instance = gsc.getInstance(id);
        if (instance == null) {
            Logger.error((String)GT.tr((String)"\u30b5\u30fc\u30d0ID \"{0}\" \u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f\u3002", (String)Integer.toString(id)));
            return;
        }
        if (instance.getStatus() == status) {
            Logger.notice((String)GT.tr((String)"\u30b5\u30fc\u30d0ID \"{0}\" \u306e\u30b9\u30c6\u30fc\u30bf\u30b9\u306f\u5909\u66f4\u3055\u308c\u307e\u305b\u3093\u3002", (String)Integer.toString(id)));
            return;
        }
        if (!instance.setStatus(status)) {
            Logger.error((String)GT.tr((String)"\u30b5\u30fc\u30d0ID \"{0}\" \u306e\u30b9\u30c6\u30fc\u30bf\u30b9\u5909\u66f4\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (String)Integer.toString(id)));
            return;
        }
        Logger.notice((String)GT.tr((String)"\u30b5\u30fc\u30d0ID \"{0}\" \u306e\u30b9\u30c6\u30fc\u30bf\u30b9\u3092 \"{1}\" \u306b\u5909\u66f4\u3057\u307e\u3057\u305f\u3002", (String)Integer.toString(id), (String)InstanceActions.convertStatus(status)));
    }

    private static String convertStatus(int status) {
        String ret = "";
        ret = status == 1 ? GT.tr((String)"\u7a3c\u50cd\u4e2d") : (status == -1 ? GT.tr((String)"\u969c\u5bb3\u4e2d") : GT.tr((String)"\u4e0d\u660e"));
        return ret;
    }
}

