/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.tool.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class Table2StringUtil {
    private ArrayList m_Header;
    private ArrayList m_Rows;
    private int[] m_colmunLengths;

    public Table2StringUtil(ArrayList header) {
        this.m_Header = header;
        this.m_colmunLengths = new int[this.m_Header.size()];
        this.setColumnLength(this.m_Header);
        this.m_Rows = new ArrayList();
    }

    public Table2StringUtil(Object[] header) {
        this(new ArrayList<Object>(Arrays.asList(header)));
    }

    public void addRow(ArrayList row) {
        this.setColumnLength(row);
        this.m_Rows.add(row);
    }

    public void addRow(Object[] row) {
        ArrayList<Object> listRow = new ArrayList<Object>(Arrays.asList(row));
        this.addRow(listRow);
    }

    private void setColumnLength(ArrayList row) {
        for (int i = 0; i < this.m_colmunLengths.length; ++i) {
            String column = String.valueOf(row.get(i));
            int lenb = this.getLenB(column);
            if (lenb <= this.m_colmunLengths[i]) continue;
            this.m_colmunLengths[i] = lenb;
        }
    }

    private int getLenB(String column) {
        int lenb = 0;
        for (int j = 0; j < column.length(); ++j) {
            char c = column.charAt(j);
            lenb += c < '\u0100' ? 1 : 2;
        }
        return lenb;
    }

    private String putLine(ArrayList row, boolean hedear) {
        StringBuffer outPutStringBuffer = new StringBuffer();
        for (int i = 0; i < this.m_colmunLengths.length; ++i) {
            if (i > 0) {
                outPutStringBuffer.append('|');
            }
            outPutStringBuffer.append(' ');
            Object value = row.get(i);
            String column = String.valueOf(value);
            int fillLen = this.m_colmunLengths[i] - this.getLenB(column);
            char[] fill = new char[fillLen];
            Arrays.fill(fill, ' ');
            if (hedear) {
                int length = outPutStringBuffer.length();
                outPutStringBuffer.append(fill);
                outPutStringBuffer.insert(length + fillLen / 2, column);
            } else if (value instanceof Number) {
                outPutStringBuffer.append(fill);
                outPutStringBuffer.append(column);
            } else {
                outPutStringBuffer.append(column);
                outPutStringBuffer.append(fill);
            }
            outPutStringBuffer.append(' ');
        }
        return outPutStringBuffer.toString();
    }

    public String toString() {
        StringBuffer putString = new StringBuffer();
        putString.append(this.putLine(this.m_Header, true));
        putString.append('\n');
        char[] line = new char[putString.length() - 1];
        Arrays.fill(line, '-');
        putString.append(line);
        putString.append('\n');
        Iterator iter = this.m_Rows.iterator();
        while (iter.hasNext()) {
            ArrayList row = (ArrayList)iter.next();
            putString.append(this.putLine(row, false));
            putString.append('\n');
        }
        return putString.toString();
    }

    public void print() {
        System.out.println(this.toString());
    }
}

