SET CLIENT_ENCODING TO 'euc_jp';

CREATE TYPE postgresforest.ConstraintData AS (
	conname			name,	--̾
	concategory		smallint,	--ֹ
	attnum			smallint,	--оݥ
	targetcolumn	smallint[],	--оݥֹ
	description		text	--ܺ
);

/* --------------------------------------------------------------
 * 
 * CopyColumn(name, name)
 * 
 * param $1 : ԡơ֥̾
 * param $2 : ԡơ֥̾
 * 
 * return : RET_SUCCESS := 0;
 *          RET_FAIL := 1;
 *          RET_SRCTBLNOTFOUND := 2;
 *          RET_DESTTBLEXIST := 3;
 *
 * To call this func:
 *     SELECT ret FROM postgresforest('srcTbl','destTbl') AS ret;
 * --------------------------------------------------------------
 */
CREATE OR REPLACE FUNCTION postgresforest.CopyColumn(name,name) RETURNS integer as '
DECLARE
	RET_SUCCESS constant integer := 0;
	RET_FAIL constant integer := 1;
	
	srcTbl ALIAS FOR $1;
	destTbl ALIAS FOR $2;
BEGIN
	--publicΥơ֥Τߤо
	EXECUTE ''SET search_path TO public,pg_catalog'';
	
	DECLARE
		rule bool;
		subclass bool;
	BEGIN
		SELECT INTO rule, subclass relhasrules, relhassubclass FROM pg_class WHERE relname = srcTbl;
		
		--ơ֥˥֥饹ƤϽ
		IF subclass = ''t''
		THEN
			--EXCEPTION֤Ƥޤȡ֤ͤʤʤäƤޤ
			--RAISE EXCEPTION ''There are inheritances on table "%". Please drop them.'', srcTbl;

			RAISE WARNING ''There are inheritances on table "%". Please drop them.'', srcTbl;
			return RET_FAIL;

		--ơ֥˥롼뤬ƤϷٹȯԤ³
		ELSE
			IF rule = ''t''
			THEN
				RAISE WARNING ''There are rules on table "%".'', srcTbl;
			END IF;
		END IF;
	END;
	
	--̵꤬Хơ֥򥳥ԡ(srcTbl -> destTbl)
	EXECUTE ''CREATE TABLE public.'' ||destTbl ||'' ( LIKE '' ||srcTbl ||'' )'';
	
	--ǽŪ˥å
	--ԡȥԡǰۤʤäƤ
	DECLARE
		srcCols pg_class.relnatts%TYPE;
		destCols pg_class.relnatts%TYPE;
	BEGIN
		SELECT INTO srcCols relnatts FROM pg_class WHERE relname = srcTbl;
		SELECT INTO destCols relnatts FROM pg_class WHERE relname = destTbl;
		
		IF srcCols <> destCols
		THEN
			--destTbl
			EXECUTE ''DROP TABLE public.'' ||destTbl;
			
			--EXCEPTION֤Ƥޤȡ֤ͤʤʤäƤޤ
			--RAISE EXCEPTION ''COPY TABLE % TO % FAILED'', srcTbl,destTbl;
			
			RAISE WARNING ''COPY TABLE % TO % FAILED'', srcTbl,destTbl;
			RAISE WARNING ''srcTbl has % columns but destTbl has %. '', srcCols,destCols;
			
			RETURN RET_FAIL;
		END IF;
	END;

	RETURN RET_SUCCESS;
END;
' LANGUAGE plpgsql;




/* --------------------------------------------------------------
 * 
 * ExtractConstraint(name)
 * 
 * param $1 : Фơ֥̾
 * 
 * return : SETOF postgresforest.ConstraintData;
 *
 * To call this func:
 *     SELECT conname, concategory, targetcolomn, description
 *     FROM postgresforest.ExtractConstraint('srcTbl');
 * --------------------------------------------------------------
 */
CREATE OR REPLACE FUNCTION postgresforest.ExtractConstraint(name) RETURNS SETOF postgresforest.ConstraintData as '
DECLARE
	--return
	conData postgresforest.ConstraintData;

	catPk constant int2 := 1; --Primary Key
	catFk constant int2 := 2; --Foreign Key
	catChk constant int2 := 3; --Check
	catInd constant int2 := 4; --Index
	catUni constant int2 := 5; --Unique
	catDef constant int2 := 6; --Default
	catComm constant int2 := 7; --Comment	7

	srcTbl ALIAS FOR $1;
	relOid oid;
BEGIN
	--publicΥơ֥Τߤо
	EXECUTE ''SET search_path TO public,pg_catalog'';
	
	--srcTblOIDФ
	SELECT INTO relOid oid FROM pg_class
	WHERE relname = srcTbl AND 
		  relnamespace = (SELECT oid FROM pg_namespace WHERE nspname = ''public'') ;
	
	
	--ǥμФ(Ʊ˥ץ饤ޥꥭˡФ)
	DECLARE
		rec RECORD;
	BEGIN
	--indkey:ǥĥ륫ࡣʣϤǤˤ٤
	--indnkeys:ʣϤ륤ǥۤݤоݥ
		FOR rec IN EXECUTE ''SELECT ''
		                     ||''coalesce(c.conname, t.relname) as indexrelname, ''
		                     ||''i.indkey, ''
		                     ||''t.relnatts as indnkeys, ''
		                     ||''coalesce(c.contype, ''''0'''') as contype, ''
		                     ||''pg_catalog.pg_get_indexdef(i.indexrelid) as usingdef ''
		                 ||''FROM pg_catalog.pg_index i JOIN pg_catalog.pg_class t ON (t.oid = i.indexrelid) ''
		                     ||''LEFT JOIN pg_catalog.pg_depend d ON (d.classid = t.tableoid AND d.objid = t.oid AND d.deptype = ''''i'''') ''
		                     ||''LEFT JOIN pg_catalog.pg_constraint c ON (d.refclassid = c.tableoid AND d.refobjid = c.oid) ''
		                 ||''WHERE i.indrelid = '' || relOid ||''::pg_catalog.oid ''
		                 ||''ORDER BY indexrelname''
		LOOP
			conData.conname := rec.indexrelname;

			--̤Ƚ(PK | UNIQUE | ñINDEX)
			IF rec.contype = ''p''
			THEN
				conData.concategory := catPk;
			ELSIF rec.contype = ''u''
			THEN
				conData.concategory := catUni;
			ELSIF rec.contype = ''0''
			THEN
				conData.concategory := catInd;
			END IF;
			
			--USINGʹߤμФ
			conData.description = rec.usingdef;
			
			--оݥμФ
			
			DECLARE
				cnt integer := 0;
				elem smallint;
			BEGIN
				WHILE cnt < rec.indnkeys
				LOOP
					elem := rec.indkey[cnt];
					IF cnt = 0 THEN
						conData.attnum := 1;
						conData.targetcolumn := ''{''||elem||''}'';
					ELSE
						conData.attnum := conData.attnum + 1;
						conData.targetcolumn[cnt+1] := elem;
					END IF;
					cnt := cnt + 1;
				END LOOP;
			END;
	
			RETURN NEXT conData;
		END LOOP;
	END;
	
	--FKμФ
	--  TODO:
	--  1:1λȤΤߤФо(PostgreSQLǤʣФưĤFK)
	--    EX)
	--  MATCHϥǥեȤ"MATCH SIMPLE"ΤߤФо
	--  ON DELETE/ON UPDATEϥǥեȤ"NO ACTION"ΤߤФо
	DECLARE
		rec RECORD;
	BEGIN
		FOR rec IN EXECUTE ''SELECT conname, conkey, pg_catalog.pg_get_constraintdef(oid) as condef ''
		                   ||''FROM pg_catalog.pg_constraint ''
		                   ||''WHERE conrelid = '' || reloid || ''::pg_catalog.oid AND ''
		                   ||''contype = ''''f'''' ''
		LOOP
			conData.conname := rec.conname;
			conData.concategory = catFk;
			conData.attnum := 1;
			conData.targetcolumn = rec.conkey;
			conData.description = rec.condef;
			
			RETURN NEXT conData;
		END LOOP;
	END;
	
	--CHECK
	DECLARE
		rec RECORD;
	BEGIN
		--ʸ򤽤Τޤ޼Ф
		--ʸ˥󥰥륯Ȥ硢򥨥פ(ץ쥤)
		FOR rec IN EXECUTE ''SELECT conname, conkey, ''
		                   ||''replace(pg_catalog.pg_get_constraintdef(c1.oid),''''\\\\'''''''',''''\\\\\\\\\\\\'''''''') AS consrc ''
		                   ||''FROM pg_catalog.pg_constraint c1 ''
		                   ||''WHERE conrelid = '' || reloid || ''::pg_catalog.oid and contype = ''''c'''' ''
		                   ||''ORDER BY conname'' 
		LOOP
			conData.conname := rec.conname;
			conData.concategory = catChk;
			conData.attnum := 1;
			conData.targetcolumn = rec.conkey;
			conData.description = rec.consrc;
			
			RETURN NEXT conData;
		END LOOP;

	END;
	
	--DEFAULT
	DECLARE
		rec RECORD;
	BEGIN
		FOR rec IN EXECUTE ''SELECT adnum, ''
		                   ||''replace(pg_catalog.pg_get_expr(adbin, adrelid),''''\\\\'''''''',''''\\\\\\\\\\\\'''''''') AS adsrc ''
		                   ||''FROM pg_catalog.pg_attrdef ''
		                   ||''WHERE adrelid = ''
		                   ||reloid
		                   ||''::pg_catalog.oid''
		LOOP
			--DEFAULT̾դʤΤDEFAULT̾Ȥ(ºݤˤϻѤʤ)
			conData.conname := ''DEFAULT'';
			conData.concategory := catDef;
			conData.attnum := 1;
			conData.targetcolumn := ''{''|| rec.adnum ||''}'';
			conData.description := rec.adsrc;
			RETURN NEXT conData;
		END LOOP;
	END;
	
	--COMMENTФ
	--  ƥФ륳ȤΤ
	DECLARE
		rec RECORD;
	BEGIN
		FOR rec IN EXECUTE ''SELECT replace(description,''''\\\\'''''''',''''\\\\\\\\\\\\'''''''') as description, objsubid ''
		                   ||''FROM pg_catalog.pg_description ''
		                   ||''WHERE objoid = ''||reloid||''::pg_catalog.oid and ''
		                   ||''objsubid != 0 and classoid = ''''pg_catalog.pg_class''''::pg_catalog.regclass ''
		                   ||''ORDER BY objoid, classoid, objsubid''
		LOOP
			--COMMENT̾դʤΤCOMMENT̾Ȥ(ºݤˤϻѤʤ)
			conData.conname := ''COMMENT'';
			conData.concategory := catComm;
			conData.attnum := 1;
			conData.targetcolumn := ''{''|| rec.objsubid ||''}'';
			conData.description := rec.description;
			RETURN NEXT conData;
		END LOOP;
	END;

	
	RETURN;
END;
' LANGUAGE plpgsql;

/* --------------------------------------------------------------
 * 
 * AddaptConstraint(name)
 * 
 * param $1 : ̾:name
 * param $2 : ֹ:smallint
 * param $3 : оݥ:smallint
 * param $4 : оݥ̾:smallint[]
 * param $5 : ܺ:text
 * param $6 : ղơ֥̾:name
 * 
 * return : RET_SUCCESS := 0;
 *          RET_FAIL := 1;
 *          RET_DESTTBLNOTFOUND := 3;
 *
 * To call this func:
 *     SELECT ret FROM postgresforest.AddaptConstraint('ConName',1,1,'{2}','description','desttbl');
 *     (ƥϥ㥹Ȥɬפ礬Τ)
 * --------------------------------------------------------------
 */
CREATE OR REPLACE FUNCTION postgresforest.AddaptConstraint(name, smallint, smallint, smallint[], text, name) RETURNS integer as '
DECLARE
	--return
	RET_SUCCESS constant integer := 0;
	RET_FAIL constant integer := 1;
	
	conname ALIAS FOR $1;
	concategory ALIAS FOR $2;
	attnum ALIAS FOR $3;
	targetcolumn ALIAS FOR $4;
	description ALIAS FOR $5;
	destTbl  ALIAS FOR $6;
	
	catPk constant int2 := 1; --Primary Key
	catFk constant int2 := 2; --Foreign Key
	catChk constant int2 := 3; --Check
	catInd constant int2 := 4; --Index
	catUni constant int2 := 5; --Unique
	catDef constant int2 := 6; --Default
	catComm constant int2 := 7; --Comment
	
	cnt integer := 1;
	attr name[];
	inattr name;
	relOid oid;
	stmt text;
BEGIN
	--publicΥơ֥Τߤо
	EXECUTE ''SET search_path TO public,pg_catalog'';
	
	--destTblOIDФ
	SELECT INTO relOid oid FROM pg_class
	WHERE relname = destTbl AND 
		  relnamespace = (SELECT oid FROM pg_namespace WHERE nspname = ''public'') ;
	
	
	-- descriptionͤѤ(FK, CHECK, INDEX)
	-- INDEXоݥơ֥롢ѹ
	-- ------> targetcolumnϻѤʤ 
	IF concategory = catFk OR concategory = catChk THEN
	
		stmt := ''ALTER TABLE '' || destTbl;
		stmt := stmt ||'' ADD CONSTRAINT "'' || conname ||''" ''||description;

	ELSIF concategory = catInd THEN
		DECLARE
			uni int;
			using text;
		BEGIN
			-- CREATE UNIQUE INDEXʸǺ줿Ϥ
			RAISE NOTICE ''desc -> %'',description;
			SELECT INTO uni position(''unique'' in lower(description));
			SELECT INTO using substring(description from position(''using'' in lower(description)));
			RAISE NOTICE ''uni -> %'',uni;
			RAISE NOTICE ''using -> %'',using;
			
			IF uni = 0 THEN
				--UNIQUE INDEXǤ̵
				stmt := ''CREATE INDEX ''|| conname ||'' ON ''||destTbl||'' ''||using;
			ELSE
				--UNIQUE INDEX
				stmt := ''CREATE UNIQUE INDEX ''|| conname ||'' ON ''||destTbl||'' ''||using;
			END IF;
		END;
		
	-- targetcolumn饫̾ФDDL(PK, UNIQUE, DEFAULT, COMMENT)
	-- ------> descriptionϻѤʤ 

	--Primary Key
	ELSIF concategory = catPk THEN
	
		--PK̾Ϥʤ֥륯ȤǤʤȥ󥿥顼Ȥʤ
		stmt := ''ALTER TABLE '' || destTbl ||'' ADD CONSTRAINT "''|| conname ||''" PRIMARY KEY ( '';
RAISE NOTICE ''stmt -> %'',stmt;
		
		-- ̾Ф(ʣ)
		cnt := 1;
		WHILE cnt <= attnum
		LOOP
			SELECT INTO inattr a.attname FROM pg_attribute a
				WHERE a.attrelid = relOid::pg_catalog.oid AND a.attnum = targetcolumn[cnt]::pg_catalog.int2;
			
			IF cnt = 1
			THEN
				stmt := stmt || inattr;
			ELSE
				stmt := stmt || '', '' || inattr;
			END IF;
			cnt := cnt + 1;
		END LOOP;
RAISE NOTICE ''stmt -> %'',stmt;
		
		
		stmt := stmt || '' )'';
RAISE NOTICE ''stmt -> %'',stmt;
		

	--UNIQUE
	ELSIF concategory = catUni THEN
		stmt := ''ALTER TABLE '' || destTbl || '' ADD CONSTRAINT '' || conname ||'' UNIQUE ( '';
		
		-- ̾Ф(ʣ)
		cnt := 1;
		WHILE cnt <= attnum
		LOOP
			SELECT INTO inattr a.attname FROM pg_attribute a
				WHERE a.attrelid = relOid::pg_catalog.oid AND a.attnum = targetcolumn[cnt]::pg_catalog.int2;
			
			IF cnt = 1
			THEN
				stmt := stmt || inattr;
			ELSE
				stmt := stmt || '', '' || inattr;
			END IF;
			cnt := cnt + 1;
		END LOOP;
		
		stmt := stmt || '' )'';
		
	ELSIF concategory = catDef THEN
		-- ̾Ф(ñ쥫)
		SELECT INTO inattr a.attname FROM pg_attribute a
			WHERE a.attrelid = relOid::pg_catalog.oid AND a.attnum = targetcolumn[1]::pg_catalog.int2;
		stmt := ''ALTER TABLE ''||destTbl||'' ALTER COLUMN ''||inattr||'' SET DEFAULT '' ||description;
		
	ELSIF concategory = catComm THEN
		-- ̾Ф(ñ쥫)
		SELECT INTO inattr a.attname FROM pg_attribute a
			WHERE a.attrelid = relOid::pg_catalog.oid AND a.attnum = targetcolumn[1]::pg_catalog.int2;
		stmt := ''COMMENT ON COLUMN ''||destTbl||''.''||inattr||'' IS ''''''||description||'''''''';
	END IF;
	
	RAISE LOG ''PostgresForest stmt -> %'',stmt;
	
	EXECUTE stmt;
	
	RETURN RET_SUCCESS;
	
END;
' language plpgsql;
