/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.tool;

import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/**
 * The main plugin class to be used in the desktop.
 */
public class ForestToolPlugin extends AbstractUIPlugin {
	//The shared instance.
	private static ForestToolPlugin plugin;
	//Resource bundle.
	private ResourceBundle resourceBundle;

	
	public static final String IMG_CHECKED = "checked";
	public static final String IMG_UNCHECKED = "unchecked";
	public static final String IMG_RUN = "run";
	public static final String IMG_STOP = "stop";
	public static final String IMG_DATABASE = "database";
	public static final String IMG_DATABASES = "databases";
	public static final String IMG_TABLE = "table";
	public static final String IMG_TABLES = "tables";
	public static final String IMG_SERVER_STATUS = "server_status";
	public static final String IMG_GSC = "gsc";
	public static final String IMG_INSTACE = "instance";
	public static final String IMG_USER = "user";
	public static final String IMG_CONFIG = "config";
	public static final String IMG_HASH = "hash";
	
	
	public static final String IMG_TABLE_NOPRIMARY = "noprimary_table";
	public static final String IMG_TABLE_VIEW = "view";
	public static final String IMG_TABLE_TYPE0 = "type0";
	public static final String IMG_TABLE_TYPE1 = "type1";
	public static final String IMG_TABLE_TYPE2 = "type2";
	
	/**
	 * The constructor.
	 */
	public ForestToolPlugin() {
		super();
		plugin = this;
		try {
			resourceBundle = ResourceBundle.getBundle("org.postgresforest.tool.ForestToolPluginResources");
		} catch (MissingResourceException x) {
			resourceBundle = null;
		}
	}

	/**
	 * This method is called upon plug-in activation
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
	}

	/**
	 * This method is called when the plug-in is stopped
	 */
	public void stop(BundleContext context) throws Exception {
		super.stop(context);
	}

	/**
	 * Returns the shared instance.
	 */
	public static ForestToolPlugin getDefault() {
		return plugin;
	}

	/**
	 * Returns the string from the plugin's resource bundle,
	 * or 'key' if not found.
	 */
	public static String getResourceString(String key) {
		ResourceBundle bundle = ForestToolPlugin.getDefault().getResourceBundle();
		try {
			return (bundle != null) ? bundle.getString(key) : key;
		} catch (MissingResourceException e) {
			return key;
		}
	}

	/**
	 * Returns the plugin's resource bundle,s
	 */
	public ResourceBundle getResourceBundle() {
		return resourceBundle;
	}
	/**
	 * vOCNXێImageRegistryɃC[Wo^܂B
	 * 
	 * @param registry ImageRegistryIuWFNg
	 */
	protected void initializeImageRegistry(ImageRegistry registry) {
		this.registerImage(registry, IMG_CHECKED, "ID047.gif");
		this.registerImage(registry, IMG_UNCHECKED, "ID048.gif");
		this.registerImage(registry, IMG_RUN, "ID013.gif");
		this.registerImage(registry, IMG_STOP, "ID012.gif");
		this.registerImage(registry, IMG_DATABASE, "ID059.gif");
		this.registerImage(registry, IMG_DATABASES, "ID005.gif");
		this.registerImage(registry, IMG_TABLE, "ID042.gif");
		this.registerImage(registry, IMG_TABLES, "ID041.gif");
		this.registerImage(registry, IMG_SERVER_STATUS, "ID002.gif");
		this.registerImage(registry, IMG_GSC, "ID003.gif");
		this.registerImage(registry, IMG_INSTACE, "ID004.gif");
		this.registerImage(registry, IMG_USER, "ID007.gif");
		this.registerImage(registry, IMG_CONFIG, "ID008.gif");
		this.registerImage(registry, IMG_HASH, "ID009.gif");
		
		//MASUCOMMENT 摜ǉ
		this.registerImage(registry, IMG_TABLE_NOPRIMARY, "ID042_no.gif");
		this.registerImage(registry, IMG_TABLE_VIEW, "ID042_vw.gif");
		this.registerImage(registry, IMG_TABLE_TYPE0, "ID042_t0.gif");
		this.registerImage(registry, IMG_TABLE_TYPE1, "ID042_t1.gif");
		this.registerImage(registry, IMG_TABLE_TYPE2, "ID042_t2.gif");
	}
	
	
	/**
	 * ImageRegistryɃC[Wo^܂B
	 * 
	 * @param registry ImageRegistryIuWFNg
	 * @param key 擾L[
	 * @param fileName C[Wt@C
	 */
	private void registerImage(ImageRegistry registry, String key, String fileName) {
		try {
			URL	url = new URL(getDefault().getBundle().getEntry("/"), "icons/" + fileName);
			ImageDescriptor desc = ImageDescriptor.createFromURL(url);
			registry.put(key, desc);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
}
