/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.tool.action;

import java.sql.SQLException;
import java.util.ArrayList;

import org.postgresforest.tool.bean.TableInfo;
import org.postgresforest.tool.db.GSCdata;
import org.postgresforest.tool.db.UserData;

/**
 * TODO ̐ꂽ^Rg̃ev[gύXɂ͎փWv: EBhE - ݒ - Java - R[hEX^C -
 * R[hEev[g
 */
public class PartitionAction extends ActionBase {

	
	private UserData m_userData;
	
	
	
	
	/**
	 * @param gsc
	 */
	public PartitionAction(GSCdata gsc,String dbName) {
		super(gsc);
		//[U[f[^NX擾
		m_userData = new UserLoginMng(gsc).getUserDb(dbName);

		
	}
	/**
	 * CX^X폜
	 * 
	 */
	public boolean del(TableInfo tableInfo)  {

		boolean  ret = false;
		//͏擾

		
		String dbName = m_userData.getDbName();		
		String tableName = tableInfo.getName();
		
		try {
			if (!connect(m_gsc ) || !connect(m_userData )) {
				return ret; 
			}
			
			//CX^XXg쐬
			ArrayList serverList = tableInfo.getServer();
			int partitionCount = tableInfo.getPartCount();

			//--------------
			// GSCփp[eBVݒ
			//--------------
			if (!m_gsc.releasePartition(dbName, tableName, serverList)) {
				m_gsc.rollback();
				setAccessErrs(m_gsc );
				return ret; 
			}

			//----------------
			//GSCXVXV
			//----------------
			if (!m_gsc.updateConfigDate()) {
				m_gsc.rollback();
				setAccessErrs(m_gsc);
				return ret; 
			}

			//--------------
			// [UDBփp[eBVe[ủs
			//--------------
			if(tableInfo.getPartType() == TableInfo.TYPE_PARTITION_2){
				ret = m_userData.releasePartition2(tableName, partitionCount,serverList);
			}else{
				ret = m_userData.releasePartition(tableName, partitionCount);
			}

			if (ret != true) {
				m_gsc.rollback();
				m_userData.rollback();
				setAccessErrs(m_userData);
				return ret; 
			}
			
			
			m_gsc.commit();
			m_userData.commit();

			ret = true;

		} finally {
			m_gsc.close();
			m_userData.close();
			if( m_gsc.isErrInfo() ){
				setAccessErrs(m_gsc);
				return false;
			}
			if( m_userData.isErrInfo() ){
				setAccessErrs(m_userData);
				return false;
			}
			
		}

		return ret; 

		
	}

	public boolean make(boolean dataShift, int partCount, TableInfo tableInfo, String newHashName )  {

		boolean  ret = false;


		
		//f[^x[X擾
		String dbName = m_userData.getDbName();	

		
		try {
			//f[^x[X֐ڑ
			if (!connect(m_gsc ) || !connect(m_userData )) {
				return ret;
			}

			//--------------
			// GSCփp[eBVݒ
			//--------------
			if(tableInfo.getPartType() == TableInfo.TYPE_PARTITION_2){
				ret = m_gsc.setPartition2(dbName, tableInfo, partCount, newHashName);
			}else{
				ret = m_gsc.setPartition(dbName, tableInfo, partCount, newHashName);
			}
			if (ret != true) {
				m_gsc.rollback();
				setAccessErrs(m_gsc);
				return ret;
			}

			//----------------
			//GSCXVXV
			//----------------
			if (!m_gsc.updateConfigDate()) {
				m_gsc.rollback();
				setAccessErrs(m_gsc);
				return ret; 
			}

			
			//--------------
			// nbV֐C[W擾
			//--------------
			byte[] hashImage;
			try {
				hashImage = m_gsc.getHashImage(newHashName);
			} catch (SQLException e) {
				m_gsc.rollback();
				setAccessErrs(m_gsc);
				return ret;
			}
			
			
			
			//--------------
			// [UDBփp[eBVe[u̍쐬
			//--------------
			if(tableInfo.getPartType() == TableInfo.TYPE_PARTITION_2){
				ret = m_userData.setPartition2(tableInfo, partCount, dataShift, newHashName, hashImage);
			}else{
				ret = m_userData.setPartition(tableInfo, partCount, dataShift, newHashName, hashImage);
			}
			if (ret != true) {
				m_gsc.rollback();
				m_userData.rollback();
				setAccessErrs(m_userData);
				return ret;
			}
			m_gsc.commit();
			m_userData.commit();

		} finally {
			m_gsc.close();
			m_userData.close();
			if( m_gsc.isErrInfo() ){
				setAccessErrs(m_gsc);
				return false;
			}
			if( m_userData.isErrInfo() ){
				setAccessErrs(m_userData);
				return false;
			}
		}
		return true;
	}

	
	public boolean repartition(int partCount,TableInfo tableInfo, String newHashName )  {

		 String dbName = m_userData.getDbName();
		
		try {
			if (!connect(m_gsc ) || !connect(m_userData )) {
				return false;
			}
			
			//--------------
			// GSCփp[eBVݒ
			//--------------
			if (!m_gsc.rePartition(dbName, tableInfo, partCount)) {
				m_gsc.rollback();
				setAccessErrs(m_gsc );
				return false;
			}

			//----------------
			//GSCXVXV
			//----------------
			if (!m_gsc.updateConfigDate()) {
				m_gsc.rollback();
				setAccessErrs(m_gsc);
				return false;
			}


			//--------------
			// nbV֐C[W擾
			//--------------
			byte[] hashImage;
			try {
				hashImage = m_gsc.getHashImage(newHashName);
			} catch (SQLException e) {
				m_gsc.rollback();
				setAccessErrs(m_gsc);
				return false;
			}

			//--------------
			// [UDBփp[eBVe[ũp[eBVs
			//--------------
			if (!m_userData.rePartition(tableInfo, partCount,newHashName,hashImage)) {
				m_gsc.rollback();
				m_userData.rollback();
				setAccessErrs(m_userData );
				return false;
			}
			m_gsc.commit();
			m_userData.commit();


		} finally {
			m_gsc.close();
			m_userData.close();
			if( m_gsc.isErrInfo() ){
				setAccessErrs(m_gsc);
				return false;
			}
			if( m_userData.isErrInfo() ){
				setAccessErrs(m_userData);
				return false;
			}
		}

		return true;
		
		
	}

}