package org.postgresforest.tool.commandline.action;

import java.util.ArrayList;
import java.util.Iterator;

import org.postgresforest.tool.action.UserMngAction;
import org.postgresforest.tool.bean.UserInfo;
import org.postgresforest.tool.db.GSCdata;
import org.postgresforest.tool.util.CommandParser;
import org.postgresforest.tool.util.MessagesCommandLine;

/**
 * [Uւ̃R}hCc[p̃ANV񋟂NX
 */
public class UserActions {

	private static final String PASS_OPTION_NAME = "pass"; //$NON-NLS-1$
	private static final String DBAUTH_OPTION_NAME = "dbauth"; //$NON-NLS-1$
	private static final String USRAUTH_OPTION_NAME = "usrauth"; //$NON-NLS-1$
	private static final String PASS_ENCRYPTED = "ENCRYPTED"; //$NON-NLS-1$
	private static final String PASS_UNENCRYPTED = "UNENCRYPTED"; //$NON-NLS-1$
	private static final String DBAUTH_CREATEDB = "CREATEDB"; //$NON-NLS-1$
	private static final String DBAUTH_NOCREATEDB = "NOCREATEDB"; //$NON-NLS-1$
	private static final String USRAUTH_CREATEUSR = "CREATEUSER"; //$NON-NLS-1$
	private static final String USRAUTH_NOCREATEUSR = "NOCREATEUSER"; //$NON-NLS-1$
	private static final String PARAM_OFF = "0"; //$NON-NLS-1$
	private static final String PARAM_ON = "1"; //$NON-NLS-1$
	
	/**
	 * [U̍쐬
	 * @param cp R}h͌
	 * @param gsc GSCw̐ڑ
	 */	
	public void create(CommandParser cp, GSCdata gsc) {

		//[U[쐬͏擾
		String user = (String)cp.getUser().get(0);
		String password = (String)cp.getPass().get(0);
		String passwordOption = PASS_ENCRYPTED;
		String createDbOption = DBAUTH_CREATEDB;
		String createUserOption = USRAUTH_CREATEUSR;
		ArrayList paramNames = cp.getParamName();
		ArrayList paramValues = cp.getParamValue();
		for (int i=0; i<paramNames.size(); i++) {
			String paramName = (String)paramNames.get(i);
			if (paramName.compareToIgnoreCase(PASS_OPTION_NAME) == 0) {
				String parmValue = (String)paramValues.get(i);
				if (parmValue.equals(PARAM_OFF)) {
					passwordOption = PASS_UNENCRYPTED;					
				} else if (parmValue.equals(PARAM_ON)) {
					passwordOption = PASS_ENCRYPTED;					
				} else {
					System.out.println(MessagesCommandLine.getString("cui.error.commandparser.param.invalid")); //$NON-NLS-1$
					return;
				}
			} else if (paramName.compareToIgnoreCase(DBAUTH_OPTION_NAME) == 0) {
				String parmValue = (String)paramValues.get(i);
				if (parmValue.equals(PARAM_OFF)) {
					createDbOption = DBAUTH_NOCREATEDB;
				} else if (parmValue.equals(PARAM_ON)) {
					createDbOption = DBAUTH_CREATEDB;					
				} else {
					System.out.println(MessagesCommandLine.getString("cui.error.commandparser.param.invalid")); //$NON-NLS-1$
					return;
				}
			} else if (paramName.compareToIgnoreCase(USRAUTH_OPTION_NAME) == 0) {
				String parmValue = (String)paramValues.get(i);
				if (parmValue.equals(PARAM_OFF)) {
					createUserOption = USRAUTH_NOCREATEUSR;
				} else if (parmValue.equals(PARAM_ON)) {
					createUserOption = USRAUTH_CREATEUSR;					
				} else {
					System.out.println(MessagesCommandLine.getString("cui.error.commandparser.param.invalid")); //$NON-NLS-1$
					return;
				}
			} else {
				System.out.println(MessagesCommandLine.getString("cui.error.commandparser.param.invalid")); //$NON-NLS-1$
				return;
			}
		}

		//[U[쐬
		UserMngAction addUser = new UserMngAction(gsc);
		try {
			boolean result = false;
			result = addUser.addUser(user, password, passwordOption, createDbOption, createUserOption);
			if (result) {
				System.out.println(MessagesCommandLine.getString("cui.message.user.create", new Object[] {user})) ; //$NON-NLS-1$
				return;
			}
		} catch (Exception e1) {
			System.err.println(e1);
		}
		System.out.println(MessagesCommandLine.getString("cui.error.user.create", new Object[] {user})) ; //$NON-NLS-1$
	}
	
	/**
	 * [U̍폜
	 * @param cp R}h͌
	 * @param gsc GSCw̐ڑ
	 */	
	public void drop(CommandParser cp, GSCdata gsc) {
		String user = (String)cp.getUser().get(0);
		//[U[폜
		if(user != ""){ //$NON-NLS-1$
			UserMngAction userMng = new UserMngAction(gsc);
			try {
				if (userMng.delUser(user)){
					System.out.println(MessagesCommandLine.getString("cui.message.user.drop", new Object[] {user}) ); //$NON-NLS-1$
					return;
				}
			} catch (Exception e1) {
				System.err.println(e1);
			}
		}
		System.out.println(MessagesCommandLine.getString("cui.error.user.drop, new Object[] {user}") ); //$NON-NLS-1$
	}
		
	/**
	 * [U̕\
	 * @param gsc GSCw̐ڑ
	 */	
	public void show(GSCdata gsc) {
		ArrayList list = null;
		//
		UserMngAction userMng = new UserMngAction(gsc);
		try {
			list = userMng.getUserList();
		} catch (Exception e) {
			System.out.println(MessagesCommandLine.getString("cui.error.user.show")) ; //$NON-NLS-1$
			e.printStackTrace();
			return;
		}
		
		//[U\
		System.out.println(MessagesCommandLine.getString("cui.message.user.show")) ; //$NON-NLS-1$
		Iterator it = list.iterator();
		System.out.println(" USERNAME\t| ATTRIBUTE"); //$NON-NLS-1$
		System.out.println("----------------------------------------------"); //$NON-NLS-1$
		while (it.hasNext()) {
			UserInfo usrInfo = (UserInfo)it.next();
			System.out.print(usrInfo.getName() + "\t| "); //$NON-NLS-1$
			System.out.println(usrInfo.getAttribute());
		}		
	}
}
