package org.postgresforest.tool.lib;

/**
 * ライブラリ内で発生する例外のラッパークラス。
 *
 * ライブラリからのメッセージを保持するとともに、
 * 内部で発生した例外オブジェクトを detail メンバに
 * 保持する。
 *
 * フロントエンドは、getDetail()メソッドを使用して、
 * 原因となったエラーの例外オブジェクト（SQLExceptionなど）に
 * アクセスする。
 */
public class ForestToolException extends Exception {
	Exception detail = null;

	ForestToolException()
	{
		super();
	}

	ForestToolException(String msg)
	{
		super(msg);
	}

	ForestToolException(Exception e)
	{
		super(e);
	}

	ForestToolException(String msg, Exception e)
	{
		super(msg);

		detail = e;
	}

	public Exception getDetail()
	{
		return detail;
	}
}
