package org.postgresforest.tool.tests;

import java.io.*;
import java.sql.*;
import junit.framework.*;

import org.postgresforest.tool.Logger;
import org.postgresforest.tool.lib.BrokenLog;
import org.postgresforest.tool.lib.Config;
import org.postgresforest.tool.lib.Instance;
import org.postgresforest.tool.lib.GSCdata;
import org.postgresforest.tool.lib.HashInfo;
import org.postgresforest.tool.lib.ForestToolException;

/*
 * 試験内容
 *  - パーティション関数の登録
 *  - パーティション関数名の取得
 *  - パーティション関数情報の取得（名前指定）
 *  - パーティション関数の削除
 *  - BrokenLogの取得
 *  - BrokenLogの消去
 */
public class TestGSCdata4 extends ForestToolTestCase {

	public void setUp()
	{
	}

	public void tearDown()
	{
	}

	/*
	 * パーティション関数の登録
	 */
    public void testRegisterHash001()
    {
		GSCdata gsc = null;

		initializeGSC();

		try {
            gsc = new GSCdata("localhost", "9998", "gsctest",
							  user, pass);
            assertTrue(gsc!=null);

			byte[] b = { 0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9 };

			assertTrue( gsc.registerHash("testhash", "this is a test", b) );

			gsc.close();
		}
        catch (ForestToolException e)
        {
			System.out.println(e.getMessage());
			fail();
        }
	} 

	/*
	 * パーティション関数名一覧の取得
	 */
    public void testGetHashNames001()
    {
		GSCdata gsc = null;

		try {
            gsc = new GSCdata("localhost", "9998", "gsctest",
							  user, pass);
            assertTrue(gsc!=null);

			String[] names = gsc.getHashNames();
			assertTrue( names.length==1 );
			assertTrue( names[0].equals("testhash") );

			gsc.close();
		}
        catch (ForestToolException e)
        {
			System.out.println(e.getMessage());
			fail();
        }
	} 

	/*
	 * パーティション関数情報の取得（名前指定）
	 */
    public void testGetHash001()
    {
		GSCdata gsc = null;

		try {
            gsc = new GSCdata("localhost", "9998", "gsctest",
							  user, pass);
            assertTrue(gsc!=null);

			HashInfo hash = gsc.getHash("testhash");
			assertTrue( hash!=null );
			assertTrue( hash.getId().equals("testhash") );
			assertTrue( hash.getDescription().equals("this is a test") );

			byte[] b = hash.getClassImage();

			assertTrue( b[0]==0 );
			assertTrue( b[1]==1 );
			assertTrue( b[2]==2 );
			assertTrue( b[3]==3 );
			assertTrue( b[4]==4 );
			assertTrue( b[5]==5 );
			assertTrue( b[6]==6 );
			assertTrue( b[7]==7 );
			assertTrue( b[8]==8 );
			assertTrue( b[9]==9 );
			assertTrue( b[10]==0 );
			assertTrue( b[11]==1 );
			assertTrue( b[12]==2 );
			assertTrue( b[13]==3 );
			assertTrue( b[14]==4 );
			assertTrue( b[15]==5 );
			assertTrue( b[16]==6 );
			assertTrue( b[17]==7 );
			assertTrue( b[18]==8 );
			assertTrue( b[19]==9 );

			gsc.close();
		}
        catch (ForestToolException e)
        {
			System.out.println(e.getMessage());
			fail();
        }
	} 

	/*
	 * パーティション関数情報の削除（名前指定）
	 */
    public void _testUnregisterHash001()
    {
		GSCdata gsc = null;

		try {
            gsc = new GSCdata("localhost", "9998", "gsctest",
							  user, pass);
            assertTrue(gsc!=null);

			boolean rc = gsc.unregisterHash("testhash");
			assertTrue( rc==true );

			assertTrue( gsc.getHashNames().length==0 );

			gsc.close();
		}
        catch (ForestToolException e)
        {
			System.out.println(e.getMessage());
			fail();
        }
	} 

	/*
	 * BrokenLogの取得
	 */
    public void testGetBrokenLogs001()
    {
		GSCdata gsc = null;

		try {
            gsc = new GSCdata("localhost", "9998", "gsctest",
							  user, pass);
            assertTrue(gsc!=null);

			BrokenLog[] bb = gsc.getBrokenLogs();
			assertTrue( bb.length==0 );

			gsc.close();
		}
        catch (ForestToolException e)
        {
			System.out.println(e.getMessage());
			fail();
        }
	} 

	/*
	 * BrokenLogの取得（エントリあり）
	 */
    public void testGetBrokenLogs002()
    {
		GSCdata gsc = null;

		executeUpdatePG("localhost", "9998", "gsctest",
						"INSERT INTO forest_brokenlog(serverid, datetime, client, msg, status, query) VALUES (0, '2006/1/1 12:34:56', 'localhost', 'Broken', 'XX001', 'TEST')");


		try {
            gsc = new GSCdata("localhost", "9998", "gsctest",
							  user, pass);
            assertTrue(gsc!=null);

			BrokenLog[] bb = gsc.getBrokenLogs();

			assertTrue( bb.length==1 );
			assertTrue( bb[0].getServerId()==0 );
			assertTrue( bb[0].getTimestamp().toString().equals("2006-01-01 12:34:56.0") );
			assertTrue( bb[0].getClient().equals("localhost") );
			assertTrue( bb[0].getMessage().equals("Broken") );
			assertTrue( bb[0].getState().equals("XX001") );
			assertTrue( bb[0].getQuery().equals("TEST") );

			gsc.close();
		}
        catch (ForestToolException e)
        {
			System.out.println(e.getMessage());
			fail();
        }
	} 

	/*
	 * BrokenLogの消去
	 */
    public void testClearBrokenLogs001()
    {
		GSCdata gsc = null;

		try {
            gsc = new GSCdata("localhost", "9998", "gsctest",
							  user, pass);
            assertTrue(gsc!=null);

			gsc.clearBrokenLogs();

			BrokenLog[] bb = gsc.getBrokenLogs();
			assertTrue(bb.length==0);

			gsc.close();
		}
        catch (ForestToolException e)
        {
			System.out.println(e.getMessage());
			fail();
        }
	} 

	public static void main(String[] args)
	{
		junit.textui.TestRunner.run(TestGSCdata4.class);
	}
}
