#!/bin/sh

. ./common/test_init_gsc.sh | tee result

. ./common/dropdb.sh tpcw
. ./common/dropdb.sh testdb1
. ./common/dropdb.sh testdb2
. ./common/dropdb.sh testdb3
. ./common/dropdb.sh testdb4

./run_tool.sh<<EOF
show instance;
create instance ${HOST_1} ${PORT_1};
show instance;
create instance ${HOST_2} ${PORT_2};
show instance;
create instance ${HOST_3} ${PORT_3};
show instance;

check gsc;

show db;
create db testdb1(0,1);
show db;
create db testdb2(0,1);
show db;

open db testdb1;
create table t1 ( uid integer primary key, name text not null );
show table;
close db;

open db testdb2;
create table t1 ( uid integer primary key, name text not null );
show table;
close db;

open db testdb1;
part table t1 (uid) 2;
show table;
show table t1;
close db;

open db testdb2;
part table t1 (uid) 2;
show table;
show table t1;
close db;

EOF
